/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.properties.DerivedProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MultiPropertyKeyAdapter {
    private final Properties properties;
    private final Map updatedPropertyKeys = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiPropertyKeyAdapter(Properties propertiesToAdapt) {
        Properties properties = new Properties();
        Properties properties2 = propertiesToAdapt;
        synchronized (properties2) {
            properties.putAll((Map<?, ?>)propertiesToAdapt);
        }
        this.properties = properties;
    }

    public boolean propertyExists(String key) {
        if (key == null) {
            return false;
        }
        return this.properties.containsKey(key);
    }

    public void setKeyMapping(Object mappedkey, String mainKey) {
        if (mainKey == null || mappedkey == null) {
            throw new NullPointerException("Key(s) can't be null");
        }
        if (!this.updatedPropertyKeys.containsKey(mainKey)) {
            ArrayList<Object> mappedkeys = new ArrayList<Object>();
            if (!mappedkeys.contains(mappedkey)) {
                mappedkeys.add(mappedkey);
                this.updatedPropertyKeys.put(mainKey, mappedkeys);
            }
        } else {
            List mappedkeys = (List)this.updatedPropertyKeys.get(mainKey);
            mappedkeys.add(mappedkey);
        }
    }

    public Properties getAdaptedProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        this.updatePropertyKeys(copy);
        return copy;
    }

    public String getMappedPropertyValue(String mainKey) {
        if (mainKey == null) {
            throw new NullPointerException("Key can't be null");
        }
        List mappedKeys = (List)this.updatedPropertyKeys.get(mainKey);
        String propertyValue = this.getValueAsPerPrecedence(mappedKeys, this.properties);
        return propertyValue;
    }

    private String getSystemPropertyValue(String key) {
        if (key == null) {
            return null;
        }
        return System.getProperty(key);
    }

    private void updatePropertyKeys(Properties properties) {
        Iterator iter = this.updatedPropertyKeys.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String mainKey = (String)entry.getKey();
            List mappedKeys = (List)entry.getValue();
            String propertyValue = this.getValueAsPerPrecedence(mappedKeys, properties);
            if (propertyValue == null) continue;
            properties.put(mainKey, propertyValue);
        }
    }

    private String getValueAsPerPrecedence(List keysInPrecedenceOrder, Properties properties) {
        String mappedkey;
        DerivedProperty prop;
        Object mappedKey;
        String propertyValue = null;
        int i = 0;
        while (i < keysInPrecedenceOrder.size()) {
            mappedKey = keysInPrecedenceOrder.get(i);
            if (mappedKey instanceof DerivedProperty) {
                prop = (DerivedProperty)mappedKey;
                propertyValue = this.getSystemPropertyValue(prop.getPropertyName());
            } else {
                mappedkey = (String)mappedKey;
                propertyValue = this.getSystemPropertyValue(mappedkey);
                if (propertyValue != null && propertyValue.length() > 0) {
                    properties.remove(mappedkey);
                }
            }
            if (propertyValue != null && propertyValue.length() > 0) break;
            ++i;
        }
        if (propertyValue == null) {
            i = 0;
            while (i < keysInPrecedenceOrder.size()) {
                mappedKey = keysInPrecedenceOrder.get(i);
                if (mappedKey instanceof DerivedProperty) {
                    prop = (DerivedProperty)mappedKey;
                    propertyValue = prop.getValue();
                } else {
                    mappedkey = (String)mappedKey;
                    propertyValue = (String)properties.remove(mappedkey);
                }
                if (propertyValue != null && propertyValue.length() > 0) break;
                ++i;
            }
        }
        return propertyValue;
    }
}

