/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.StringUtils;
import com.wily.util.adt.AttributesStringDictionaryReader;
import com.wily.util.adt.IStringDictionaryReader;
import com.wily.util.extension.IExtension;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.KExtensionConstants;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;

class Plugin
implements IPlugin {
    private final String fLabel;
    private final Attributes fAttributeMap;
    private final IExtension fOwningExtension;
    private final String fName;
    private final String fType;
    private final int fVersion;
    private final String fEntryPointClassName;
    private final IStringDictionaryReader fAttributesReader;

    public Plugin(IExtension owningExtension, Attributes attributeMap, String label) throws InvalidExtensionException {
        this.fLabel = label;
        this.fAttributeMap = attributeMap;
        this.fOwningExtension = owningExtension;
        this.fAttributesReader = new AttributesStringDictionaryReader(this.buildAttributes());
        this.fName = this.getPluginAttributeValueOrThrow("Name");
        this.fType = this.getPluginAttributeValueOrThrow("Type");
        this.fVersion = this.loadVersion();
        this.fEntryPointClassName = this.getPluginAttributeValueOrThrow("Entry-Point-Class");
    }

    private int loadVersion() throws InvalidExtensionException {
        int result;
        String value = this.getPluginAttributeValueOrThrow("Version");
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidExtensionException("invalid plug-in version: " + value, (ILocalizableMessage)new FormattedLocalizableMessage("Extension_Invalid_Plugin_Version_Message", this.IPlugin_getOwningExtension().IExtension_getSource(), this.IPlugin_getOwningExtension().IExtension_getName(), this.IPlugin_getName(), value));
        }
        return result;
    }

    private String getLabel() {
        return this.fLabel;
    }

    private String getName() {
        return this.fName;
    }

    private String getType() {
        return this.fType;
    }

    private int getVersion() {
        return this.fVersion;
    }

    private String getEntryPointClassName() {
        return this.fEntryPointClassName;
    }

    private IStringDictionaryReader getAttributesReader() {
        Assertion.wilyAssert(this.fAttributesReader != null);
        return this.fAttributesReader;
    }

    private Attributes buildAttributes() {
        String lowerCasePrefix = KExtensionConstants.buildPluginAttributeKeyPrefix(this).toLowerCase();
        Attributes result = new Attributes();
        Set<Map.Entry<Object, Object>> entrySet = this.fAttributeMap.entrySet();
        Iterator<Map.Entry<Object, Object>> entries = entrySet.iterator();
        while (entries.hasNext()) {
            Map.Entry<Object, Object> current = entries.next();
            String currentKey = ((Attributes.Name)current.getKey()).toString();
            String lowerCaseKey = currentKey.toLowerCase();
            if (!lowerCaseKey.startsWith(lowerCasePrefix)) continue;
            Attributes.Name internalKey = new Attributes.Name(currentKey.substring(lowerCasePrefix.length()));
            result.put(internalKey, current.getValue());
        }
        return result;
    }

    private String getPluginAttributeValue(String key) {
        return StringUtils.trim(this.getAttributesReader().getValue(key));
    }

    private String getPluginAttributeValueOrThrow(String key) throws InvalidExtensionException {
        String result = this.getPluginAttributeValue(key);
        if (result == null) {
            throw new InvalidExtensionException("missing manifest attribute: " + key, (ILocalizableMessage)new FormattedLocalizableMessage("Extension_Missing_Plugin_Manifest_Attribute_Message", this.IPlugin_getOwningExtension().IExtension_getSource(), this.IPlugin_getOwningExtension().IExtension_getName(), key, String.valueOf(KExtensionConstants.buildPluginAttributeKeyPrefix(this)) + key));
        }
        return result;
    }

    public String IPlugin_getName() {
        return this.getName();
    }

    public IExtension IPlugin_getOwningExtension() {
        return this.fOwningExtension;
    }

    public String IPlugin_getType() {
        return this.getType();
    }

    public String IPlugin_getEntryPointClassName() {
        return this.getEntryPointClassName();
    }

    public IStringDictionaryReader IPlugin_getAttributes() {
        return this.getAttributesReader();
    }

    public String IPlugin_getLabel() {
        return this.getLabel();
    }

    public int IPlugin_getVersion() {
        return this.getVersion();
    }

    public String toString() {
        return MessageFormat.format("Plugin[Name=\"{0}\", Type=\"{1}\", Version={2}, EntryPointClassName=\"{3}\"]", this.getName(), this.getType(), Integer.toString(this.getVersion()), this.getEntryPointClassName());
    }
}

