/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.soaextension.webmethods.webservices.tracer.hc2.WebServicesFaultReportingTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class WebServices80FaultReportingTracer
extends WebServicesFaultReportingTracer {
    public WebServices80FaultReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            Object wsdObj = null;
            String soapactionObj = null;
            Object wsImplObject = data.getInvocationObject();
            Field wsdObjectField = WMUtils.getWsdField(wsImplObject);
            wsdObj = wsdObjectField.get(wsImplObject);
            Field soapActionField = WMUtils.getSoapActionField(wsImplObject);
            soapactionObj = (String)soapActionField.get(wsImplObject);
            if (wsdObj != null && soapactionObj != null) {
                Class[] clArr = new Class[]{String.class};
                Object[] obArr = new Object[]{soapactionObj};
                Method binderMth = WMUtils.getFindBinderonWSD(wsdObj, clArr);
                Object binderObj = binderMth.invoke(wsdObj, obArr);
                if (binderObj != null) {
                    super.doStartBlamePointTrace(index, data);
                }
            }
        }
        catch (Throwable t) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", t);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + t.getMessage());
        }
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            Object wsdObj = null;
            String soapactionObj = null;
            Object soapMsg = null;
            Object wsImplObject = data.getInvocationObject();
            Field wsdObjectField = WMUtils.getWsdField(wsImplObject);
            wsdObj = wsdObjectField.get(wsImplObject);
            Field soapActionField = WMUtils.getSoapActionField(wsImplObject);
            soapactionObj = (String)soapActionField.get(wsImplObject);
            if (wsdObj != null && soapactionObj != null) {
                Class[] clArr = new Class[]{String.class};
                Object[] obArr = new Object[]{soapactionObj};
                Method binderMth = WMUtils.getFindBinderonWSD(wsdObj, clArr);
                Object binderObj = binderMth.invoke(wsdObj, obArr);
                if (binderObj != null) {
                    Field soapMessagetField = WMUtils.getSoapMessageField(wsImplObject);
                    soapMsg = soapMessagetField.get(wsImplObject);
                    data.put("isBinderNotNull", (Object)true);
                } else {
                    data.put("isBinderNotNull", (Object)false);
                }
                this.processComponent(index, data, wsdObj, soapactionObj, soapMsg);
                super.ITracer_finishTrace(index, data);
            }
        }
        catch (Throwable t) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", t);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + t.getMessage());
        }
    }
}

