/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.org.apache.commons.collections.DefaultMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakElementArrayHashMap
extends AbstractMap {
    private static final long serialVersionUID = -3370601314380922368L;
    public static final int kHard = 0;
    public static final int kSoft = 1;
    public static final int kWeak = 2;
    public static final int kWeakElement = 3;
    private int keyType;
    private int valueType;
    private int valueElementType;
    private float loadFactor;
    private transient ReferenceQueue queue = new ReferenceQueue();
    private transient Entry[] table;
    private transient int size;
    private transient int threshold;
    private volatile transient int modCount;
    private transient Set keySet;
    private transient Set entrySet;
    private transient Collection values;

    public WeakElementArrayHashMap() {
        this(0, 2);
    }

    public WeakElementArrayHashMap(int capacity) {
        this(0, 2, capacity, 0.75f);
    }

    public WeakElementArrayHashMap(int keyType, int valueType) {
        this(keyType, valueType, 16, 0.75f);
    }

    public WeakElementArrayHashMap(int capacity, float loadFactor) {
        this(0, 2, capacity, loadFactor);
    }

    public WeakElementArrayHashMap(int keyType, int valueType, int capacity, float loadFactor) {
        int v;
        WeakElementArrayHashMap.verify("keyType", keyType);
        WeakElementArrayHashMap.verify("valueType", valueType);
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + capacity);
        }
        if (capacity == 0) {
            capacity = 1;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + loadFactor);
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than 1.");
        }
        if (keyType == 3) {
            throw new IllegalArgumentException("keyType cannot be kWeakElement");
        }
        this.keyType = keyType;
        if (valueType == 3) {
            this.valueType = 0;
            this.valueElementType = 3;
        } else {
            this.valueType = valueType;
            this.valueElementType = 0;
        }
        for (v = 1; v < capacity; v *= 2) {
        }
        this.table = new Entry[v];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)v * loadFactor);
    }

    private static void verify(String name, int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException(name + " must be kHard, kSoft, kWeak or kWeakElement.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.table.length);
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeObject(null);
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        this.table = new Entry[inp.readInt()];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
        this.queue = new ReferenceQueue();
        Object key = inp.readObject();
        while (key != null) {
            Object value = inp.readObject();
            this.put(key, value);
            key = inp.readObject();
        }
    }

    private Object toReference(int type, Object referent, int hash) {
        switch (type) {
            case 0: {
                return referent;
            }
            case 1: {
                return new SoftRef(hash, referent, this.queue);
            }
            case 2: {
                return new WeakRef(hash, referent, this.queue);
            }
        }
        throw new Error();
    }

    private Entry getEntry(Object key) {
        if (key == null) {
            return null;
        }
        int hash = key.hashCode();
        int index = this.indexFor(hash);
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && key.equals(entry.getKey())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private int indexFor(int hash) {
        hash += ~(hash << 15);
        hash ^= hash >>> 10;
        hash += hash << 3;
        hash ^= hash >>> 6;
        hash += ~(hash << 11);
        hash ^= hash >>> 16;
        return hash & this.table.length - 1;
    }

    private void resize() {
        Entry[] old = this.table;
        this.table = new Entry[old.length * 2];
        for (int i = 0; i < old.length; ++i) {
            Entry next = old[i];
            while (next != null) {
                Entry entry = next;
                next = next.next;
                int index = this.indexFor(entry.hash);
                entry.next = this.table[index];
                this.table[index] = entry;
            }
            old[i] = null;
        }
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    private void purge() {
        Reference ref = this.queue.poll();
        while (ref != null) {
            this.purge(ref);
            ref = this.queue.poll();
        }
    }

    private void purge(Reference ref) {
        int hash = ref.hashCode();
        int index = this.indexFor(hash);
        Entry previous = null;
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.purge(ref)) {
                if (previous == null) {
                    this.table[index] = entry.next;
                } else {
                    previous.next = entry.next;
                }
                --this.size;
                return;
            }
            previous = entry;
            entry = entry.next;
        }
    }

    public int size() {
        this.purge();
        return this.size;
    }

    public boolean isEmpty() {
        this.purge();
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        this.purge();
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        return entry.getValue() != null;
    }

    public Object get(Object key) {
        if (this.valueElementType == 3) {
            throw new IllegalArgumentException("Caller cannot call get() directly if valueElementType == kWeakElement: ");
        }
        return this.getIt(key);
    }

    private Object getIt(Object key) {
        this.purge();
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object put(Object key, Object value) {
        if (this.valueElementType == 3) {
            throw new IllegalArgumentException("Caller cannot call put() directly if valueElementType == kWeakElement: ");
        }
        return this.putIt(key, value);
    }

    private Object putIt(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (value == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purge();
        if (this.size + 1 > this.threshold) {
            this.resize();
        }
        int hash = key.hashCode();
        int index = this.indexFor(hash);
        Entry entry = this.table[index];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.getKey())) {
                Object result = entry.getValue();
                entry.setValue(value);
                return result;
            }
            entry = entry.next;
        }
        ++this.size;
        ++this.modCount;
        key = this.toReference(this.keyType, key, hash);
        value = this.toReference(this.valueType, value, hash);
        this.table[index] = new Entry(key, hash, value, this.table[index]);
        return null;
    }

    public Object[] putArray(Object key, Object[] array) {
        this.purge();
        if (this.valueElementType != 3) {
            throw new IllegalArgumentException("valueElementType != kWeakElement: " + this.valueType);
        }
        Object[] lastValueArray = this.getArray(key);
        int hash = key.hashCode();
        int aLen = array.length;
        WeakRef[] refArray = new WeakRef[aLen];
        int n = 0;
        for (int i = 0; i < aLen; ++i) {
            if (array[i] == null) continue;
            refArray[n++] = new WeakRef(hash, array[i], this.queue);
        }
        this.putIt(key, refArray);
        return lastValueArray;
    }

    public Object[] getArray(Object key) {
        this.purge();
        if (this.valueElementType != 3) {
            throw new IllegalArgumentException("valueElementType != kWeakElement: " + this.valueType);
        }
        WeakRef[] refArray = (WeakRef[])this.getIt(key);
        if (refArray == null) {
            return null;
        }
        int rLen = refArray.length;
        ArrayList aList = new ArrayList(rLen);
        for (int i = 0; i < rLen; ++i) {
            Object obj;
            if (refArray[i] == null || (obj = refArray[i].get()) == null) continue;
            aList.add(obj);
        }
        Object[] objArray = aList.toArray();
        return objArray;
    }

    public Object remove(Object key) {
        this.purge();
        if (key == null) {
            return null;
        }
        int hash = key.hashCode();
        int index = this.indexFor(hash);
        Entry previous = null;
        Entry entry = this.table[index];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.getKey())) {
                if (previous == null) {
                    this.table[index] = entry.next;
                } else {
                    previous.next = entry.next;
                }
                --this.size;
                ++this.modCount;
                return entry.getValue();
            }
            previous = entry;
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    public Set entrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new AbstractSet(){

            public int size() {
                return WeakElementArrayHashMap.this.size();
            }

            public void clear() {
                WeakElementArrayHashMap.this.clear();
            }

            public boolean contains(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Entry e2 = WeakElementArrayHashMap.this.getEntry(e.getKey());
                return e2 != null && ((Object)e).equals(e2);
            }

            public boolean remove(Object o) {
                boolean r = this.contains(o);
                if (r) {
                    Map.Entry e = (Map.Entry)o;
                    WeakElementArrayHashMap.this.remove(e.getKey());
                }
                return r;
            }

            public Iterator iterator() {
                return new EntryIterator();
            }

            public Object[] toArray() {
                return this.toArray(new Object[0]);
            }

            public Object[] toArray(Object[] arr) {
                ArrayList<DefaultMapEntry> list = new ArrayList<DefaultMapEntry>();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    Entry e = (Entry)iterator.next();
                    list.add(new DefaultMapEntry(e.getKey(), e.getValue()));
                }
                return list.toArray(arr);
            }
        };
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        this.keySet = new AbstractSet(){

            public int size() {
                return WeakElementArrayHashMap.this.size;
            }

            public Iterator iterator() {
                return new KeyIterator();
            }

            public boolean contains(Object o) {
                return WeakElementArrayHashMap.this.containsKey(o);
            }

            public boolean remove(Object o) {
                Object r = WeakElementArrayHashMap.this.remove(o);
                return r != null;
            }

            public void clear() {
                WeakElementArrayHashMap.this.clear();
            }
        };
        return this.keySet;
    }

    public Collection values() {
        if (this.values != null) {
            return this.values;
        }
        this.values = new AbstractCollection(){

            public int size() {
                return WeakElementArrayHashMap.this.size;
            }

            public void clear() {
                WeakElementArrayHashMap.this.clear();
            }

            public Iterator iterator() {
                return new ValueIterator();
            }
        };
        return this.values;
    }

    private static class WeakRef
    extends WeakReference {
        private int hash;

        public WeakRef(int hash, Object r, ReferenceQueue q) {
            super(r, q);
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class SoftRef
    extends SoftReference {
        private int hash;

        public SoftRef(int hash, Object r, ReferenceQueue q) {
            super(r, q);
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class EntryIterator
    implements Iterator {
        int index;
        Entry entry;
        Entry previous;
        Object nextKey;
        Object nextValue;
        Object currentKey;
        Object currentValue;
        int expectedModCount;

        public EntryIterator() {
            this.index = WeakElementArrayHashMap.this.size() != 0 ? WeakElementArrayHashMap.this.table.length : 0;
            this.expectedModCount = WeakElementArrayHashMap.this.modCount;
        }

        public boolean hasNext() {
            this.checkMod();
            while (this.nextNull()) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = WeakElementArrayHashMap.this.table[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    this.currentValue = null;
                    return false;
                }
                this.nextKey = e.getKey();
                this.nextValue = e.getValue();
                if (!this.nextNull()) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        private void checkMod() {
            if (WeakElementArrayHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private boolean nextNull() {
            return this.nextKey == null || this.nextValue == null;
        }

        protected Entry nextEntry() {
            this.checkMod();
            if (this.nextNull() && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.nextKey = null;
            this.nextValue = null;
            return this.previous;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            this.checkMod();
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            WeakElementArrayHashMap.this.remove(this.currentKey);
            this.previous = null;
            this.currentKey = null;
            this.currentValue = null;
            this.expectedModCount = WeakElementArrayHashMap.this.modCount;
        }
    }

    private class Entry
    implements Map.Entry {
        Object key;
        Object value;
        int hash;
        Entry next;

        public Entry(Object key, int hash, Object value, Entry next) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        public Object getKey() {
            return WeakElementArrayHashMap.this.keyType > 0 ? ((Reference)this.key).get() : this.key;
        }

        public Object getValue() {
            return WeakElementArrayHashMap.this.valueType > 0 ? ((Reference)this.value).get() : this.value;
        }

        public Object setValue(Object object) {
            Object old = this.getValue();
            if (WeakElementArrayHashMap.this.valueType > 0) {
                ((Reference)this.value).clear();
            }
            this.value = WeakElementArrayHashMap.this.toReference(WeakElementArrayHashMap.this.valueType, object, this.hash);
            return old;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return key.equals(this.getKey()) && value.equals(this.getValue());
        }

        public int hashCode() {
            Object v = this.getValue();
            return this.hash ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        public boolean purgeWeakValueArray(Reference ref) {
            WeakRef[] refArray = (WeakRef[])this.value;
            if (this.value == null || refArray == null) {
                return true;
            }
            int nLen = 0;
            int rLen = refArray.length;
            for (int i = 0; i < rLen; ++i) {
                if (refArray[i] == null) continue;
                ++nLen;
                if (refArray[i] != ref) continue;
                refArray[i].clear();
                refArray[i] = null;
                --nLen;
            }
            if (nLen <= 0) {
                this.value = null;
                return true;
            }
            return false;
        }

        public boolean purge(Reference ref) {
            if (WeakElementArrayHashMap.this.valueElementType == 3) {
                return this.purgeWeakValueArray(ref);
            }
            boolean r = WeakElementArrayHashMap.this.keyType > 0 && this.key == ref;
            boolean bl = r = r || WeakElementArrayHashMap.this.valueType > 0 && this.value == ref;
            if (r) {
                if (WeakElementArrayHashMap.this.keyType > 0) {
                    ((Reference)this.key).clear();
                }
                if (WeakElementArrayHashMap.this.valueType > 0) {
                    ((Reference)this.value).clear();
                }
            }
            return r;
        }
    }
}

