/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.adt.LabeledList;
import com.wily.util.event.AListenerEvent;
import com.wily.util.event.IEventDeliverer;
import com.wily.util.event.ITrackableListener;
import com.wily.wilyassert.Assertion;
import java.util.Iterator;

public class PendingEventQueue {
    private final IEventDeliverer fEventDeliverer;
    private final LabeledList fLabeledQueue;

    public PendingEventQueue(IEventDeliverer eventDeliverer) {
        Assertion.wilyAssert(eventDeliverer != null);
        this.fEventDeliverer = eventDeliverer;
        this.fLabeledQueue = new LabeledList();
    }

    public void addEvent(ITrackableListener listener, AListenerEvent event) {
        QueueEntry eventEntry = new QueueEntry(listener, event);
        this.fLabeledQueue.addLabeledElement(listener, eventEntry);
    }

    public void removeAllEventsForListener(ITrackableListener listener) {
        this.fLabeledQueue.removeAllElementsWithLabel(listener);
    }

    public void deliverEventsAndEmpty() {
        Iterator eventIterator = this.fLabeledQueue.getIterator();
        while (eventIterator.hasNext()) {
            QueueEntry nextEntry = (QueueEntry)eventIterator.next();
            nextEntry.deliver();
        }
        this.fLabeledQueue.clear();
    }

    private IEventDeliverer getEventDeliverer() {
        return this.fEventDeliverer;
    }

    private class QueueEntry {
        private ITrackableListener fListener;
        private AListenerEvent fEvent;

        private QueueEntry(ITrackableListener listener, AListenerEvent event) {
            this.fListener = listener;
            this.fEvent = event;
        }

        public void deliver() {
            PendingEventQueue.this.getEventDeliverer().deliverEvent(this.fListener, this.fEvent);
        }
    }
}

