/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertyKeyAdapter {
    private final Properties fProperties;
    private final Map fUpdatedPropertyKeys = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyKeyAdapter(Properties propertiesToAdapt) {
        Properties properties = new Properties();
        Properties properties2 = propertiesToAdapt;
        synchronized (properties2) {
            properties.putAll((Map<?, ?>)propertiesToAdapt);
        }
        this.fProperties = properties;
    }

    public boolean propertyExists(String key) {
        if (key == null) {
            return false;
        }
        return this.fProperties.containsKey(key);
    }

    public void setKeyMapping(String existingKey, String newKey) {
        this.fUpdatedPropertyKeys.put(existingKey, newKey);
    }

    public Properties getAdaptedProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.fProperties);
        this.updatePropertyKeys(copy);
        return copy;
    }

    private void updatePropertyKeys(Properties properties) {
        Iterator iter = this.fUpdatedPropertyKeys.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String existingKey = (String)entry.getKey();
            String newKey = (String)entry.getValue();
            if (!properties.containsKey(existingKey)) continue;
            String propertyValue = System.getProperty(existingKey, (String)properties.remove(existingKey));
            properties.put(newKey, propertyValue);
        }
    }
}

