/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.clock.MasterClock;
import com.wily.util.event.EventMarker;

public class EventMarkerGenerator {
    private long fNextMasterEventIndex;
    private final EventMarker fFirstEventMarker;
    private static final Clock kSystemClock = new SystemClock();
    private Clock fClock;

    public EventMarkerGenerator() {
        this(kSystemClock);
    }

    public EventMarkerGenerator(Clock clock) {
        this.fClock = clock;
        this.fNextMasterEventIndex = 0L;
        this.fFirstEventMarker = this.generateMasterEventMarker();
    }

    private long getNextMasterEventIndex() {
        return this.fNextMasterEventIndex++;
    }

    public synchronized EventMarker generateMasterEventMarker() {
        return EventMarker.createMasterEventMarker(this, this.fClock.currentTimeMillis(), this.getNextMasterEventIndex());
    }

    public EventMarker generateSlaveEventMarker(EventMarker parent) {
        return EventMarker.createSlaveEventMarker(parent);
    }

    public EventMarker getFirstEventMarker() {
        return this.fFirstEventMarker;
    }

    public static interface Clock {
        public long currentTimeMillis();
    }

    private static final class SystemClock
    implements Clock {
        private SystemClock() {
        }

        public long currentTimeMillis() {
            return MasterClock.currentTimeMillis();
        }
    }
}

