/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils;

import com.wily.powerpack.websphereMQ.agent.extensions.MQProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.Kconstants;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueManagerRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class CAQueueUtils
implements Kconstants {
    private static final String CLASS_NAME = "CAQueueManagerUtils.";
    public static final int QUEUE_INQUIRE = 32;
    public static final int QUEUE_INQUIRE_SET = 96;
    public static final int QUEUE_PERMANENT_DYNAMIC = 2;
    public static final int QUEUE_TEMPORARY_DYNAMIC = 3;
    public static final int QUEUE_TYPE_LOCAL = 1;
    public static final int QUEUE_TYPE_CLUSTER = 7;
    private static Method mMQQueue_getQueueType = null;
    private static Method mMQQueue_getDefinitionType = null;
    private static Method mMQManagedObject_getInt = null;
    private static Method mMQManagedObject_getAttributeString = null;
    private static Method mMQQueue6_getQueueType = null;
    private static Method mMQQueue6_getDefinitionType = null;
    private static Method mMQManagedObject6_getInt = null;
    private static Method mMQManagedObject6_getAttributeString = null;
    private static Field fMQManagedObject_openOptions = null;
    private static Field fMQManagedObject6_openOptions = null;
    private static Method mJmsDestinationImpl_getQueueName = null;
    private static Method mwmqDestination_getName = null;
    private static Method mJMSMQQueue_getBaseQueueName = null;
    private static Method mJMSTopic_getBaseTopicName = null;
    private static Method mJmsDestinationImpl_getTopicName = null;
    public static Map remoteDynamicQueuesRegexMap = new HashMap();
    private static Field sDelegate = null;
    private static Field sProviderSession = null;
    private static Field sAsfDestination = null;
    private static Field sProperties = null;
    private static Method mGetDestination = null;
    private static Field sCommonSess = null;
    private static Field sConnection = null;
    private static Field sExceptionListenerProxy = null;
    private static Field sListener = null;
    private static Field sDestination = null;
    private static Method mgetDestinationQueue = null;
    private static MQProperties mqProps = null;

    static {
        CAQueueUtils.loadRemoteDynamicQueuesList();
    }

    private static void loadRemoteDynamicQueuesList() {
        mqProps = MQProperties.instance(MQPPLog.getLogger());
        Enumeration<?> propNames = mqProps.propertyNames();
        String propertyName = null;
        String qmName = null;
        String queueRegex = null;
        Pattern queuePattern = null;
        while (propNames.hasMoreElements()) {
            try {
                propertyName = propNames.nextElement().toString();
                if (!propertyName.endsWith("mq.dynamicqueues.regex")) continue;
                qmName = propertyName.substring(0, propertyName.indexOf("mq.dynamicqueues.regex") - 1);
                queueRegex = mqProps.getProperty(propertyName);
                if (qmName == null || qmName.trim().length() == 0 || queueRegex == null || queueRegex.trim().length() == 0) continue;
                queuePattern = Pattern.compile(queueRegex);
                remoteDynamicQueuesRegexMap.put(qmName, queuePattern);
            }
            catch (IndexOutOfBoundsException e1) {
                MQPPLog.getLogger().debug("CAQueueUtils:loadRemoteDynamicQueuesList:Exception " + e1.getMessage());
            }
            catch (PatternSyntaxException e2) {
                MQPPLog.getLogger().debug("CAQueueUtils:loadRemoteDynamicQueuesList:Exception " + e2.getMessage());
            }
        }
    }

    public static boolean isDynamicQueue(String qmName, String queueName) {
        boolean isDynamic = false;
        try {
            Pattern queueRegexPattern;
            if (qmName != null && qmName.trim().length() != 0 && queueName != null && queueName.trim().length() != 0 && (queueRegexPattern = (Pattern)remoteDynamicQueuesRegexMap.get(qmName.trim())) != null) {
                Matcher matcher = queueRegexPattern.matcher(queueName.trim());
                isDynamic = matcher.matches();
            }
        }
        catch (PatternSyntaxException pse) {
            MQPPLog.getLogger().debug("CAQueueUtils:isDynamicQueue:Exception " + pse.getMessage());
        }
        return isDynamic;
    }

    public static boolean isDynamicQueue(Object mqObject, String queuename) {
        boolean isDynamic = false;
        String qmName = "";
        if (mqObject != null) {
            QueueVO qVO = null;
            String mqObjectClassName = mqObject.getClass().getName();
            if (mqObjectClassName.equals("com.ibm.mq.MQQueue") || mqObjectClassName.equals("com.ibm.mq.MQSPIQueue") || mqObjectClassName.equals("com.ibm.mq.MQDestination") || mqObjectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                qVO = QueueRepository.getQueueVO(mqObject, queuename);
                qmName = qVO.getQmName();
            } else if (mqObjectClassName.equals("com.ibm.mq.MQQueueManager") || mqObjectClassName.equals("com.ibm.mq.MQSPIQueueManager") || mqObjectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager")) {
                qVO = QueueManagerRepository.getQueueVO(mqObject, queuename);
                qmName = qVO.getQmName();
            }
            if (qVO != null && qVO.isDynamic()) {
                isDynamic = true;
            }
            if (!isDynamic) {
                isDynamic = CAQueueUtils.isDynamicQueue(qmName, queuename);
            }
        }
        return isDynamic;
    }

    public static boolean isJMSDynamicQueue(Object jmsDestinationObject, String queuename, Hashtable properties) {
        boolean isDynamic = false;
        String qmName = "";
        if (queuename.trim().startsWith("AMQ.")) {
            return true;
        }
        if (jmsDestinationObject != null) {
            String mqObjectClass = jmsDestinationObject.getClass().getName();
            QueueVO qVO = null;
            if (mqObjectClass.equals("com.ibm.mq.jms.MQQueue") || mqObjectClass.equals("com.ibm.mq.jms.MQDestination") || mqObjectClass.equals("com.ibm.msg.client.jms.admin.JmsDestinationImpl")) {
                qVO = QueueRepository.getQueueVO(jmsDestinationObject, queuename, properties);
                qmName = qVO.getQmName();
            }
            if (qVO != null && qVO.isDynamic()) {
                isDynamic = true;
            }
            if (!isDynamic) {
                isDynamic = CAQueueUtils.isDynamicQueue(qmName, queuename);
            }
        }
        return isDynamic;
    }

    private static boolean isDynamicQueue(Object queue) {
        Class<?> queueClass = queue.getClass();
        boolean isDynamic = false;
        try {
            if (queueClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                int mqcQueuetype;
                if (mMQQueue6_getQueueType == null) {
                    mMQQueue6_getQueueType = queueClass.getMethod("getQueueType", new Class[0]);
                }
                if ((mqcQueuetype = ((Integer)mMQQueue6_getQueueType.invoke(queue, new Object[0])).intValue()) == 1 || mqcQueuetype == 7) {
                    int mqcDynamic;
                    if (mMQQueue6_getDefinitionType == null) {
                        mMQQueue6_getDefinitionType = queueClass.getMethod("getDefinitionType", new Class[0]);
                    }
                    if ((mqcDynamic = ((Integer)mMQQueue6_getDefinitionType.invoke(queue, new Object[0])).intValue()) == 2 || mqcDynamic == 3) {
                        isDynamic = true;
                    }
                }
            } else {
                int mqcQueuetype;
                if (mMQQueue_getQueueType == null) {
                    mMQQueue_getQueueType = queueClass.getMethod("getQueueType", new Class[0]);
                }
                if ((mqcQueuetype = ((Integer)mMQQueue_getQueueType.invoke(queue, new Object[0])).intValue()) == 1 || mqcQueuetype == 7) {
                    int mqcDynamic;
                    if (mMQQueue_getDefinitionType == null) {
                        mMQQueue_getDefinitionType = queueClass.getMethod("getDefinitionType", new Class[0]);
                    }
                    if ((mqcDynamic = ((Integer)mMQQueue6_getDefinitionType.invoke(queue, new Object[0])).intValue()) == 2 || mqcDynamic == 3) {
                        isDynamic = true;
                    }
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAQueueUtils:getDynamicQueue:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        return isDynamic;
    }

    public static String getDestinationQueueName(Object jmsDestinationObject) throws Exception {
        String queueName = "";
        if (mJmsDestinationImpl_getQueueName == null) {
            mJmsDestinationImpl_getQueueName = jmsDestinationObject.getClass().getMethod("getQueueName", new Class[0]);
        }
        return (queueName = (String)mJmsDestinationImpl_getQueueName.invoke(jmsDestinationObject, new Object[0])) == null ? "" : queueName.trim();
    }

    public static String getWMQDestinationName(Object wmqDestinationObject) throws Exception {
        String queueName = "";
        if (mwmqDestination_getName == null) {
            mwmqDestination_getName = wmqDestinationObject.getClass().getMethod("getName", new Class[0]);
        }
        return (queueName = (String)mwmqDestination_getName.invoke(wmqDestinationObject, new Object[0])) == null ? "" : queueName.trim();
    }

    public static String getDestinationTopicName(Object jmsDestinationObject) throws Exception {
        String topicName = "";
        if (mJmsDestinationImpl_getTopicName == null) {
            mJmsDestinationImpl_getTopicName = jmsDestinationObject.getClass().getMethod("getTopicName", new Class[0]);
        }
        return (topicName = (String)mJmsDestinationImpl_getTopicName.invoke(jmsDestinationObject, new Object[0])) == null ? "" : topicName.trim();
    }

    public static String getJMSBaseQueueName(Object jmsMQQueueObject) throws Exception {
        String queueName = "";
        if (mJMSMQQueue_getBaseQueueName == null) {
            mJMSMQQueue_getBaseQueueName = jmsMQQueueObject.getClass().getMethod("getBaseQueueName", new Class[0]);
        }
        return (queueName = (String)mJMSMQQueue_getBaseQueueName.invoke(jmsMQQueueObject, new Object[0])) == null ? "" : queueName.trim();
    }

    public static String getJMSBaseTopicName(Object jmsMQTopicObject) throws Exception {
        String topicName = "";
        if (mJMSTopic_getBaseTopicName == null) {
            mJMSTopic_getBaseTopicName = jmsMQTopicObject.getClass().getMethod("getBaseTopicName", new Class[0]);
        }
        return (topicName = (String)mJMSTopic_getBaseTopicName.invoke(jmsMQTopicObject, new Object[0])) == null ? "" : topicName.trim();
    }

    public static int getQueueDefinitionType(Object mqQueue) {
        int definitionType = -1;
        if (mqQueue == null) {
            return definitionType;
        }
        try {
            Class<?> mqQueueSuperClass = mqQueue.getClass().getSuperclass();
            if (mqQueueSuperClass.getName().equals("com.ibm.mq.MQQueue")) {
                mqQueueSuperClass = mqQueueSuperClass.getSuperclass();
            }
            if (mqQueueSuperClass.getName().equals("com.ibm.mq.MQDestination")) {
                mqQueueSuperClass = mqQueueSuperClass.getSuperclass();
            }
            if (mqQueueSuperClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject")) {
                if (mMQManagedObject6_getInt == null) {
                    mMQManagedObject6_getInt = mqQueueSuperClass.getDeclaredMethod("getInt", Integer.TYPE);
                    mMQManagedObject6_getInt.setAccessible(true);
                }
                definitionType = (Integer)mMQManagedObject6_getInt.invoke(mqQueue, new Integer(7));
            } else {
                if (mMQManagedObject_getInt == null) {
                    mMQManagedObject_getInt = mqQueueSuperClass.getDeclaredMethod("getInt", Integer.TYPE);
                    mMQManagedObject_getInt.setAccessible(true);
                }
                definitionType = (Integer)mMQManagedObject_getInt.invoke(mqQueue, new Integer(7));
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueDefinitionType(mqQueue) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueDefinitionType(mqQueue) definitionType " + definitionType);
        return definitionType;
    }

    public static int getQueueType(Object mqQueue) {
        int queueType = -1;
        if (mqQueue == null) {
            return queueType;
        }
        try {
            Class<?> mqQueueSuperClass = mqQueue.getClass().getSuperclass();
            if (mqQueueSuperClass.getName().equals("com.ibm.mq.MQQueue")) {
                mqQueueSuperClass = mqQueueSuperClass.getSuperclass();
            }
            if (mqQueueSuperClass.getName().equals("com.ibm.mq.MQDestination")) {
                mqQueueSuperClass = mqQueueSuperClass.getSuperclass();
            }
            if (mqQueueSuperClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject")) {
                if (mMQManagedObject6_getInt == null) {
                    mMQManagedObject6_getInt = mqQueueSuperClass.getDeclaredMethod("getInt", Integer.TYPE);
                    mMQManagedObject6_getInt.setAccessible(true);
                }
                queueType = (Integer)mMQManagedObject6_getInt.invoke(mqQueue, new Integer(20));
            } else {
                if (mMQManagedObject_getInt == null) {
                    mMQManagedObject_getInt = mqQueueSuperClass.getDeclaredMethod("getInt", Integer.TYPE);
                    mMQManagedObject_getInt.setAccessible(true);
                }
                queueType = (Integer)mMQManagedObject_getInt.invoke(mqQueue, new Integer(20));
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueType(mqQueue) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueType(mqQueue) queueType " + queueType);
        return queueType;
    }

    public static int getQueueOpenOptions(Object mqQueue) {
        int qOpenOptions = -1;
        if (mqQueue == null) {
            return qOpenOptions;
        }
        try {
            Class<?> mqQueueClass = mqQueue.getClass();
            if (mqQueueClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                if (fMQManagedObject6_openOptions == null) {
                    fMQManagedObject6_openOptions = mqQueueClass.getField("openOptions");
                }
                qOpenOptions = (Integer)fMQManagedObject6_openOptions.get(mqQueue);
            } else {
                if (fMQManagedObject_openOptions == null) {
                    fMQManagedObject_openOptions = mqQueueClass.getField("openOptions");
                }
                qOpenOptions = (Integer)fMQManagedObject_openOptions.get(mqQueue);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueOpenOptions(mqQueue) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueOpenOptions(mqQueue) qOpenOptions " + qOpenOptions);
        return qOpenOptions;
    }

    public static String getBaseQueueName(Object mqQueue) {
        String baseQName = null;
        if (mqQueue == null) {
            return baseQName;
        }
        try {
            Class<?> mqQueueClass = mqQueue.getClass();
            if (mqQueueClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                if (mMQManagedObject_getAttributeString == null) {
                    mMQManagedObject_getAttributeString = mqQueueClass.getMethod("getAttributeString", Integer.TYPE, Integer.TYPE);
                }
                baseQName = ((String)mMQManagedObject_getAttributeString.invoke(mqQueue, new Integer(2002), new Integer(48))).trim();
            } else {
                if (mMQManagedObject6_getAttributeString == null) {
                    mMQManagedObject6_getAttributeString = mqQueueClass.getMethod("getAttributeString", Integer.TYPE, Integer.TYPE);
                }
                baseQName = ((String)mMQManagedObject6_getAttributeString.invoke(mqQueue, new Integer(2002), new Integer(48))).trim();
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getBaseQueueName(mqQueue) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getBaseQueueName(mqQueue) baseQName " + baseQName);
        return baseQName;
    }

    public static String getActivationSpecDestinationName(Object jmsObject) {
        String fQueueName = null;
        try {
            Class<?> jmsObjectclass = jmsObject.getClass().getSuperclass();
            if (sDelegate == null) {
                sDelegate = jmsObjectclass.getDeclaredField("delegate");
                sDelegate.setAccessible(true);
            }
            Object delegateObject = sDelegate.get(jmsObject);
            if (sProviderSession == null) {
                sProviderSession = delegateObject.getClass().getDeclaredField("providerSession");
                sProviderSession.setAccessible(true);
            }
            Object providerSessionObject = sProviderSession.get(delegateObject);
            if (sAsfDestination == null) {
                sAsfDestination = providerSessionObject.getClass().getDeclaredField("asfDestination");
                sAsfDestination.setAccessible(true);
            }
            Object asfDestinationObject = sAsfDestination.get(providerSessionObject);
            if (sProperties == null) {
                sProperties = asfDestinationObject.getClass().getDeclaredField("properties");
                sProperties.setAccessible(true);
            }
            Object propertiesObject = sProperties.get(asfDestinationObject);
            if (mGetDestination == null) {
                mGetDestination = propertiesObject.getClass().getMethod("getBaseQueueName", new Class[0]);
            }
            fQueueName = (String)mGetDestination.invoke(propertiesObject, new Object[0]);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getActivationSpecDestinationName", (Throwable)e);
        }
        return fQueueName;
    }

    public static String getListenerDestinationName(Object jmsSessionObject) {
        String fQueueName = null;
        try {
            if (sProviderSession == null) {
                Class<?> providerSessionCls = jmsSessionObject.getClass().getSuperclass();
                if (!providerSessionCls.getName().equals("com.ibm.msg.client.jms.internal.JmsSessionImpl")) {
                    providerSessionCls = providerSessionCls.getSuperclass();
                }
                sProviderSession = providerSessionCls.getDeclaredField("providerSession");
                sProviderSession.setAccessible(true);
            }
            Object providerSessionObject = sProviderSession.get(jmsSessionObject);
            if (sAsfDestination == null) {
                sAsfDestination = providerSessionObject.getClass().getSuperclass().getDeclaredField("asfDestination");
                sAsfDestination.setAccessible(true);
            }
            Object asfDestinationObject = sAsfDestination.get(providerSessionObject);
            if (sProperties == null) {
                sProperties = asfDestinationObject.getClass().getDeclaredField("properties");
                sProperties.setAccessible(true);
            }
            Object propertiesObject = sProperties.get(asfDestinationObject);
            if (mGetDestination == null) {
                mGetDestination = propertiesObject.getClass().getMethod("getBaseQueueName", new Class[0]);
            }
            fQueueName = (String)mGetDestination.invoke(propertiesObject, new Object[0]);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getListenerDestinationName", (Throwable)e);
        }
        return fQueueName;
    }

    public static String getActivationSpecDestinationQueueName(Object jmsObject) {
        String fQueueName = null;
        try {
            Class<?> jmsObjectclass = jmsObject.getClass();
            if (!jmsObjectclass.getName().equals("com.ibm.mq.jms.MQSession")) {
                jmsObjectclass = jmsObjectclass.getSuperclass();
            }
            if (sCommonSess == null) {
                sCommonSess = jmsObjectclass.getDeclaredField("commonSess");
                sCommonSess.setAccessible(true);
            }
            Object commonSessObject = sCommonSess.get(jmsObject);
            if (sConnection == null) {
                sConnection = commonSessObject.getClass().getDeclaredField("connection");
                sConnection.setAccessible(true);
            }
            Object connectionObject = sConnection.get(commonSessObject);
            if (sExceptionListenerProxy == null) {
                sExceptionListenerProxy = connectionObject.getClass().getDeclaredField("exceptionListenerProxy");
                sExceptionListenerProxy.setAccessible(true);
            }
            Object exceptionListenerProxyObject = sExceptionListenerProxy.get(connectionObject);
            if (sListener == null) {
                sListener = exceptionListenerProxyObject.getClass().getDeclaredField("eListener");
                sListener.setAccessible(true);
            }
            Object eListenerObject = sListener.get(exceptionListenerProxyObject);
            if (sDestination == null) {
                sDestination = eListenerObject.getClass().getDeclaredField("theDestination");
                sDestination.setAccessible(true);
            }
            Object theDestinationObject = sDestination.get(eListenerObject);
            if (mgetDestinationQueue == null) {
                mgetDestinationQueue = theDestinationObject.getClass().getMethod("getBaseQueueName", new Class[0]);
            }
            fQueueName = (String)mgetDestinationQueue.invoke(theDestinationObject, new Object[0]);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getActivationSpecDestinationqueueName", (Throwable)e);
        }
        return fQueueName;
    }
}

