/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;

public class EMSBackendFormatter
implements INameFormatter,
KConstants {
    private static final String kEMS_SERVER = "EMS-SERVER";
    private static final String kTIBCO_EMS_SERVER = "TIBCO EMS Server";
    private static final String kJMS_SERVER = "JMS Server";
    private static final String kAtString = " at ";
    private static final String kUrlString = "URL=tcp://";
    private static final String kOnPortString = " on port ";
    private static final String kRegex = ".*:\\d*";
    private final IAgent fAgent;

    public EMSBackendFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    public String getEMSString(InvocationData data) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        String servername = null;
        String objString = null;
        String hostPort = null;
        boolean isHostPort = false;
        if (isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("EMSBackendFormatter: getEMSString()");
        }
        try {
            String connString;
            Object connObj;
            Object emsObj = data.getInvocationParameterAsObject(1);
            objString = this.getMessageID(emsObj);
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("Message ID: " + objString);
            }
            if ((emsObj = data.getInvocationObject()) != null && (connObj = this.getConnection(emsObj)) != null && (connString = connObj.toString()).contains(kUrlString)) {
                int urlIndex = connString.indexOf(kUrlString);
                int lastIndex = connString.lastIndexOf("]");
                hostPort = connString.substring(urlIndex + 10, lastIndex);
                if (isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug("Host Port String_1: " + hostPort);
                }
                isHostPort = Pattern.matches(kRegex, hostPort);
                if (hostPort != null && isHostPort) {
                    hostPort = hostPort.replace(":", kOnPortString);
                    if (isDebugEnabled) {
                        TibcoBWUtils.getLogger().debug("Host Port String_2: " + hostPort);
                    }
                }
            }
            if (objString != null) {
                servername = objString.contains(kEMS_SERVER) ? (hostPort != null && isHostPort ? "TIBCO EMS Server at " + hostPort : kTIBCO_EMS_SERVER) : (hostPort != null && isHostPort ? "JMS Server at " + hostPort : kJMS_SERVER);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("EMS Server String: " + servername);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.fAgent, "ERROR_IN_EMSBACKEND_FORMATTER", bomb);
        }
        return servername == null || servername.trim().length() == 0 || servername.equals("UnknownTibcoEMSServer") ? "UnknownTibcoEMSServer" : servername;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String _serverName = null;
        if (name.indexOf("{emsserver}", 0) >= 0) {
            _serverName = (String)data.get("com.wily.soaextension.tibcobw.EMSServerKey");
            if ((_serverName == null || _serverName.equals("UnknownTibcoEMSServer")) && (_serverName = this.getEMSString(data)) == null) {
                return "UnknownTibcoEMSServer";
            }
            _serverName = TibcoBWUtils.formatToBeResourceSafe(_serverName);
            data.put("com.wily.soaextension.tibcobw.EMSServerKey", (Object)_serverName);
            name = StringUtils.replace((String)name, (String)"{emsserver}", (String)_serverName);
        }
        return name;
    }

    private Object getConnection(Object emsobj) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object connection = null;
        Field _connF = TibcoReflectionCache.getF_EMS_Connection(emsobj);
        if (_connF != null) {
            connection = _connF.get(emsobj);
        }
        return connection;
    }

    private String getMessageID(Object msg) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String msgID = null;
        msgID = (String)TibcoReflectionCache.getM_getJMSMessageID(msg).invoke(msg, EMPTY_OBJECT_ARRAY);
        return msgID;
    }
}

