/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.multithread.blame.MultiBoundaryBlameStackFeature;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class JobErrorTracer
extends ASingleMetricTracerFactory
implements KConstants {
    private static final String tracerName = "JobErrorTracer";

    public JobErrorTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        ProbeIdentification probIdentification = data.getProbeInformation().getProbeIdentification();
        boolean threw = false;
        boolean handleerror = false;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        if (data.hasInvocationThrownException()) {
            threw = true;
        }
        if (probIdentification.getProbeMethodName().equalsIgnoreCase("handleError")) {
            handleerror = true;
        }
        if (threw || handleerror) {
            Throwable error = null;
            error = threw ? data.getInvocationThrownException() : (Throwable)data.getInvocationParameterAsObject(2);
            String component = this.formatParameterizedResource(data);
            String errorMessage = String.valueOf(component) + ": " + error.getMessage();
            String Metricname = String.valueOf(component) + ":" + "Errors Per Interval";
            if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
            }
            try {
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(Metricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
                if (TibcoBWUtils.isMBBSEnabled()) {
                    String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                    MultiBoundaryBlameStackFeature blameStackFeature = (MultiBoundaryBlameStackFeature)MultiBoundaryBlameStackFeature.instance.get();
                    String frontend = blameStackFeature.getCollector().getFrontend(correlationId);
                    if (frontend != null) {
                        StringBuilder sbFrontend = new StringBuilder();
                        sbFrontend.append(frontend);
                        sbFrontend.append(":");
                        sbFrontend.append("Errors Per Interval");
                        this.getDataAccumulatorFactory().safeGetFrontendLongIntervalCounterDataAccumulator(sbFrontend.toString()).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    } else {
                        TibcoBWUtils.getLogger().warn("No Frontend available for BP: " + component + " This is either a spawned process or subprocess of a spawned process.");
                    }
                }
                if (isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug(tracerName + errorMessage);
                }
            }
            catch (ESEException e) {
                Assertion.wilyFail((String)("Metric type conflict" + e.getMessage()));
            }
        }
    }
}

