/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.ws;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatter;

public class WebServicesFormatter
extends BWGenericFormatter {
    public static final String C_SoapServiceConfig = "SoapServiceConfig";

    public WebServicesFormatter(IAgent agent) {
        super(agent);
    }

    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object soapServiceConfig;
            Object invocationObj = data.getInvocationObject();
            if (invocationObj != null && (soapServiceConfig = TibcoReflectionCache.getF_DefaultXDataSoapletFinisher_ISoapServiceConfig(invocationObj)) != null) {
                if (soapServiceConfig.getClass().getSimpleName().equalsIgnoreCase(C_SoapServiceConfig)) {
                    namespace = (String)TibcoReflectionCache.getM_SoapServiceConfig_getConcreteWsdlNamespace(soapServiceConfig);
                } else {
                    Object endpointName = TibcoBWUtils.getField(soapServiceConfig, kF_SoapServiceConfigAdapter_endpointName);
                    if (endpointName != null) {
                        namespace = (String)TibcoReflectionCache.getM_ExpandedName_getNamespaceURI(endpointName);
                    }
                }
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesFormatter:getNamespace: " + namespace);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object transportContext;
            Object defaultSoapMessage;
            Object invocationObj = data.getInvocationObject();
            if (invocationObj != null && (defaultSoapMessage = TibcoReflectionCache.getF_DefaultXDataSoapletFinisher_SoapMessage(invocationObj)) != null && (transportContext = TibcoReflectionCache.getM_SoapMessage_getTransportContext(defaultSoapMessage)) != null) {
                Object url = TibcoReflectionCache.getM_TransportContext_getUrl(transportContext);
                webServiceURI = url.toString();
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesFormatter:getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object operationContext;
            Object invocationObj = data.getInvocationObject();
            if (invocationObj != null && (operationContext = TibcoReflectionCache.getF_DefaultXDataSoapletFinisher_OperationContext(invocationObj)) != null) {
                operationName = (String)TibcoReflectionCache.getM_OperationContext_getOperationName(operationContext);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesFormatter:getOperationName: " + operationName);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals("UnknownOperationName") ? "UnknownOperationName" : operationName;
    }
}

