/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.Module;
import java.net.URI;

public class ApacheHttpCommonsClientDataResolver
implements HttpDataResolver {
    private static Module module = new Module("Apache HTTP Commons Client Data Resolver");
    private static final HttpDataResolver instance = new ApacheHttpCommonsClientDataResolver();

    private ApacheHttpCommonsClientDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        block10: {
            Object url = null;
            try {
                url = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(1), (String)"getURI", (Class[])new Class[0], (Object[])new Object[0]);
                url = ReflectionUtils.invokeMethodOnObject((Object)url, (String)"getURI", (Class[])new Class[0], (Object[])new Object[0]);
                if (url == null) break block10;
                URI uri = URI.create(UrlUtilities.formatSpecialChars(url.toString()));
                if (!uri.isAbsolute()) {
                    Object hostConfiguration = data.getInvocationParameterAsObject(0);
                    if (hostConfiguration == null) {
                        hostConfiguration = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationObject(), (String)"getHostConfiguration", (Class[])new Class[0], (Object[])new Object[0]);
                    }
                    if (hostConfiguration != null) {
                        Object hostObjectUri = ReflectionUtils.invokeMethodOnObject((Object)hostConfiguration, (String)"getHostURL", (Class[])new Class[0], (Object[])new Object[0]);
                        if (hostObjectUri != null) {
                            uri = URI.create(String.valueOf((String)hostObjectUri) + uri.toString());
                            return uri;
                        }
                        return BackendProtocolsConstants.UNKNOWN_URI;
                    }
                    break block10;
                }
                return uri;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    agent.IAgent_getModuleFeedback().error(module, "getURI : Unable to get URL for Apache Http commons client -" + url);
                    agent.IAgent_getModuleFeedback().verbose(t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    @Override
    public String getHttpMethod(IAgent agent, InvocationData data) {
        try {
            Object httpMethod = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(1), (String)"getName", (Class[])new Class[0], (Object[])new Object[0]);
            if (httpMethod != null && httpMethod instanceof String) {
                return (String)httpMethod;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpMethod() : Unable to get HTTP method");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        try {
            Object responseCode = data.getInvocationReturnValueAsObject();
            if (responseCode != null) {
                return (Integer)responseCode;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusCode() : Unable to get response code");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return -1;
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        try {
            Object responseMessage = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(1), (String)"getStatusText", (Class[])new Class[0], (Object[])new Object[0]);
            if (responseMessage != null) {
                return (String)responseMessage;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusMessage() : Unable to get response status message");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }
}

