/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.helper;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public class JMSHelper {
    public static final Module module = new Module("JMSExtension");
    private static final char UNDERSCORE_CHAR = '_';
    private static IWeakIdentityMap consumersInfo = null;
    private static Class jmsQueueClass = null;
    private static Class jmsTopicClass = null;
    private static Class jmsTemporaryQueueClass = null;
    private static Class jmsTemporaryTopicClass = null;
    private static Class jmsDestinationClass = null;

    static {
        IAgent agent = null;
        try {
            agent = AgentShim.getAgent();
            consumersInfo = agent.IAgent_getConcurrentMapFactory().getConcurrentCappedWeakIdentityMap("jmsConsumerToDestination");
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static void populateConsumerDetails(Object msgConsumer, Object jmsDestination) {
        consumersInfo.putWeak(msgConsumer, jmsDestination);
    }

    public static Object getDestinationInfoForConsumer(Object msgConsumer) {
        return consumersInfo.getWeak(msgConsumer);
    }

    public static Object getDestination(InvocationData data, IModuleFeedbackChannel logger) {
        Object dest = null;
        try {
            dest = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(0), (String)"getJMSDestination", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.error(module, "Could not get Destination Object  Exception: " + e + " Cause: " + e.getCause());
            return null;
        }
        return dest;
    }

    public static boolean isQueue(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsQueueClass == null) {
                    jmsQueueClass = Class.forName("javax.jms.Queue", true, dest.getClass().getClassLoader());
                }
                result = jmsQueueClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for Queue  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static boolean isTopic(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTopicClass == null) {
                    jmsTopicClass = Class.forName("javax.jms.Topic", true, dest.getClass().getClassLoader());
                }
                result = jmsTopicClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for Queue  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static String getQueueName(Object queue, IModuleFeedbackChannel logger) {
        String queueName = "Unknown Queue";
        if (queue != null) {
            try {
                queueName = (String)ReflectionUtils.invokeMethodOnObject((Object)queue, (String)"getQueueName", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception e) {
                logger.error(module, "Unable to get Queue Name Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return queueName;
    }

    public static String getTopicName(Object topic, IModuleFeedbackChannel logger) {
        String topicName = "Unknown Topic";
        if (topic != null) {
            try {
                topicName = (String)ReflectionUtils.invokeMethodOnObject((Object)topic, (String)"getTopicName", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception e) {
                logger.error(module, "Unable to get Topic Name Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return topicName;
    }

    public static boolean isDestination(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsDestinationClass == null) {
                    jmsDestinationClass = Class.forName("javax.jms.Destination", true, dest.getClass().getClassLoader());
                }
                result = jmsDestinationClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static String substituteMetricSeparatorChars(String metric) {
        String newMetric = null;
        newMetric = metric.replace(':', '_');
        newMetric = newMetric.replace('|', '_');
        return newMetric;
    }

    public static boolean isTempQueue(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTemporaryQueueClass == null) {
                    jmsTemporaryQueueClass = Class.forName("javax.jms.TemporaryQueue", true, dest.getClass().getClassLoader());
                }
                result = jmsTemporaryQueueClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static boolean isTempTopic(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTemporaryTopicClass == null) {
                    jmsTemporaryTopicClass = Class.forName("javax.jms.TemporaryTopic", true, dest.getClass().getClassLoader());
                }
                result = jmsTemporaryTopicClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static boolean isTempDestination(Object dest, IModuleFeedbackChannel logger) {
        return JMSHelper.isTempQueue(dest, logger) || JMSHelper.isTempTopic(dest, logger);
    }

    public static boolean isJMSDestinationPassedAsFirstArg(InvocationData data, IModuleFeedbackChannel logger) {
        Boolean isDestinationFirstArg = (Boolean)data.get("jms.dest.passed.as.first.arg");
        if (isDestinationFirstArg != null && isDestinationFirstArg.booleanValue()) {
            return true;
        }
        Object dest = data.getInvocationParameterAsObject(0);
        boolean isDestination = JMSHelper.isDestination(dest, logger);
        data.put("jms.dest.passed.as.first.arg", (Object)(isDestination ? Boolean.TRUE : Boolean.FALSE));
        return isDestination;
    }

    public static boolean isMessageRedeliverySet(Object jmsMsgObject, IModuleFeedbackChannel logger, InvocationData data) {
        try {
            Boolean msgReDelivered = (Boolean)ReflectionUtils.invokeMethodOnObject((Object)jmsMsgObject, (String)"getJMSRedelivered", (Class[])new Class[0], (Object[])new Object[0]);
            return msgReDelivered;
        }
        catch (Exception e) {
            logger.error(module, "Could not check for msgRedelivery property in the msg  Object  Exception: " + e + " Cause: " + e.getCause());
            return false;
        }
    }

    public static boolean shouldRunProducerTracers(InvocationData data, IModuleFeedbackChannel feedback) {
        Boolean shouldRun = (Boolean)data.get("should run");
        if (shouldRun != null) {
            return shouldRun;
        }
        shouldRun = JMSHelper.getDestinationInfoForConsumer(data.getInvocationObject()) != null || JMSHelper.isJMSDestinationPassedAsFirstArg(data, feedback);
        data.put("should run", (Object)shouldRun);
        return shouldRun;
    }

    public static boolean isStackEmpty(InvocationData data) {
        Boolean result = (Boolean)data.get("jms.perinterval.is.stack.empty.key");
        if (result != null) {
            return result;
        }
        IStackElement root = VirtualStack.getTransactionCache().getRoot();
        if (root == null || root == data) {
            data.put("jms.perinterval.is.stack.empty.key", (Object)Boolean.TRUE);
            return true;
        }
        IStackElement top = VirtualStack.peek();
        IStackElement cur = top == data ? top.getParent() : top;
        boolean isStackNotEmpty = false;
        while (cur != null) {
            if (!(cur instanceof VirtualStack.DummyVirtualElement) && cur != data) {
                isStackNotEmpty = true;
                break;
            }
            cur = cur.getParent();
        }
        result = isStackNotEmpty ? Boolean.FALSE : Boolean.TRUE;
        data.put("jms.perinterval.is.stack.empty.key", (Object)result);
        return result;
    }
}

