/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backend.jms.helper.PatternMatcherHandler;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.concurrent.atomic.AtomicReference;

public class JMSNameFormatter
implements INameFormatter,
BackendProtocolsConstants {
    public static final String[] PLACEHOLDERS = new String[]{"{jmsdestinationtype}", "{destinationname}"};
    public static final int PLACEHOLDER_DESTINATION_TYPE = 0;
    public static final int PLACEHOLDER_DESTINATION_NAME = 1;
    private static final String TEMPORARY_QUEUE_DEST = "Temporary Queues";
    private static final String TEMPORARY_TOPIC_DEST = "Temporary Topics";
    protected IModuleFeedbackChannel feedback;
    private static final AtomicReference<PatternMatcherHandler> patternMatcherHandlerHolder = new AtomicReference();
    private static ThreadLocal NameFormatterBuilder = new ThreadLocal(){

        protected Object initialValue() {
            return new StringBuilder();
        }
    };

    private static void setDestinationNamePatternSettings(IAgent agent) {
        if (patternMatcherHandlerHolder.get() == null) {
            patternMatcherHandlerHolder.compareAndSet(null, new PatternMatcherHandler(agent));
        }
    }

    public JMSNameFormatter(IAgent agent) {
        this.feedback = agent.IAgent_getModuleFeedback();
        JMSNameFormatter.setDestinationNamePatternSettings(agent);
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String result = null;
        if (name != null) {
            try {
                StringBuilder metricBldr = (StringBuilder)NameFormatterBuilder.get();
                metricBldr.replace(0, metricBldr.length(), name);
                int placeholder = 0;
                while (placeholder < PLACEHOLDERS.length) {
                    int index = metricBldr.indexOf(PLACEHOLDERS[placeholder]);
                    if (index >= 0) {
                        switch (placeholder) {
                            case 0: {
                                String destinationType = this.resolveDestinationType(data);
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], destinationType);
                                break;
                            }
                            case 1: {
                                String destinationName = this.resolveDestinationName(data);
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], destinationName);
                                break;
                            }
                            default: {
                                this.feedback.warn(JMSHelper.module, "An unknown name formatter placeholder requested:" + placeholder);
                            }
                        }
                    }
                    ++placeholder;
                }
                result = metricBldr.toString();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    this.feedback.error("An error occurred formatting jms client metric name" + t.getMessage());
                    this.feedback.verbose(t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    protected StringBuilder replaceAll(StringBuilder builder, String source, String dest) {
        if (builder != null && dest != null) {
            int index = builder.indexOf(source);
            while (index != -1) {
                builder.replace(index, index + source.length(), dest);
                index += dest.length();
                index = builder.indexOf(source, index);
            }
        }
        return builder;
    }

    protected String resolveDestinationName(InvocationData data) {
        String destinationName = (String)data.get("Jms.Destination.Key");
        if (destinationName != null) {
            return destinationName;
        }
        Object destination = this.getJMSDestination(data);
        boolean isTemp = false;
        boolean isTopic = false;
        boolean isQueue = false;
        String destinationType = this.resolveDestinationType(data);
        destinationName = "Unknown";
        if ("Queues".equals(destinationType)) {
            isQueue = true;
        } else if ("Topics".equals(destinationType)) {
            isTopic = true;
        }
        if (JMSHelper.isTempDestination(destination, this.feedback)) {
            if (isQueue) {
                destinationName = TEMPORARY_QUEUE_DEST;
            } else if (isTopic) {
                destinationName = TEMPORARY_TOPIC_DEST;
            }
            isTemp = true;
        } else if (isQueue) {
            destinationName = JMSHelper.substituteMetricSeparatorChars(JMSHelper.getQueueName(destination, this.feedback));
        } else if (isTopic) {
            destinationName = JMSHelper.substituteMetricSeparatorChars(JMSHelper.getTopicName(destination, this.feedback));
        }
        if (!isTemp && !destinationName.equals("Unknown") && this.matchesPattern(destinationName)) {
            if (isQueue) {
                destinationName = TEMPORARY_QUEUE_DEST;
            } else if (isTopic) {
                destinationName = TEMPORARY_TOPIC_DEST;
            }
        }
        data.put("Jms.Destination.Key", (Object)destinationName);
        return destinationName;
    }

    private boolean matchesPattern(String destinationName) {
        PatternMatcherHandler handler = patternMatcherHandlerHolder.get();
        if (handler != null) {
            return handler.matches(destinationName);
        }
        return false;
    }

    protected Object getJMSDestination(InvocationData data) {
        Object destination = JMSHelper.getDestination(data, this.feedback);
        return destination;
    }

    protected String resolveDestinationType(InvocationData data) {
        String destinationType = (String)data.get("jms.destination.type");
        if (destinationType != null) {
            return destinationType;
        }
        destinationType = "Unknown";
        Object destination = this.getJMSDestination(data);
        if (JMSHelper.isQueue(destination, this.feedback)) {
            destinationType = "Queues";
        } else if (JMSHelper.isTopic(destination, this.feedback)) {
            destinationType = "Topics";
        }
        data.put("jms.destination.type", (Object)destinationType);
        return destinationType;
    }
}

