/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.hc2.PerIntervalCounter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class JMSPerIntervalReceiverTracer
extends PerIntervalCounter
implements BackendProtocolsConstants,
IInvocationDataParameterCallback {
    private final boolean fAggregated = this.calculateBooleanParameter("setAggregated", false);

    public JMSPerIntervalReceiverTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected String getComponentName(InvocationData data) {
        return this.formatParameterizedResource(data);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (JMSHelper.getDestinationInfoForConsumer(data.getInvocationObject()) != null) {
            if (!JMSHelper.isStackEmpty(data)) {
                data.setParameterCallback((IInvocationDataParameterCallback)this);
            }
            data.put("jms.receiver.tracer.should.run", (Object)Boolean.TRUE);
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    protected boolean useBlame() {
        String parm = this.getParameter("useblame");
        if (parm != null) {
            return Boolean.parseBoolean(parm);
        }
        return true;
    }

    public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        if (!JMSHelper.isStackEmpty((InvocationData)data)) {
            super.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, newElement);
        }
    }

    public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        if (!JMSHelper.isStackEmpty((InvocationData)data)) {
            super.offerNewTransactionInstanceElementOnEndTrace(tracerIndex, data, newElement);
        }
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        InvocationData invocationData = (InvocationData)data;
        if (invocationData.getInvocationReturnValueAsObject() == null) {
            return;
        }
        super.doOnEndTrace(tracerIndex, data, mh);
        if (!this.fAggregated && JMSHelper.isStackEmpty((InvocationData)data)) {
            this.createTTAndSendIfPassesFilterCriteria(tracerIndex, (InvocationData)data);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Boolean startCalled = (Boolean)data.get("jms.receiver.tracer.should.run");
        if (startCalled != null && startCalled.booleanValue()) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    private void createTTAndSendIfPassesFilterCriteria(int tracerIndex, InvocationData data) {
        HashMap params = new HashMap();
        boolean isSampled = FilterController.samplingExecute((long)Long.MAX_VALUE, (IAgent)this.getAgent());
        data.IComponentParameterCallback_addParameters(params);
        this.IInvocationDataParameterCallback_addParameters(data, params);
        String resourceName = this.formatParameterizedResource(data);
        TransactionComponentData rootTcdData = TransactionComponentData.createMilliSecTransactionComponentData((String)resourceName, (long)data.getWallClockFinishTime(), (long)1L, params);
        if (isSampled) {
            rootTcdData.getParameters().put("Trace Type", "Sampled");
        } else {
            rootTcdData.getParameters().put("Trace Type", "Normal");
        }
        rootTcdData.getParameters().put("Resource Name", resourceName);
        String iD = (String)data.get("CorJMSCrossProcessData");
        if (iD != null && iD.length() > 0) {
            rootTcdData.getParameters().put("CorJMSCrossProcessData", iD);
        }
        if (isSampled || FilterController.pessimisticLegacyFiltersExecute((TransactionComponentData)rootTcdData)) {
            this.getAgent().IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(rootTcdData);
        }
    }

    private String getDestinationName(InvocationData data) {
        String destinationName = (String)data.get("Jms.Destination.Key");
        if (destinationName != null) {
            return destinationName;
        }
        return "Unknown";
    }

    private boolean isTopic(InvocationData data) {
        String destType = (String)data.get("jms.destination.type");
        return destType != null && destType.equals("Topics");
    }

    private boolean isQueue(InvocationData data) {
        String destType = (String)data.get("jms.destination.type");
        return destType != null && destType.equals("Queues");
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map params) {
        if (this.isQueue(data)) {
            params.put("Queue Name", this.getDestinationName(data));
        } else if (this.isTopic(data)) {
            params.put("Topic Name", this.getDestinationName(data));
        }
    }
}

