/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public abstract class BackendProtocolsCorrelationTracer
extends ASingleInstanceTracerFactory
implements BackendProtocolsConstants {
    private String tracerIncrementedCorrelationCountKey = null;
    protected Module module = null;
    protected IModuleFeedbackChannel logger = null;
    private ReentrancyLevel reentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private volatile VirtualStack virtualStack;

    public BackendProtocolsCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.module = new Module(this.getClass().getName());
        this.tracerIncrementedCorrelationCountKey = String.valueOf(this.module.getName()) + ".Correlation.Count.Incremented";
        this.logger = agent.IAgent_getModuleFeedback();
        this.virtualStack = new VirtualStack(agent);
    }

    public void ITracer_startTrace(int i, InvocationData invocationData) {
    }

    public void ITracer_finishTrace(int i, InvocationData invocationData) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.reentrancyLevel;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected final String getOutgoingCorrelationID(InvocationData invocationData) {
        String iD = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
        invocationData.put(this.tracerIncrementedCorrelationCountKey, (Object)true);
        return iD;
    }

    protected void unGetOutgoingCorrelationID(InvocationData invocationData) {
        Boolean incremented = (Boolean)invocationData.get(this.tracerIncrementedCorrelationCountKey);
        if (incremented != null && incremented.booleanValue()) {
            invocationData.put(this.tracerIncrementedCorrelationCountKey, null);
            new CorrelationId().decrementCorrelationCount();
        }
    }

    protected void setIncomingCorrelationId(InvocationData invocationData, String correlationID, String additionalCorrelationParameterName) {
        if (correlationID != null && !correlationID.isEmpty()) {
            new CorrelationId(correlationID, false);
            this.setAdditionalCorrelationParameter(invocationData, correlationID, additionalCorrelationParameterName);
        }
    }

    protected void setAdditionalCorrelationParameter(InvocationData invocationData, String correlationID, String additionalCorrelationParameterName) {
        if (correlationID != null && !correlationID.isEmpty() && additionalCorrelationParameterName != null && !additionalCorrelationParameterName.isEmpty()) {
            int firstComma = correlationID.indexOf(",");
            String minimalID = correlationID.substring(0, firstComma > 0 ? firstComma : correlationID.length());
            if (!this.virtualStack.IBlameStack_isEmpty()) {
                this.virtualStack.addRootParameter(additionalCorrelationParameterName, minimalID);
            }
            invocationData.put(additionalCorrelationParameterName, (Object)minimalID);
        }
    }
}

