/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.table;

import com.wily.ui.swing.table.TableMap;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class RowFilteringTableModel
extends TableMap {
    private final IRowFilter sDefaultFilter;
    private IRowFilter fFilter;
    private int[] fRowMap;
    private int fRowCount;

    public RowFilteringTableModel() {
        this.fFilter = this.sDefaultFilter = new AcceptAllFilter();
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.recalculateRowMap();
    }

    public void setFilter(IRowFilter filter) {
        this.fFilter = filter == null ? this.sDefaultFilter : filter;
        this.filterStateChanged();
    }

    public void filterStateChanged() {
        this.recalculateRowMap();
        this.fireTableDataChanged();
    }

    public void recalculateRowMap() {
        int i;
        this.fRowMap = new int[this.model.getRowCount()];
        this.fRowCount = 0;
        for (i = 0; i < this.model.getRowCount(); ++i) {
            if (!this.fFilter.shouldIncludeRow(this.model, i)) continue;
            this.fRowMap[this.fRowCount++] = i;
        }
        for (i = this.fRowCount; i < this.fRowMap.length; ++i) {
            this.fRowMap[i] = -1;
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.recalculateRowMap();
        super.tableChanged(e);
    }

    public int getUnderlyingRow(int row) {
        return this.fRowMap[row];
    }

    public int getRowCount() {
        return this.fRowCount;
    }

    public Object getValueAt(int aRow, int aColumn) {
        return super.getValueAt(this.getUnderlyingRow(aRow), aColumn);
    }

    public boolean isCellEditable(int row, int column) {
        return super.isCellEditable(this.getUnderlyingRow(row), column);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        super.setValueAt(aValue, this.getUnderlyingRow(aRow), aColumn);
    }

    private class AcceptAllFilter
    implements IRowFilter {
        private AcceptAllFilter() {
        }

        public boolean shouldIncludeRow(TableModel underlyingModel, int row) {
            return true;
        }
    }

    public static interface IRowFilter {
        public boolean shouldIncludeRow(TableModel var1, int var2);
    }
}

