/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.table;

import com.wily.ui.swing.table.ITableSorter;
import com.wily.ui.swing.table.SortedSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter_v2
extends AbstractTableModel
implements ITableSorter,
TableModelListener {
    private static final long serialVersionUID = -2110585770465143794L;
    protected TableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private List viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();
    private final ListSelectionModel unsortedSelectionModel = new DefaultListSelectionModel();
    private final ListSelectionModel sortedSelectionModel = new SortedSelectionModel(this, this.unsortedSelectionModel);

    public TableSorter_v2() {
        this.mouseListener = new MouseHandler();
    }

    public TableSorter_v2(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableSorter_v2(TableModel tableModel, JTableHeader tableHeader) {
        this();
        this.setTableHeader(tableHeader);
        this.setTableModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public ListSelectionModel getSortedSelectionModel() {
        return this.sortedSelectionModel;
    }

    public ListSelectionModel getUnsortedSelectionModel() {
        return this.unsortedSelectionModel;
    }

    public int getLeadSelectionIndex() {
        if (this.unsortedSelectionModel.isSelectionEmpty()) {
            return -1;
        }
        return this.unsortedSelectionModel.getLeadSelectionIndex();
    }

    public int getSelectedIndex() {
        return this.getLeadSelectionIndex();
    }

    public int[] getSelectedRows() {
        if (this.unsortedSelectionModel.isSelectionEmpty()) {
            return new int[0];
        }
        int iMin = this.unsortedSelectionModel.getMinSelectionIndex();
        int iMax = this.unsortedSelectionModel.getMaxSelectionIndex();
        int[] selections = new int[iMax - iMin + 1];
        int selectionsTail = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!this.unsortedSelectionModel.isSelectedIndex(i)) continue;
            selections[selectionsTail++] = i;
        }
        int[] retVal = new int[selectionsTail];
        System.arraycopy(selections, 0, retVal, 0, selectionsTail);
        return retVal;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableRowsUpdated(0, this.getViewToModel().size() - 1);
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void sortByColumn(int column) {
        this.setSortingStatus(column, 1);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.setSortingStatus(column, ascending ? 1 : -1);
    }

    public void setSortingStatus(int column, int status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != 0) {
            this.sortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    public void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Class<?> columnType = this.tableModel.getColumnClass(column);
        Comparator comparator = (Comparator)this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private List getViewToModel() {
        if (this.viewToModel == null) {
            int tableModelRowCount = this.tableModel.getRowCount();
            ArrayList<Row> newModel = new ArrayList<Row>(tableModelRowCount);
            for (int row = 0; row < tableModelRowCount; ++row) {
                newModel.add(new Row(row));
            }
            if (this.isSorting()) {
                Collections.sort(newModel);
            }
            this.viewToModel = newModel;
        }
        return this.viewToModel;
    }

    private void insertSorted(int start, int count) {
        if (!this.isSorting()) {
            this.viewToModel = null;
            this.modelToView = null;
            this.fireTableRowsInserted(start, start + count - 1);
            this.unsortedSelectionModel.insertIndexInterval(start, count, true);
            return;
        }
        if (this.viewToModel == null) {
            this.getViewToModel();
            for (int i = 0; i < this.viewToModel.size(); ++i) {
                Row r = (Row)this.viewToModel.get(i);
                if (r.modelIndex < start || r.modelIndex >= start + count) continue;
                this.fireTableRowsInserted(i, i);
                this.unsortedSelectionModel.insertIndexInterval(i, 1, true);
            }
        } else {
            int i;
            int[] oldIndexes = this.getModelToView();
            int[] newIndexes = new int[oldIndexes.length + count];
            System.arraycopy(oldIndexes, 0, newIndexes, 0, start);
            System.arraycopy(oldIndexes, start, newIndexes, start + count, oldIndexes.length - start);
            for (i = start; i < oldIndexes.length; ++i) {
                ((Row)this.viewToModel.get(oldIndexes[i])).modelIndex = i + count;
            }
            for (i = 0; i < count; ++i) {
                Row row = new Row(start + i);
                int insertionPoint = Collections.binarySearch(this.getViewToModel(), row);
                if (insertionPoint < 0) {
                    insertionPoint = -insertionPoint - 1;
                }
                this.viewToModel.add(insertionPoint, row);
                this.modelToView = null;
                this.fireTableRowsInserted(insertionPoint, insertionPoint);
                this.unsortedSelectionModel.insertIndexInterval(start + i, 1, true);
            }
        }
    }

    private void remove(int start, int count) {
        if (!this.isSorting()) {
            this.viewToModel = null;
            this.modelToView = null;
            this.fireTableRowsDeleted(start, start + count - 1);
            this.unsortedSelectionModel.removeIndexInterval(start, start + count - 1);
            return;
        }
        if (this.viewToModel == null) {
            this.getViewToModel();
            for (int i = 0; i < this.viewToModel.size(); ++i) {
                Row r = (Row)this.viewToModel.get(i);
                if (r.modelIndex < start || r.modelIndex >= start + count) continue;
                this.unsortedSelectionModel.removeIndexInterval(i, i);
                this.fireTableRowsDeleted(i, i);
            }
        } else {
            boolean[] rowsToDelete = new boolean[this.viewToModel.size()];
            this.getModelToView();
            for (int i = 0; i < count; ++i) {
                rowsToDelete[this.modelToView[start + i]] = true;
            }
            for (int modelRow = start + count; modelRow < this.modelToView.length; ++modelRow) {
                Row r = (Row)this.getViewToModel().get(this.modelToView[modelRow]);
                r.modelIndex = modelRow - count;
            }
            int viewRow = 0;
            int preDeletionRowCount = 0;
            ListIterator eachRow = this.viewToModel.listIterator();
            while (eachRow.hasNext()) {
                int modelRow = ((Row)eachRow.next()).modelIndex;
                if (rowsToDelete[preDeletionRowCount]) {
                    eachRow.remove();
                    this.modelToView = null;
                    this.fireTableRowsDeleted(viewRow, viewRow);
                    this.unsortedSelectionModel.removeIndexInterval(modelRow, modelRow);
                } else {
                    ++viewRow;
                }
                ++preDeletionRowCount;
            }
        }
    }

    public int viewIndex(int modelIndex) {
        if (!this.isSorting()) {
            return modelIndex;
        }
        return this.getModelToView()[modelIndex];
    }

    public int getSortIndex(int sortedIndex) {
        return this.modelIndex(sortedIndex);
    }

    public int modelIndex(int viewIndex) {
        if (!this.isSorting()) {
            return viewIndex;
        }
        return ((Row)this.getViewToModel().get(viewIndex)).modelIndex;
    }

    public int reverseSortLookup(int unsortedIndex) {
        return this.viewIndex(unsortedIndex);
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().size();
            this.modelToView = new int[n];
            for (int viewIndex = 0; viewIndex < n; ++viewIndex) {
                int modelIndex = this.modelIndex(viewIndex);
                if (modelIndex >= this.modelToView.length) continue;
                this.modelToView[modelIndex] = viewIndex;
            }
        }
        return this.modelToView;
    }

    public int getRowCount() {
        return this.getViewToModel().size();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.modelIndex(row), column);
    }

    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(this.modelIndex(row), column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, this.modelIndex(row), column);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() == -1) {
            this.cancelSorting();
            this.fireTableChanged(e);
            return;
        }
        if (e.getType() == 1) {
            this.insertSorted(e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1);
            return;
        }
        if (e.getType() == -1) {
            this.remove(e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1);
            return;
        }
        if (!this.isSorting()) {
            this.clearSortingState();
            this.fireTableChanged(e);
            return;
        }
        int column = e.getColumn();
        if (e.getFirstRow() == e.getLastRow() && column != -1 && this.getSortingStatus(column) == 0 && this.modelToView != null) {
            int viewIndex = this.getModelToView()[e.getFirstRow()];
            this.fireTableChanged(new TableModelEvent(this, viewIndex, viewIndex, column, e.getType()));
            return;
        }
        if (e.getLastRow() == Integer.MAX_VALUE) {
            this.clearSortingState();
            this.fireTableDataChanged();
            return;
        }
        this.clearSortingState();
        this.fireTableRowsUpdated(0, this.getModelToView().length);
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(TableSorter_v2.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                int status = TableSorter_v2.this.getSortingStatus(column);
                if (!e.isControlDown()) {
                    TableSorter_v2.this.sortingColumns.clear();
                }
                status += e.isShiftDown() ? 1 : -1;
                status = (status + 4) % 3 - 1;
                TableSorter_v2.this.setSortingStatus(column, status);
            }
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            Iterator it = TableSorter_v2.this.sortingColumns.iterator();
            while (it.hasNext()) {
                Directive directive = (Directive)it.next();
                int column = directive.column;
                Object o1 = TableSorter_v2.this.tableModel.getValueAt(row1, column);
                Object o2 = TableSorter_v2.this.tableModel.getValueAt(row2, column);
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : TableSorter_v2.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }

        public String toString() {
            return "Row[" + this.modelIndex + "]";
        }
    }
}

