/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.statemachine;

import com.wily.util.statemachine.IState;
import com.wily.util.statemachine.InvalidFollowStateException;
import com.wily.util.statemachine.InvalidStateMachineException;
import com.wily.util.statemachine.NotInExpectedStateException;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;

public class StateMachine {
    private final IState[] fStateList;
    private volatile IState fCurrentState;
    private volatile int fNumThreadsWaiting;
    private final StateMachineLock fStateLock = new StateMachineLock();

    public StateMachine(IState[] stateList, IState startState) throws InvalidStateMachineException {
        this.validateStateList(stateList);
        this.validateStartState(stateList, startState);
        this.fStateList = stateList;
        this.fCurrentState = startState;
        this.fNumThreadsWaiting = 0;
    }

    private void validateStateList(IState[] stateList) throws InvalidStateMachineException {
        if (stateList == null || stateList.length == 0) {
            throw new InvalidStateMachineException(new SimpleLocalizableMessage("State_Machine_Empty_State_List_Key"));
        }
        for (int i = 0; i < stateList.length; ++i) {
            if (stateList[i] == null) {
                throw new InvalidStateMachineException(new SimpleLocalizableMessage("State_Machine_Missing_State_Key"));
            }
            for (int j = 0; j < i; ++j) {
                if (!stateList[i].equals(stateList[j])) continue;
                throw new InvalidStateMachineException(new FormattedLocalizableMessage("State_Machine_Duplicate_State_Key", stateList[i].IState_getName()));
            }
        }
    }

    private void validateStartState(IState[] stateList, IState state) throws InvalidStateMachineException {
        if (state == null) {
            throw new InvalidStateMachineException(new SimpleLocalizableMessage("State_Machine_Missing_Start_State_Key"));
        }
        if (!this.containsState(stateList, state)) {
            throw new InvalidStateMachineException(new FormattedLocalizableMessage("State_Machine_Invalid_Start_State_Key", state.IState_getName()));
        }
    }

    private StateMachineLock getStateMachineLock() {
        return this.fStateLock;
    }

    private boolean isValidState(IState state) {
        if (state != null) {
            for (int i = 0; i < this.fStateList.length; ++i) {
                if (!this.fStateList[i].equals(state)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasValidState(IState[] states) {
        if (states != null) {
            for (int i = 0; i < states.length; ++i) {
                if (!this.isValidState(states[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsState(IState[] states, IState state) {
        if (states != null && state != null) {
            for (int i = 0; i < states.length; ++i) {
                if (state != states[i]) continue;
                return true;
            }
        }
        return false;
    }

    public IState getState() {
        return this.fCurrentState;
    }

    public int getNumThreadsWaiting() {
        return this.fNumThreadsWaiting;
    }

    private void addWaitingThread() {
        ++this.fNumThreadsWaiting;
    }

    private void removeWaitingThread() {
        --this.fNumThreadsWaiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(IState state) throws InvalidFollowStateException {
        StateMachineLock lock;
        if (state == null) {
            throw new InvalidFollowStateException(new SimpleLocalizableMessage("State_Machine_Missing_Follow_State_Key"));
        }
        if (!this.isValidState(state)) {
            throw new InvalidFollowStateException(new FormattedLocalizableMessage("State_Machine_Invalid_State_Key", state.IState_getName()));
        }
        StateMachineLock stateMachineLock = lock = this.getStateMachineLock();
        synchronized (stateMachineLock) {
            if (!this.getState().IState_isValidFollowState(state)) {
                throw new InvalidFollowStateException(new FormattedLocalizableMessage("State_Machine_Invalid_Follow_State_Key", state.IState_getName()));
            }
            this.fCurrentState = state;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void followTransition(IState currentState, IState targetState) throws InvalidFollowStateException, NotInExpectedStateException {
        if (currentState == null) {
            throw new NotInExpectedStateException(new FormattedLocalizableMessage("State_Machine_Not_In_Expected_State_Key", this.getState().IState_getName(), null));
        }
        StateMachineLock stateMachineLock = this.getStateMachineLock();
        synchronized (stateMachineLock) {
            if (this.getState() != currentState) {
                throw new NotInExpectedStateException(new FormattedLocalizableMessage("State_Machine_Not_In_Expected_State_Key", this.getState().IState_getName(), currentState.IState_getName()));
            }
            this.setState(targetState);
        }
    }

    public void waitForStates(IState[] states) throws InterruptedException {
        this.waitForStates(states, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStates(IState[] states, long timeout) throws InterruptedException {
        Assertion.wilyAssert(timeout >= 0L);
        if (timeout >= 0L && this.hasValidState(states)) {
            StateMachineLock lock;
            StateMachineLock stateMachineLock = lock = this.getStateMachineLock();
            synchronized (stateMachineLock) {
                try {
                    this.addWaitingThread();
                    long endTime = System.currentTimeMillis() + timeout;
                    while (!this.containsState(states, this.getState()) && !this.timeoutExpired(timeout, endTime)) {
                        lock.wait(timeout);
                    }
                }
                finally {
                    this.removeWaitingThread();
                }
            }
        }
    }

    private boolean timeoutExpired(long timeout, long endTime) {
        if (timeout > 0L) {
            return System.currentTimeMillis() >= endTime;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUnderStateMachineLock(Runnable runnable) {
        if (runnable != null) {
            StateMachineLock stateMachineLock = this.getStateMachineLock();
            synchronized (stateMachineLock) {
                runnable.run();
            }
        }
    }

    private static class StateMachineLock {
        private StateMachineLock() {
        }
    }
}

