/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.DirectivesFileParser;
import com.wily.diagnos.cmp.directives.IDirective;
import com.wily.diagnos.cmp.directives.IDirectiveCollection;
import com.wily.diagnos.cmp.directives.IDirectiveHandler;
import com.wily.diagnos.cmp.directives.apply.PersistenceFileLockHelper;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.cmp.directives.parser.DirectiveParser;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.InvalidResourceException;
import com.wily.util.validate.ValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class DirectivesFile
implements IDirectiveHandler,
IDirectiveCollection {
    private final ICompilerPersonality fPersonality;
    private List fDirectives;
    private Vector fText;
    private String fName;
    private DGParserException fSavedParserException;
    private IOException fSavedIOException;
    private static String retryTimeoutString = System.getProperty("introscope.agent.deep.persistence.retry.timeout");
    private static String retryAttemptsString = System.getProperty("introscope.agent.deep.persistence.retry.attempts.reader");

    public DirectivesFile(ICompilerPersonality personality) {
        this.fPersonality = personality;
        this.fDirectives = Collections.synchronizedList(new ArrayList());
        this.fText = new Vector();
        this.fName = null;
        this.fSavedParserException = null;
        this.fSavedIOException = null;
    }

    public DirectivesFile(ICompilerPersonality personality, String name) throws DGParserException, IOException {
        this(personality, new File(name));
    }

    public DirectivesFile(ICompilerPersonality personality, File source) throws DGParserException, IOException {
        this(personality);
        File file = new File(ExtendedFile.safeGetCanonicalPath(source));
        this.load(file.getAbsolutePath(), false, new FileInputStream(file));
    }

    public DirectivesFile(ICompilerPersonality personality, IResourceReader resourceReader, String name) throws DGParserException, InvalidResourceException, IOException {
        this(personality, resourceReader.IResourceReader_getResourceLocation(name), !resourceReader.IResourceReader_isPlatformSpecific(name), resourceReader.IResourceReader_getResource(name));
    }

    public DirectivesFile(ICompilerPersonality personality, String name, InputStream input) throws DGParserException, IOException {
        this(personality);
        this.load(name, false, input);
    }

    public DirectivesFile(ICompilerPersonality personality, String name, boolean forceUtf8, InputStream input) throws DGParserException, IOException {
        this(personality);
        this.load(name, forceUtf8, input);
    }

    /*
     * Unable to fully structure code
     */
    private void load(String name, boolean forceUtf8, InputStream input) throws DGParserException, IOException {
        block9: {
            block10: {
                count = 0;
                this.fName = name;
                lockAcquired = false;
                if (!name.contains("AutoPersist.pbd") || !PersistenceFileLockHelper.initializeSuccessful) ** GOTO lbl25
                retryTimeout = DirectivesFile.retryTimeoutString == null ? 500 : Integer.parseInt(DirectivesFile.retryTimeoutString);
                retryAttempts = DirectivesFile.retryAttemptsString == null ? 3 : Integer.parseInt(DirectivesFile.retryAttemptsString);
                while ((PersistenceFileLockHelper.hasLock() && PersistenceFileLockHelper.isLockValid() || PersistenceFileLockHelper.trySharedLock() == null) && count < retryAttempts) {
                    Thread.sleep(retryTimeout);
                    ++count;
                }
                if (count != retryAttempts) break block9;
                lockAcquired = false;
                this.fSavedParserException = null;
                this.fSavedIOException = null;
                if (!lockAcquired) break block10;
                PersistenceFileLockHelper.releaseLock();
                lockAcquired = false;
            }
            return;
        }
        try {
            try {
                lockAcquired = true;
lbl25:
                // 2 sources

                DirectivesFileParser.parse(input, forceUtf8, this);
            }
            catch (InterruptedException v0) {
            }
            catch (IOException ioe) {
                this.throwSavedException();
                throw ioe;
            }
            this.throwSavedException();
        }
        catch (Throwable var8_9) {
            throw var8_9;
        }
        finally {
            this.fSavedParserException = null;
            this.fSavedIOException = null;
            if (lockAcquired) {
                PersistenceFileLockHelper.releaseLock();
                lockAcquired = false;
            }
        }
    }

    private void throwSavedException() throws DGParserException, IOException {
        if (this.fSavedParserException != null) {
            throw this.fSavedParserException;
        }
        if (this.fSavedIOException != null) {
            throw this.fSavedIOException;
        }
    }

    public void IDirectiveHandler_handleTextLine(String line) {
        this.fText.addElement(line);
    }

    public void IDirectiveHandler_handleDirective(String line) {
        if (this.fSavedParserException != null || this.fSavedIOException != null) {
            return;
        }
        try {
            IDirective directive = DirectiveParser.parse(this.fPersonality, line, this.fName, this.fText.size());
            if (directive != null) {
                this.addDirective(directive);
            }
        }
        catch (DGParserException dgpe) {
            this.fSavedParserException = dgpe;
        }
        catch (IOException ioe) {
            this.fSavedIOException = ioe;
        }
    }

    public void addDirective(IDirective directive) {
        this.fDirectives.add(directive);
    }

    public String getName() {
        return this.fName;
    }

    public String getSimpleName() {
        return new File(this.fName).getName();
    }

    public String toString() {
        return this.getSimpleName();
    }

    public List getText() {
        return this.fText;
    }

    public int compareTo(Object o) {
        if (o instanceof DirectivesFile) {
            return this.getName().compareTo(((DirectivesFile)o).getName());
        }
        throw new ClassCastException("Invalid object compared to DirectivesFile");
    }

    public Iterator getDirectives() {
        return this.fDirectives.iterator();
    }

    public void applyDirectivesToSettings(CompilerSettingsBuilder builder) throws ValidationException {
        Iterator iter = this.getDirectives();
        while (iter.hasNext()) {
            IDirective directive = (IDirective)iter.next();
            directive.IDirective_applyToSettings(builder);
        }
    }
}

