/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.api;

import com.wily.introscope.agent.api.ADataRecorderImpl;
import com.wily.introscope.agent.api.IllegalValueException;
import com.wily.introscope.agent.api.IntRateDataRecorder;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;

final class IntRateDataRecorderImpl
extends ADataRecorderImpl
implements IntRateDataRecorder {
    private static final String KNumberOfIncidentMustBePositiveMessage = "Number of incidents must be positive";

    IntRateDataRecorderImpl(IIntegerRateDataAccumulator backingAccumulator, MetricRecordingAdministrator metricRecordingAdministrator) {
        super(backingAccumulator, metricRecordingAdministrator);
    }

    private IIntegerRateDataAccumulator getIntegerRateDataAccumulator() {
        return (IIntegerRateDataAccumulator)this.getBackingDataAccumulator();
    }

    public void recordIncident() {
        if (!this.isShutoff()) {
            this.getIntegerRateDataAccumulator().IIntegerRateDataAccumulator_addSingleIncident();
        }
    }

    public void recordMultipleIncidents(int incidentCount) throws IllegalValueException {
        if (incidentCount <= 0) {
            throw new IllegalValueException(KNumberOfIncidentMustBePositiveMessage);
        }
        if (!this.isShutoff()) {
            this.getIntegerRateDataAccumulator().IIntegerRateDataAccumulator_addBatchIncidents(incidentCount);
        }
    }
}

