/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IErrorSubscriber;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IStallSubscriber;
import com.wily.introscope.agent.trace.cas.IStringRepresentable;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;

public class WilyTransactionElement
extends BlameTransactionElement
implements IErrorSubscriber,
IStallSubscriber,
IStringRepresentable {
    static final CopyOnWriteArraySet kStaticRepository = new CopyOnWriteArraySet();
    final IRepository fTimerDataStructure;
    final IRepository fPerIntervalDataStructure;
    final ICounterRepository fConcurrentInvocationDataStructure;
    final CopyOnWriteArraySet fConcurrentInvocationSet;
    volatile ICounterRepository[] fConcurrentInvocation;
    volatile int invocationSetSize;
    final IRepository fErrorsDataStructure;
    public final IRepository fStallsDataStructure;
    public final ProbeInformation fInfo;
    final boolean isSubscribedForDownstreamErrors;
    final boolean isSubscribedForDownstreamStalls;
    private volatile boolean hasCalledBackendMetrics = false;
    private long fFilterEnablerBit = Long.MAX_VALUE;

    public WilyTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation info, boolean isSubscribedForDownstreamErrors, boolean isSubscribedForDownstreamStalls) {
        super(componentName, isStartTrace, blameStatus, parent, previous, start, agentMetrics);
        this.fTimerDataStructure = fTimerDataStructure;
        this.fPerIntervalDataStructure = fPerIntervalDataStructure;
        if (agentMetrics != null) {
            this.fConcurrentInvocation = new ICounterRepository[1];
            this.fConcurrentInvocation[0] = (ICounterRepository)fConcurrentInvocationDataStructure;
            this.fConcurrentInvocationSet = new CopyOnWriteArraySet();
            this.fConcurrentInvocationSet.add(fConcurrentInvocationDataStructure);
            this.fConcurrentInvocationDataStructure = null;
        } else {
            this.fConcurrentInvocation = new ICounterRepository[0];
            this.fConcurrentInvocationSet = kStaticRepository;
            this.fConcurrentInvocationDataStructure = (ICounterRepository)fConcurrentInvocationDataStructure;
        }
        this.fErrorsDataStructure = fErrorsDataStructure;
        this.fStallsDataStructure = fStallsDataStructure;
        this.isSubscribedForDownstreamErrors = isSubscribedForDownstreamErrors;
        this.isSubscribedForDownstreamStalls = isSubscribedForDownstreamStalls;
        this.fInfo = info;
    }

    public WilyTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation info, boolean isSubscribedForDownstreamErrors, boolean isSubscribedForDownstreamStalls, long filterEnablerBit) {
        this(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, fTimerDataStructure, fPerIntervalDataStructure, fConcurrentInvocationDataStructure, fErrorsDataStructure, fStallsDataStructure, info, isSubscribedForDownstreamErrors, isSubscribedForDownstreamStalls);
        this.fFilterEnablerBit = filterEnablerBit;
    }

    public WilyTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation info, String nodeType, String ownerType, String appMapName, String btcMapName, String nodeLevel, String boundaryType) {
        this(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, fTimerDataStructure, fPerIntervalDataStructure, fConcurrentInvocationDataStructure, fErrorsDataStructure, fStallsDataStructure, info, false, false);
    }

    @Override
    public String toString() {
        return this.getParent() + this.getStringRepresentation();
    }

    @Override
    public String getStringRepresentation() {
        return "(WTE" + (this.isStartTrace() ? "-S)" : "-E)") + this.fComponentName + ";" + (this.isBackend() ? "[B]" : String.valueOf(this.isFrontend() ? "[F]" : "[N]") + "[" + this.countChildren() + "]" + (this.fUseMap ? "+" : "-"));
    }

    public String getBlameName() {
        return this.fComponentName;
    }

    public void addConcurrentInvocation(IRepository concurrentSds) {
        if (this.fConcurrentInvocationSet != kStaticRepository) {
            ICounterRepository[] newRepository;
            int newSize;
            if (this.fConcurrentInvocationSet.add(concurrentSds)) {
                WilyTransactionStructure.addTransactionElementReferrer(concurrentSds, this);
            }
            do {
                newSize = this.fConcurrentInvocationSet.size();
                newRepository = new ICounterRepository[newSize];
                int i = 0;
                Iterator iter = this.fConcurrentInvocationSet.iterator();
                while (iter.hasNext()) {
                    if (i >= newRepository.length) continue;
                    newRepository[i] = (ICounterRepository)iter.next();
                    ++i;
                }
            } while (newSize != this.fConcurrentInvocationSet.size());
            this.fConcurrentInvocation = newRepository;
        }
    }

    @Override
    public String getComponentName() {
        return this.fComponentName;
    }

    public IRepository getPerIntervalRepository() {
        return this.fPerIntervalDataStructure;
    }

    public IRepository getTimerRepository() {
        return this.fTimerDataStructure;
    }

    public IRepository getErrorsRepository() {
        return this.fErrorsDataStructure;
    }

    public IRepository getStallsRepository() {
        return this.fStallsDataStructure;
    }

    public CopyOnWriteArraySet getConcurrentInvocationsRepository() {
        return this.fConcurrentInvocationSet;
    }

    public ICounterRepository[] getConcurrentInvocationsRepositoryAsArray() {
        return this.fConcurrentInvocation;
    }

    public int getPosition() {
        return 0;
    }

    @Override
    public boolean subscribeToDownstreamStalls() {
        return this.isSubscribedForDownstreamStalls;
    }

    @Override
    public IRepository getLocalStallRepository() {
        return this.fStallsDataStructure;
    }

    @Override
    public boolean subscribeToDownstreamErrors() {
        return this.isSubscribedForDownstreamErrors;
    }

    @Override
    public IRepository getLocalErrorRepository() {
        return this.fErrorsDataStructure;
    }

    public ICounterRepository getConcurrentInvocations() {
        return this.fConcurrentInvocationDataStructure;
    }

    @Override
    public IErrorSubscriber getErrorSubscriber() {
        return this;
    }

    @Override
    public IStallSubscriber getStallSubscriber() {
        return this;
    }

    @Override
    public long getFilterEnablerBit() {
        return this.fFilterEnablerBit;
    }

    @Override
    public void notifyPublished() {
        if (this.getMetrics() == null) {
            if (this.fTimerDataStructure != null) {
                WilyTransactionStructure.addTransactionElementReferrer(this.fTimerDataStructure, this);
            }
            if (this.fPerIntervalDataStructure != null) {
                WilyTransactionStructure.addTransactionElementReferrer(this.fPerIntervalDataStructure, this);
            }
            if (this.fStallsDataStructure != null) {
                WilyTransactionStructure.addTransactionElementReferrer(this.fStallsDataStructure, this);
            }
            if (this.fErrorsDataStructure != null) {
                WilyTransactionStructure.addTransactionElementReferrer(this.fErrorsDataStructure, this);
            }
        }
        if (this.fConcurrentInvocationDataStructure != null) {
            WilyTransactionStructure.addTransactionElementReferrer(this.fConcurrentInvocationDataStructure, this);
        } else {
            int i = 0;
            while (i < this.fConcurrentInvocation.length) {
                if (this.fConcurrentInvocation[i] != null) {
                    WilyTransactionStructure.addTransactionElementReferrer(this.fConcurrentInvocation[i], this);
                }
                ++i;
            }
        }
    }

    @Override
    public void notifyRemoved() {
        this.invalidate();
        if (this.getMetrics() == null) {
            if (this.fTimerDataStructure != null) {
                WilyTransactionStructure.removeTransactionElementReferrer(this.fTimerDataStructure, this);
            }
            if (this.fPerIntervalDataStructure != null) {
                WilyTransactionStructure.removeTransactionElementReferrer(this.fPerIntervalDataStructure, this);
            }
            if (this.fStallsDataStructure != null) {
                WilyTransactionStructure.removeTransactionElementReferrer(this.fStallsDataStructure, this);
            }
            if (this.fErrorsDataStructure != null) {
                WilyTransactionStructure.removeTransactionElementReferrer(this.fErrorsDataStructure, this);
            }
        }
        if (this.fConcurrentInvocationDataStructure != null) {
            WilyTransactionStructure.removeTransactionElementReferrer(this.fConcurrentInvocationDataStructure, this);
        } else {
            int i = 0;
            while (i < this.fConcurrentInvocation.length) {
                if (this.fConcurrentInvocation[i] != null) {
                    WilyTransactionStructure.removeTransactionElementReferrer(this.fConcurrentInvocation[i], this);
                }
                ++i;
            }
        }
    }

    public WilyTransactionElement getWilyStartTraceBlamePoint() {
        return (WilyTransactionElement)this.getStartTraceBlamePoint();
    }

    public void setHasCalledBackendMetrics(boolean hasCalledBackendMetrics) {
        this.hasCalledBackendMetrics = hasCalledBackendMetrics;
    }

    public boolean isHasCalledBackendMetrics() {
        IBlameTransactionElement startTrace = this.getStartTraceBlamePoint();
        return startTrace != null ? ((WilyTransactionElement)startTrace).hasCalledBackendMetrics : this.hasCalledBackendMetrics;
    }
}

