/*
 * Decompiled with CFR 0.152.
 */
package com.wily.jip.tcp;

import com.wily.jip.IJIPConnection;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class JIPTCPConnection
implements IJIPConnection {
    private Socket fSocket;
    private InputStream fReadStream;
    private OutputStream fWriteStream;
    private int fReadBufferSize;
    private int fWriteBufferSize;
    private String fSocketName;

    public JIPTCPConnection(Socket openSocket, int socketReadTimeoutInMillis) throws IOException {
        this.fSocket = openSocket;
        this.fSocket.setSoTimeout(socketReadTimeoutInMillis);
        this.fReadStream = this.fSocket.getInputStream();
        this.fReadBufferSize = this.fSocket.getReceiveBufferSize();
        this.fWriteBufferSize = this.fSocket.getSendBufferSize();
        this.fWriteStream = new BufferedOutputStream(this.fSocket.getOutputStream(), this.fWriteBufferSize);
        this.fSocketName = this.fSocket.toString();
    }

    public InputStream IJIPConnection_getReadStream() {
        return this.fReadStream;
    }

    public OutputStream IJIPConnection_getWriteStream() {
        return this.fWriteStream;
    }

    public void IJIPConnection_setSocketTimeout(int timeoutInMillis) {
        if (this.fSocket != null) {
            try {
                this.fSocket.setSoTimeout(timeoutInMillis);
            }
            catch (SocketException socketException) {}
        }
    }

    public int IJIPConnection_getSocketTimeoutInMillis() {
        int timeout = 0;
        if (this.fSocket != null) {
            try {
                timeout = this.fSocket.getSoTimeout();
            }
            catch (SocketException socketException) {}
        }
        return timeout;
    }

    public void IJIPConnection_close() throws IOException {
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
            }
        }
        catch (IOException iOException) {}
        this.fSocket = null;
        try {
            if (this.fReadStream != null) {
                this.fReadStream.close();
            }
        }
        catch (IOException iOException) {}
        this.fReadStream = null;
        try {
            if (this.fWriteStream != null) {
                this.fWriteStream.close();
            }
        }
        catch (IOException iOException) {}
        this.fWriteStream = null;
    }

    public String toString() {
        return this.fSocketName;
    }

    public String IJIPConnection_toString() {
        return this.toString();
    }

    public int IJIPConnection_getReadBufferSize() {
        return this.fReadBufferSize;
    }

    public int IJIPConnection_getWriteBufferSize() {
        return this.fWriteBufferSize;
    }
}

