/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.httpclient;

import com.wily.org.apache.commons.httpclient.Header;
import com.wily.org.apache.commons.httpclient.HttpException;
import com.wily.org.apache.commons.httpclient.HttpMethod;
import com.wily.org.apache.commons.httpclient.HttpParser;
import com.wily.org.apache.commons.httpclient.util.EncodingUtil;
import com.wily.org.apache.commons.httpclient.util.ExceptionUtil;
import com.wily.org.apache.commons.logging.Log;
import com.wily.org.apache.commons.logging.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int chunkSize;
    private int pos;
    private boolean bof = true;
    private boolean eof = false;
    private boolean closed = false;
    private HttpMethod method = null;
    private static final Log LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.org.apache.commons.httpclient.ChunkedInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog(clazz);
    }

    public ChunkedInputStream(InputStream in, HttpMethod method) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream parameter may not be null");
        }
        this.in = in;
        this.method = method;
        this.pos = 0;
    }

    public ChunkedInputStream(InputStream in) throws IOException {
        this(in, null);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        len = Math.min(len, this.chunkSize - this.pos);
        int count = this.in.read(b, off, len);
        this.pos += count;
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void readCRLF() throws IOException {
        int cr = this.in.read();
        int lf = this.in.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("CRLF expected at end of chunk: " + cr + "/" + lf);
        }
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.readCRLF();
        }
        this.chunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.in);
        this.bof = false;
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseTrailerHeaders();
        }
    }

    private static int getChunkSizeFromInputStream(InputStream in) throws IOException {
        int result;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int state = 0;
        while (state != -1) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            block1 : switch (state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            state = 1;
                            break block1;
                        }
                        case 34: {
                            state = 2;
                        }
                    }
                    baos.write(b);
                    break;
                }
                case 1: {
                    if (b == 10) {
                        state = -1;
                        break;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (b) {
                        case 92: {
                            b = in.read();
                            baos.write(b);
                            break block1;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    baos.write(b);
                    break;
                }
                default: {
                    throw new RuntimeException("assertion failed");
                }
            }
        }
        String dataString = EncodingUtil.getAsciiString(baos.toByteArray());
        int separator = dataString.indexOf(59);
        dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad chunk size: " + dataString);
        }
        return result;
    }

    private void parseTrailerHeaders() throws IOException {
        Header[] footers = null;
        try {
            String charset = "US-ASCII";
            if (this.method != null) {
                charset = this.method.getParams().getHttpElementCharset();
            }
            footers = HttpParser.parseHeaders(this.in, charset);
        }
        catch (HttpException e) {
            LOG.error("Error parsing trailer headers", e);
            IOException ioe = new IOException(e.getMessage());
            ExceptionUtil.initCause(ioe, e);
            throw ioe;
        }
        if (this.method != null) {
            int i = 0;
            while (i < footers.length) {
                this.method.addResponseFooter(footers[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.closed) return;
        try {
            if (!this.eof) {
                ChunkedInputStream.exhaustInputStream(this);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.eof = true;
            this.closed = true;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.eof = true;
            this.closed = true;
            return;
        }
    }

    static void exhaustInputStream(InputStream inStream) throws IOException {
        byte[] buffer = new byte[1024];
        while (inStream.read(buffer) >= 0) {
        }
    }
}

