/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ExtendedCharacterEncoding {
    private ExtendedCharacterEncoding() {
    }

    public static OutputStreamWriter getUTF8OutputStreamWriter(OutputStream outputStream) throws IOException {
        OutputStreamWriter osw;
        if (outputStream == null) {
            throw new NullPointerException();
        }
        try {
            osw = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (Throwable throwable) {
            try {
                osw = new OutputStreamWriter(outputStream, "UTF8");
            }
            catch (Throwable anotherT) {
                throw new IOException(anotherT.getMessage());
            }
        }
        return osw;
    }

    public static InputStreamReader getUTF8InputStreamReader(InputStream inputStream) throws IOException {
        InputStreamReader isr;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            isr = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Throwable throwable) {
            try {
                isr = new InputStreamReader(inputStream, "UTF8");
            }
            catch (Throwable anotherT) {
                throw new IOException(anotherT.getMessage());
            }
        }
        return isr;
    }

    public static byte[] getUTF8Bytes(String aString) throws IOException {
        byte[] result;
        try {
            result = aString.getBytes("UTF-8");
        }
        catch (Throwable throwable) {
            try {
                result = aString.getBytes("UTF8");
            }
            catch (Throwable anotherT) {
                throw new IOException(anotherT.getMessage());
            }
        }
        return result;
    }

    public static String getUTF8String(byte[] aBuffer) throws IOException {
        String result;
        try {
            result = new String(aBuffer, "UTF-8");
        }
        catch (Throwable throwable) {
            try {
                result = new String(aBuffer, "UTF8");
            }
            catch (Throwable anotherT) {
                throw new IOException(anotherT.getMessage());
            }
        }
        return result;
    }
}

