/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class WrapperUtils {
    private static IAgent fAgent;
    public static final String JAR_FILE_EXTENSION = ".jar";
    private static final String kLineSeparatorPropertyName = "line.separator";

    public static File getJARFile(String dir, String jarManifestAttributeName, String jarManifestAttributeValue) {
        List<File> fileList;
        File jarFile = null;
        if (dir != null && dir.length() > 0 && jarManifestAttributeName != null && jarManifestAttributeName.length() > 0 && jarManifestAttributeValue != null && jarManifestAttributeValue.length() > 0 && (fileList = WrapperUtils.listJARFilesByAttributeNameAndValue(dir, jarManifestAttributeName, jarManifestAttributeValue)) != null) {
            if (fileList.isEmpty()) {
                fAgent.IAgent_getModuleFeedback().debug("\n There are no JARs which contain the manifest attribute name: " + jarManifestAttributeName + " and manifest attribute value: " + jarManifestAttributeValue);
            } else if (fileList.size() == 1) {
                jarFile = fileList.get(0);
            } else if (fileList.size() > 1) {
                fAgent.IAgent_getModuleFeedback().debug("\n There are more than one JAR which contain the manifest attribute name: " + jarManifestAttributeName + " and manifest attribute value: " + jarManifestAttributeValue + "\n The JARs are: " + fileList + "\n One JAR would be picked from this list randomly.");
                jarFile = fileList.get(0);
            }
        }
        if (jarFile != null) {
            try {
                fAgent.IAgent_getModuleFeedback().debug("\n The JAR: " + jarFile.getCanonicalPath() + " that contains the manifest attribute name: " + jarManifestAttributeName + " and manifest attribute value: " + jarManifestAttributeValue + " would be considered for ClassLoader.");
            }
            catch (IOException e) {
                fAgent.IAgent_getModuleFeedback().error("IOException: " + e);
            }
        }
        return jarFile;
    }

    public static List<File> listJARFilesByAttributeNameAndValue(String dir, String manifestAttributeName, String manifestAttributeValue) {
        File[] listOfFiles;
        File folder;
        ArrayList<File> jarFileList = new ArrayList<File>();
        if (dir != null && dir.length() > 0 && manifestAttributeName != null && manifestAttributeName.length() > 0 && manifestAttributeValue != null && manifestAttributeValue.length() > 0 && (folder = new File(dir)) != null && (listOfFiles = folder.listFiles()) != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                File file = listOfFiles[i];
                if (file != null && file.isFile() && file.canRead() && WrapperUtils.hasMatchingFileExtension(file, JAR_FILE_EXTENSION) && WrapperUtils.isMatchingJARByManifestAttributeNameAndValue(file, manifestAttributeName, manifestAttributeValue)) {
                    jarFileList.add(file);
                }
                ++i;
            }
        }
        fAgent.IAgent_getModuleFeedback().debug("\n jarFileList: " + jarFileList);
        return jarFileList;
    }

    public static boolean hasMatchingFileExtension(File file, String fileExtension) {
        boolean isMatchingFileExtensionFlag = false;
        if (file != null && fileExtension != null && fileExtension.length() > 0 && file.getName() != null && file.getName().endsWith(fileExtension)) {
            isMatchingFileExtensionFlag = true;
        }
        return isMatchingFileExtensionFlag;
    }

    public static boolean isMatchingJARByManifestAttributeNameAndValue(File file, String manifestAttributeName, String manifestAttributeValue) {
        boolean flag;
        block4: {
            flag = false;
            if (file != null && manifestAttributeName != null && manifestAttributeName.length() > 0 && manifestAttributeValue != null && manifestAttributeValue.length() > 0) {
                try {
                    Attributes attrs;
                    Manifest manifest;
                    JarFile jarFile = new JarFile(file);
                    if (jarFile == null || (manifest = jarFile.getManifest()) == null || (attrs = manifest.getMainAttributes()) == null) break block4;
                    for (Attributes.Name name : attrs.keySet()) {
                        String attrValue = attrs.getValue(name);
                        if (!name.toString().equals(manifestAttributeName) || attrValue == null || !attrValue.equals(manifestAttributeValue)) continue;
                        flag = true;
                        break;
                    }
                }
                catch (IOException e) {
                    fAgent.IAgent_getModuleFeedback().error("IOException: " + e);
                }
            }
        }
        return flag;
    }

    public static URLClassLoader getJARClassLoader(ClassLoader parent, IAgent agent, String jarManifestAttributeName, String jarManifestAttributeValue) throws MalformedURLException {
        URLClassLoader urlClassLoader = null;
        String extensionDir = null;
        if (parent != null && agent != null && jarManifestAttributeName != null && jarManifestAttributeName.length() > 0 && jarManifestAttributeValue != null && jarManifestAttributeValue.length() > 0) {
            URL[] urlResources;
            IResource resource;
            fAgent = agent;
            fAgent.IAgent_getModuleFeedback().debug("\n jarManifestAttributeName: " + jarManifestAttributeName);
            fAgent.IAgent_getModuleFeedback().debug("\n jarManifestAttributeValue: " + jarManifestAttributeValue);
            String directoryProperty = (String)agent.IAgent_getIndexedProperties().get("introscope.agent.extensions.directory");
            fAgent.IAgent_getModuleFeedback().debug("\n directoryProperty: " + directoryProperty);
            extensionDir = ExtendedFile.isAbsolutePath(directoryProperty) ? WrapperUtils.getExtensionDirectory() : String.valueOf(WrapperUtils.getAbsoluteAgentPath()) + File.separator + WrapperUtils.getExtensionDirectory();
            fAgent.IAgent_getModuleFeedback().debug("\n extensionDir: " + extensionDir);
            File jarFile = WrapperUtils.getJARFile(extensionDir, jarManifestAttributeName, jarManifestAttributeValue);
            if (jarFile != null && (resource = WrapperUtils.getFileResource(jarFile)) != null && (urlResources = new URL[]{resource.IResource_getURL()}) != null) {
                urlClassLoader = new URLClassLoader(urlResources, parent);
            }
        }
        if (urlClassLoader != null) {
            fAgent.IAgent_getModuleFeedback().debug("\n urlClassLoader: " + urlClassLoader);
        } else {
            fAgent.IAgent_getModuleFeedback().info("\n No JAR with the matching manifest attribute: " + jarManifestAttributeName + " and value: " + jarManifestAttributeValue + " can be found in the " + "extensionDirectory: " + extensionDir + ".  Returning null ClassLoader.");
        }
        return urlClassLoader;
    }

    public static String getAbsoluteAgentPath() {
        String path = "";
        IResource profileResource = fAgent.IAgent_getConfigurationResource();
        if (profileResource.IResource_isFileResource()) {
            File profileDirectory = new File(profileResource.IResource_getLocation()).getParentFile();
            File pathFile = new File(profileDirectory, path);
            path = pathFile.getAbsolutePath();
        }
        return path;
    }

    public static IResource getDirFinder(String directoryName, String fileName) {
        ExtendedFile wilyDirectory = new ExtendedFile(directoryName);
        String fullPath = new ExtendedFile(wilyDirectory, fileName).safeGetCanonicalPath();
        return new FileBasedResource(fullPath);
    }

    public static IResource getFileResource(File file) {
        String extendedFileCanonicalPath;
        ExtendedFile extendedFile;
        FileBasedResource fileResource = null;
        if (file != null && file.exists() && file.canRead() && (extendedFile = new ExtendedFile(file)) != null && (extendedFileCanonicalPath = extendedFile.safeGetCanonicalPath()) != null) {
            fileResource = new FileBasedResource(extendedFileCanonicalPath);
        }
        if (fileResource != null) {
            fAgent.IAgent_getModuleFeedback().debug("\n fileResource: " + fileResource);
        }
        return fileResource;
    }

    public static String getExtensionDirectory() {
        String extFolder = "";
        try {
            IndexedProperties props = WrapperUtils.getAgentConfiguration();
            extFolder = props.getTrimmedProperty("introscope.agent.extensions.directory");
        }
        catch (AgentNotAvailableException bomb) {
            fAgent.IAgent_getModuleFeedback().error("getExtensionDirectory " + WrapperUtils.dumpStackTrace(bomb));
        }
        return extFolder;
    }

    public static IndexedProperties getAgentConfiguration() throws AgentNotAvailableException {
        return fAgent.IAgent_getIndexedProperties();
    }

    public static String dumpStackTrace(Throwable bomb) {
        StackTracePrintStream stack = new StackTracePrintStream((OutputStream)new ByteArrayOutputStream(), 1024);
        bomb.printStackTrace(stack);
        return stack.getString();
    }

    private static class StackTracePrintStream
    extends PrintStream {
        private final char[] fLineSeparator = System.getProperty("line.separator").toCharArray();
        private int fCursor = 0;
        private char[] fChars;
        private int fCharCount;

        public StackTracePrintStream(OutputStream dummy, int initialSize) {
            super(dummy);
            this.fChars = new char[initialSize];
            this.fCharCount = initialSize;
        }

        @Override
        public synchronized void print(char[] data) {
            while (this.fCursor + data.length > this.fCharCount) {
                this.growBuffer();
            }
            System.arraycopy(data, 0, this.fChars, this.fCursor, data.length);
            this.fCursor += data.length;
        }

        @Override
        public synchronized void print(String s) {
            if (s == null) {
                s = "null";
            }
            int length = s.length();
            while (this.fCursor + length > this.fCharCount) {
                this.growBuffer();
            }
            s.getChars(0, length, this.fChars, this.fCursor);
            this.fCursor += length;
        }

        @Override
        public synchronized void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        @Override
        public synchronized void println(char[] data) {
            this.print(data);
            this.printSeparator();
        }

        @Override
        public synchronized void println(String s) {
            this.print(s);
            this.printSeparator();
        }

        @Override
        public synchronized void println(Object obj) {
            this.print(obj);
            this.printSeparator();
        }

        @Override
        public synchronized void println() {
            this.printSeparator();
        }

        private void printSeparator() {
            this.print(this.fLineSeparator);
        }

        private void growBuffer() {
            int newSize = this.fCharCount * 2;
            char[] newBuffer = new char[newSize];
            System.arraycopy(this.fChars, 0, newBuffer, 0, this.fCharCount);
            this.fCharCount = newSize;
            this.fChars = newBuffer;
        }

        public String getString() {
            return new String(this.fChars, 0, this.fCursor);
        }

        public void reset() {
            this.fCursor = 0;
        }

        @Override
        public void flush() {
        }
    }
}

