/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities.common;

import java.util.regex.Pattern;

public class ExcludeLists {
    private static volatile ExcludeLists instance = null;
    private Pattern[] urlExcludeList;
    private Pattern[] urlIncludeList;

    public static ExcludeLists getInstance() {
        if (instance == null) {
            instance = new ExcludeLists();
        }
        return instance;
    }

    private ExcludeLists() {
    }

    public void setUrlExcludeList(Pattern[] excludeList) {
        this.urlExcludeList = excludeList;
    }

    public void setUrlIncludeList(Pattern[] includeList) {
        this.urlIncludeList = includeList;
    }

    public boolean inURLExcludeList(String url) {
        return this.inPatternList(this.urlExcludeList, url, false);
    }

    public boolean inURLIncludeList(String url) {
        return this.inPatternList(this.urlIncludeList, url, true);
    }

    public boolean inExcludeLists(String url) {
        return !this.inURLIncludeList(url) || this.inURLExcludeList(url);
    }

    private boolean inPatternList(Pattern[] aPatterns, String url, boolean nullMeaning) {
        if (aPatterns == null || aPatterns.length == 0) {
            return nullMeaning;
        }
        int i = 0;
        while (i < aPatterns.length) {
            if (aPatterns[i].matcher(url).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

