/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.domain.DomainNameConverter;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentName;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricPrefix;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Metric
implements Externalizable {
    public static final Metric[] kEmptyMetricArray = new Metric[0];
    private static final long serialVersionUID = -7691216710730970033L;
    private AgentName fProcess;
    private AgentMetric fMetric;

    public static Metric getMetric(AgentName process, AgentMetric attribute) {
        Metric temp = new Metric(process, attribute);
        return temp;
    }

    public static Metric getMetric(MetricPrefix fullPath, String attributeName) {
        try {
            return Metric.getMetric(fullPath, attributeName, 15);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new IllegalArgumentException(attributeName);
        }
    }

    public static Metric getMetric(MetricPrefix fullPath, String attributeName, int typeCookie) throws BadlyFormedNameException {
        return Metric.getMetric(String.valueOf(fullPath.getFullPathURL()) + ":" + attributeName, typeCookie);
    }

    public static Metric getMetric(String fullAttributeString, int typeCookie) throws BadlyFormedNameException {
        Metric temp = new Metric(fullAttributeString, typeCookie);
        return temp;
    }

    public Metric(AgentName process, AgentMetric metric) {
        this.fProcess = process;
        this.fMetric = metric;
    }

    public Metric(String fullAttributeString, int typeCookie) throws BadlyFormedNameException {
        int index = AgentName.findIndexOfPivotSeparatorInFullPath(fullAttributeString, "|");
        if (index == -1 && (index = AgentName.findIndexOfPivotSeparatorInFullPath(fullAttributeString, ":")) == -1) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Name_Is_Badly_Formed", fullAttributeString, false);
            throw new BadlyFormedNameException("Invalid metric name: \"" + fullAttributeString + "\"", (ILocalizableMessage)message);
        }
        String firstPart = fullAttributeString.substring(0, index);
        String secondPart = fullAttributeString.substring(index + 1);
        this.fProcess = AgentName.getAgentName(firstPart);
        this.fMetric = AgentMetric.getAgentMetric(secondPart, typeCookie);
    }

    public Metric() {
    }

    public AgentName getAgentName() {
        return this.fProcess;
    }

    public AgentMetric getAgentMetric() {
        return this.fMetric;
    }

    public String getMetricUrl() {
        String processURL = this.fProcess.getProcessURL();
        String suffixingAttributeURL = this.fMetric.getSuffixingAttributeURL();
        StringBuffer sb = new StringBuffer(processURL.length() + suffixingAttributeURL.length());
        sb.append(processURL);
        sb.append(suffixingAttributeURL);
        return sb.toString();
    }

    public String getMetricUrlWithoutDomain() {
        String processURL = this.getAgentName().getProcessURLWithoutDomain();
        String suffixPlusAttribute = this.getAgentMetric().getSuffixingAttributeURL();
        StringBuffer sb = new StringBuffer(processURL.length() + suffixPlusAttribute.length());
        sb.append(processURL);
        sb.append(suffixPlusAttribute);
        return sb.toString();
    }

    public String getMetricUrlWithSimpleDomain(IStringLocalizer localizer) {
        if (this.isBusinessApplicationMetric(localizer)) {
            return this.getMetricUrlWithMetricPrefix();
        }
        String fullDomain = this.getAgentName().getDomain();
        String simpleDomain = DomainNameConverter.convertName(fullDomain);
        String processURL = this.getAgentName().getProcessURLWithoutDomain();
        String suffixPlusAttribute = this.getAgentMetric().getSuffixingAttributeURL();
        StringBuffer sb = new StringBuffer(simpleDomain.length() + 1 + processURL.length() + suffixPlusAttribute.length());
        sb.append(simpleDomain);
        sb.append('|');
        sb.append(processURL);
        sb.append(suffixPlusAttribute);
        return sb.toString();
    }

    public String getMetricUrlWithMetricPrefix() {
        String suffixPlusAttribute = this.getAgentMetric().getAttributeURL();
        StringBuffer sb = new StringBuffer(suffixPlusAttribute.length());
        sb.append(suffixPlusAttribute);
        return sb.toString();
    }

    public String getName() {
        return this.getAgentMetric().getAttributeName();
    }

    public int getAttributeType() {
        return this.getAgentMetric().getAttributeType();
    }

    public MetricPrefix getMetricPrefix() {
        return MetricPrefix.getMetricPrefix(this.fProcess, this.fMetric.getAgentMetricPrefix());
    }

    public String toString() {
        return this.getMetricUrl();
    }

    public boolean equals(Object pCompareTo) {
        if (this == pCompareTo) {
            return true;
        }
        if (pCompareTo == null) {
            return false;
        }
        Assertion.wilyAssert(pCompareTo instanceof Metric);
        Metric compareTo = (Metric)pCompareTo;
        return this.fProcess == compareTo.fProcess && this.fMetric == compareTo.fMetric;
    }

    public int hashCode() {
        return this.fProcess.hashCode() ^ this.fMetric.hashCode();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fProcess);
        out.writeObject(this.fMetric);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fProcess = (AgentName)in.readObject();
        this.fMetric = (AgentMetric)in.readObject();
    }

    public long getMetricID() {
        int agentNameID = this.fProcess.getPersistentID();
        int agentMetricID = this.fMetric.getPersistentID();
        if (agentNameID == -1 || agentMetricID == -1) {
            return -1L;
        }
        return (long)agentNameID << 32 | (long)agentMetricID;
    }

    public boolean isBusinessApplicationMetric(IStringLocalizer localizer) {
        String businessApplicationAgentName = localizer.IStringLocalizer_getLocalizedString("Business_Application_Metric_Virtual_Agent_Name");
        return this.getAgentName().getAgentName().startsWith(businessApplicationAgentName);
    }

    public boolean isCustomerExperienceMetric() {
        return this.getAgentMetric().getAgentMetricPrefix().getPathURL().indexOf("kmuerxnjasdfgdfhjwerhgiusadfoiuoherg") > 0;
    }
}

