/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WASFormatter
extends ANameFormatter {
    public WASFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String nameSpace = null;
        try {
            Object context = data.getInvocationParameterAsObject(0);
            Object operation = WSMUtils.invokeMethodOnObject(context, "getOperation");
            Object elementQName = WSMUtils.invokeMethodOnObject(operation, "getElementQName");
            nameSpace = (String)WSMUtils.invokeMethodOnObject(elementQName, "getNamespaceURI");
            if (nameSpace == null || nameSpace.equals("")) {
                Class<?> cl = context.getClass();
                Method m = WSMUtils.findGetPropertyWithStringArgMethod(cl);
                nameSpace = (String)m.invoke(context, (Object[])new String[]{"javax.xml.rpc.service.endpoint.address"});
                int end = nameSpace.indexOf("/", nameSpace.indexOf("//") + 2);
                nameSpace = nameSpace.substring(0, end);
            }
            nameSpace = WSMUtils.formatURLToBeResourceSafe(nameSpace);
        }
        catch (Throwable bomb) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", bomb);
        }
        return nameSpace == null || nameSpace.equals("") ? "UnknownNamespace" : nameSpace;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String name = null;
        try {
            Object context = data.getInvocationParameterAsObject(0);
            Object operation = WSMUtils.invokeMethodOnObject(context, "getOperation");
            name = (String)WSMUtils.invokeMethodOnObject(operation, "getName");
            if (name == null) {
                name = this.getNameFromQName(operation);
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", bomb);
        }
        return name == null || name.equals("") ? "UnknownOperationName" : name;
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object wlcontext = data.getInvocationParameterAsObject(0);
            Class<?> cl = wlcontext.getClass();
            Method m = WSMUtils.findGetPropertyWithStringArgMethod(cl);
            Object value = m.invoke(wlcontext, (Object[])new String[]{"javax.xml.rpc.service.endpoint.address"});
            name = WSMUtils.toString(value);
            name = WSMUtils.formatURLToBeResourceSafe(name);
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null || name.trim().equals("") ? "UnknownService" : name;
    }

    private String getNameFromQName(Object operation) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object elementQName = WSMUtils.invokeMethodOnObject(operation, "getElementQName");
        Object localPart = WSMUtils.invokeMethodOnObject(elementQName, "getLocalPart");
        return WSMUtils.toString(localPart);
    }
}

