/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.launch.AgentClassLoader;
import com.ca.apm.introscope.launch.AgentUpdateInfo;
import com.ca.apm.introscope.upgrade.FileUtils;
import com.ca.apm.introscope.upgrade.KLauncherConstants;
import com.ca.apm.introscope.upgrade.LaunchProperties;
import com.ca.apm.introscope.upgrade.UpgradeStatusLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public abstract class ALauncherAlgorithm {
    private String fAgentArgs;
    private Instrumentation fInstrumentation;
    private File fLaunchPropertyFile;
    private Logger fLogger;
    private LaunchProperties fLaunchProperties = new LaunchProperties();
    private String fAgentJarName;
    private String fAgentName;
    private int fOrder;
    private AgentUpdateInfo fUpdateInfo;
    private boolean fUpdateMarkerCreated;
    private String fNewCoreToBeDeleted;

    public ALauncherAlgorithm(String agentArgs, Instrumentation inst, File launchPropertyFile, Logger logger) throws FileNotFoundException, IOException {
        this.fAgentArgs = agentArgs;
        this.fInstrumentation = inst;
        this.fLaunchPropertyFile = launchPropertyFile;
        this.fLogger = logger;
        this.fLaunchProperties.load(new FileInputStream(this.fLaunchPropertyFile));
        if (!this.retrieveAgentJarFromManifest()) {
            this.fLogger.severe("Cannot start agent due to problem encountered during retrieval of Agent jar information.");
            throw new IOException("Problem retrieving Agent jar from Launcher Manifest.");
        }
        this.configureAgentUpdateInfo();
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ALauncherAlgorithm.this.fLogger.finest("Shutting down launcher.");
                ALauncherAlgorithm.this.onShutdown();
            }
        });
        boolean updateEnabled = Boolean.parseBoolean(this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.update.enabled", "true"));
        boolean start = false;
        start = updateEnabled ? this.onStart() : true;
        if (start) {
            if (!this.safeLaunchAgent()) {
                this.fLogger.severe("Failed to start Agent. Irreparable exception in configuration. " + new Date());
            } else {
                this.fLogger.info("Agent started successfully at " + new Date());
            }
        } else {
            this.fLogger.info("It's not this Launcher turn to start. " + new Date());
        }
        this.fUpdateInfo.cleanup();
    }

    protected abstract boolean onStart();

    protected void onShutdown() {
        if (this.fUpdateMarkerCreated) {
            File newCoreFile;
            if (this.fNewCoreToBeDeleted != null && (newCoreFile = new File(this.fNewCoreToBeDeleted)).exists() && newCoreFile.isDirectory()) {
                FileUtils.deleteDirectory(newCoreFile);
            }
            this.deleteUpdateMarker();
        }
        this.fUpdateInfo.cleanup();
    }

    public File getLaunchPropertyFile() {
        return this.fLaunchPropertyFile;
    }

    public LaunchProperties getLaunchProperties() {
        return this.fLaunchProperties;
    }

    public String getProperty(String key, String defaultValue) {
        return this.fLaunchProperties.getProperty(key, defaultValue);
    }

    public AgentUpdateInfo getUpdateInfo() {
        return this.fUpdateInfo;
    }

    public String getAgentJarName() {
        return this.fAgentJarName;
    }

    public String getAgentName() {
        return this.fAgentName;
    }

    public int getOrder() {
        return this.fOrder;
    }

    public Logger getLogger() {
        return this.fLogger;
    }

    public void log(Level level, String msg) {
        this.fLogger.log(level, msg);
    }

    private boolean updateStatus(UpgradeStatusLogger statusLogger, boolean status, boolean rollback) {
        File logDir;
        boolean success = true;
        if (rollback) {
            String newCore = this.fUpdateInfo.getNewCoreDirectory();
            if (this.fUpdateInfo.onUnsuccessfulValidation()) {
                this.fNewCoreToBeDeleted = newCore;
            }
        } else {
            this.fUpdateInfo.cleanup();
        }
        if (statusLogger != null) {
            try {
                statusLogger.save(status, this.fUpdateInfo.getUpgradeStatusLog());
            }
            catch (IOException iOException) {
                this.fLogger.warning("Failed to save update status log.");
            }
        }
        if ((logDir = new File(this.fUpdateInfo.getLogDirectory())).exists() && logDir.isDirectory()) {
            File[] files;
            File[] fileArray = files = logDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    boolean accept = false;
                    if (KLauncherConstants.sAutoProbeLogPattern.matcher(pathname.getName()).matches()) {
                        accept = pathname.length() == 0L;
                    }
                    return accept;
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.delete()) {
                    this.fLogger.warning("Failed to delete AutoProbe log: " + file);
                }
                ++n2;
            }
        }
        this.deleteUpdateMarker();
        return success;
    }

    protected UpdateStatusType update(boolean createMarker) {
        UpdateStatusType success = UpdateStatusType.FAILED_DONT_START;
        Date startTime = new Date();
        this.fLogger.info("Starting agent update at " + startTime);
        if (createMarker && !this.createUpdateMarker()) {
            success = UpdateStatusType.FAILED_BUT_CAN_START;
            return success;
        }
        UpgradeStatusLogger statusLogger = null;
        if (!this.fUpdateInfo.moveAndValidateInstallableUnit()) {
            this.fLogger.warning("Failed to move validate and installable unit.");
            try {
                statusLogger = new UpgradeStatusLogger(this.fUpdateInfo.getBackupUpgradeStatusLog());
                statusLogger.log(this.fUpdateInfo.getFormattedMetadata());
            }
            catch (Exception exception) {
                this.fLogger.warning("Failed to create upgrade status log.");
            }
            if (this.updateStatus(statusLogger, false, false)) {
                success = UpdateStatusType.FAILED_BUT_CAN_START;
            }
            this.deleteUpdateMarker();
            return success;
        }
        try {
            statusLogger = new UpgradeStatusLogger(this.fUpdateInfo.getBackupUpgradeStatusLog());
            statusLogger.log(this.fUpdateInfo.getFormattedMetadata());
        }
        catch (Exception exception) {
            this.fLogger.warning("Failed to create upgrade status log.");
        }
        if (!this.fUpdateInfo.backupCurrent()) {
            this.fLogger.warning("Failed to backup current agent enviroment.");
            if (this.updateStatus(statusLogger, false, false)) {
                success = UpdateStatusType.FAILED_BUT_CAN_START;
            }
            return success;
        }
        if (!this.fUpdateInfo.createNewCore()) {
            this.fLogger.warning("Failed while creating new core directory.");
            if (this.updateStatus(statusLogger, false, true)) {
                success = UpdateStatusType.FAILED_BUT_CAN_START;
            }
            return success;
        }
        this.updateAgentProfilePath(this.fUpdateInfo.getNewConfigDirectory());
        if (!this.validateAgentUpdate()) {
            this.fLogger.warning("New agent environment failed validation.");
            this.updateAgentProfilePath(this.fUpdateInfo.getConfigDirectory());
            success = this.updateStatus(statusLogger, false, true) ? UpdateStatusType.FAILED_BUT_CAN_START : UpdateStatusType.FAILED_DONT_START;
            return success;
        }
        if (!this.fUpdateInfo.onSuccessfulValidation()) {
            if (this.updateStatus(statusLogger, false, false)) {
                success = UpdateStatusType.FAILED_BUT_CAN_START;
            }
            return success;
        }
        if (!this.updateLaunchProperties(this.fUpdateInfo.getRelativeNewCoreDirectory())) {
            this.fLogger.warning("Failed to update launch.properties. Launching old agent.");
            this.updateAgentProfilePath(this.fUpdateInfo.getConfigDirectory());
            if (this.updateStatus(statusLogger, false, true)) {
                success = UpdateStatusType.FAILED_BUT_CAN_START;
            }
            return success;
        }
        this.fUpdateInfo.setCurrentCoreDirectory(this.fUpdateInfo.getNewCoreDirectory());
        if (this.updateStatus(statusLogger, true, false)) {
            success = UpdateStatusType.SUCCESSFUL;
        }
        Date endTime = new Date();
        this.fLogger.info("Agent update successfully completed at " + endTime + ".");
        this.fLogger.info("Time taken to complete the upgrade " + (endTime.getTime() - startTime.getTime()) + " milliseconds.");
        return success;
    }

    private void updateAgentProfilePath(String config) {
        String profileLocation = System.getProperty("com.wily.introscope.agentProfile");
        File file = new File(profileLocation);
        if (!file.isDirectory()) {
            String profile = file.getName();
            String newProfileLocation = String.valueOf(config) + File.separator + profile;
            System.setProperty("com.wily.introscope.agentProfile", newProfileLocation);
        }
    }

    private boolean updateLaunchProperties(String newCore) {
        boolean success = false;
        String oldCore = this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.core");
        this.fLaunchProperties.put("com.ca.apm.introscope.launch.agent.core", newCore);
        try {
            String filename = this.fLaunchPropertyFile.getCanonicalPath();
            this.fLaunchProperties.store(new FileOutputStream(filename));
            success = true;
        }
        catch (IOException e) {
            this.fLogger.fine("Failed to upgrade launch properties. " + e.getMessage());
            this.fLaunchProperties.put("com.ca.apm.introscope.launch.agent.core", oldCore);
        }
        return success;
    }

    private void configureAgentUpdateInfo() throws IOException {
        this.fLogger.finest("Starting agent update info configuration.");
        String currentPath = this.fLaunchPropertyFile.getParentFile().getCanonicalPath();
        String logPath = this.getFilePath(currentPath, this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.log", "logs"));
        String corePath = this.getFilePath(currentPath, this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.core", "core"));
        String updatePath = this.getFilePath(currentPath, this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.update", "update"));
        String backupPath = this.getFilePath(currentPath, this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.backup", "backup"));
        String statusLog = this.getFilePath(currentPath, this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.logfile", KLauncherConstants.kDefaultUpgradeStatusLogPath));
        boolean profileMerge = Boolean.parseBoolean(this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.merge.profile.enabled", "true"));
        boolean pblMerge = Boolean.parseBoolean(this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.merge.pbl.enabled", "true"));
        boolean pbdMerge = Boolean.parseBoolean(this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.merge.pbd.enabled", "true"));
        this.fUpdateInfo = new AgentUpdateInfo(currentPath, logPath, corePath, updatePath, backupPath, statusLog, this.fAgentJarName, this.fAgentName, this.fOrder, profileMerge, pblMerge, pbdMerge);
        this.fLogger.finest("Ending agent update info configuration.");
    }

    private String getFilePath(String relativeDir, String filePath) throws IOException {
        String canonicalPath = filePath;
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            file = new File(relativeDir, filePath);
            canonicalPath = file.getCanonicalPath();
        }
        return canonicalPath;
    }

    private boolean validateAgentUpdate() {
        boolean success;
        block10: {
            this.fLogger.finest("Starting validation of agent.");
            success = false;
            URLClassLoader agentClassLoader = null;
            try {
                try {
                    agentClassLoader = this.fUpdateInfo.getClassLoader();
                    String premainClassName = this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.premainClass", "com.wily.introscope.api.instrument.JavaAgent");
                    Class<?> premainClass = agentClassLoader.loadClass(premainClassName);
                    Class[] argType = new Class[]{String.class, Instrumentation.class, String.class, String.class, String.class, String.class};
                    this.fLogger.finest(String.valueOf(premainClass.getCanonicalName()) + " loaded by " + premainClass.getClassLoader());
                    Method m = premainClass.getMethod("validate", argType);
                    Object retObj = m.invoke(null, this.fAgentArgs, this.fInstrumentation, this.fUpdateInfo.getStagingConfigDirectory(), this.fUpdateInfo.getNewConfigDirectory(), this.fUpdateInfo.getMergeRulesFile(), this.fUpdateInfo.getBackupUpgradeStatusLog());
                    if (retObj instanceof Boolean) {
                        success = (Boolean)retObj;
                    }
                }
                catch (ThreadDeath td) {
                    this.fLogger.finest("Validation of agent failed because " + td.getMessage());
                    throw td;
                }
                catch (Throwable t) {
                    this.fLogger.finest("Validation of agent failed because " + t.getMessage());
                    if (agentClassLoader != null && agentClassLoader instanceof AgentClassLoader) {
                        ((AgentClassLoader)agentClassLoader).close();
                        agentClassLoader = null;
                    }
                    agentClassLoader = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (agentClassLoader != null && agentClassLoader instanceof AgentClassLoader) {
                    ((AgentClassLoader)agentClassLoader).close();
                    agentClassLoader = null;
                }
                agentClassLoader = null;
                throw throwable;
            }
            if (agentClassLoader != null && agentClassLoader instanceof AgentClassLoader) {
                ((AgentClassLoader)agentClassLoader).close();
                agentClassLoader = null;
            }
            agentClassLoader = null;
        }
        this.fLogger.finest("Ending validation of agent. Validation status: " + success);
        return success;
    }

    private boolean safeLaunchAgent() {
        this.fLogger.finest("Starting agent launch.");
        boolean success = false;
        try {
            this.updateAgentProfilePath(this.fUpdateInfo.getCurrentConfigDirectory());
            String premainClassName = this.fLaunchProperties.getProperty("com.ca.apm.introscope.launch.agent.premainClass", "com.wily.introscope.api.instrument.JavaAgent");
            Class<?> premainClass = Class.forName(premainClassName);
            Class[] argType = new Class[]{String.class, Instrumentation.class};
            Method m = premainClass.getMethod("premain", argType);
            m.invoke(null, this.fAgentArgs, this.fInstrumentation);
            success = true;
            System.setProperty("com.ca.apm.introscope.launch.agent.started", "true");
            this.fLogger.info("Agent launched successfully from " + this.fUpdateInfo.getCurrentCoreDirectory());
        }
        catch (ThreadDeath td) {
            this.fLogger.severe("Failed to launch agent due to " + td.getMessage());
        }
        catch (Throwable t) {
            this.fLogger.severe("Failed to launch agent due to " + t.getMessage());
            t.printStackTrace();
        }
        this.fLogger.finest("Ending agent launch.");
        return success;
    }

    private boolean retrieveAgentJarFromManifest() throws MalformedURLException, IOException {
        String[] values;
        boolean success = false;
        String fileName = this.getManifestUrl();
        if (fileName == null) {
            return success;
        }
        Manifest manifest = new Manifest(new URL(fileName).openStream());
        Attributes attribs = manifest.getMainAttributes();
        String attribute = attribs.getValue("Boot-Class-Path");
        this.fLogger.finest("Boot class path: " + attribute);
        String[] stringArray = values = attribute.split("\\s+");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            Matcher matcher = KLauncherConstants.sPattern.matcher(value.trim());
            if (matcher.matches() && matcher.groupCount() == 3) {
                this.fAgentJarName = matcher.group(0);
                this.fAgentName = matcher.group(1).toLowerCase();
                String order = matcher.group(2);
                if (order != null) {
                    try {
                        this.fOrder = Integer.parseInt(order);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                success = true;
                break;
            }
            ++n2;
        }
        return success;
    }

    private String getManifestUrl() {
        int marker;
        String manifestUrlString = null;
        Class<ALauncherAlgorithm> clazz = ALauncherAlgorithm.class;
        String classFileName = "/" + clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(classFileName);
        String urlString = url.toString();
        if (urlString.startsWith("jar:") && (marker = urlString.indexOf(33)) != -1) {
            manifestUrlString = String.valueOf(urlString.substring(0, marker + 1)) + "/META-INF/MANIFEST.MF";
        }
        return manifestUrlString;
    }

    protected boolean waitForOngoingUpdate() {
        boolean start = true;
        boolean exists = false;
        File file = new File(String.valueOf(this.fUpdateInfo.getAgentDirectory()) + File.separator + "au.lock");
        while (file.exists()) {
            exists = true;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (exists) {
            try {
                this.fUpdateInfo.cleanup();
                this.fLaunchProperties.clear();
                this.fLaunchProperties.load(new FileInputStream(this.fLaunchPropertyFile));
                this.configureAgentUpdateInfo();
            }
            catch (Exception e) {
                start = false;
                this.fLogger.severe("Failed to read launch properties after a new update by another launcher! " + e.getMessage());
            }
        }
        return start;
    }

    private boolean createUpdateMarker() {
        boolean success = false;
        File file = new File(String.valueOf(this.fUpdateInfo.getAgentDirectory()) + File.separator + "au.lock");
        if (!file.exists()) {
            try {
                if (file.createNewFile()) {
                    success = true;
                    this.fUpdateMarkerCreated = true;
                }
            }
            catch (IOException iOException) {
                this.fLogger.warning("Failed to create update marker.");
            }
        }
        return success;
    }

    private boolean deleteUpdateMarker() {
        boolean success = false;
        File file = new File(String.valueOf(this.fUpdateInfo.getAgentDirectory()) + File.separator + "au.lock");
        if (this.fUpdateMarkerCreated && file.exists() && file.delete()) {
            success = true;
            this.fUpdateMarkerCreated = false;
        }
        return success;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateStatusType {
        SUCCESSFUL,
        FAILED_BUT_CAN_START,
        FAILED_DONT_START;

    }
}

