try {
    /**
     * CA Wily Introscope(R) Version 10.3.0.15 Build 990015
     * Copyright (c) 2016 CA. All Rights Reserved.
     * Introscope(R) is a registered trademark of CA.
     */
    var BrowserAgentExtension = {
        
        /**
         * ADD YOUR OWN CODE HERE
         */

        init : function () {
            /** DO NOT EDIT **/
            BrowserAgentUtils.metricUtils.addMetricType("misc",
                                                        BrowserAgentExtension.extAddCustomMiscMetric);
            BrowserAgentExtension.extCollectMiscMetrics();

            /** DO NOT EDIT **/
        },
        extJSFuncMap : {
            /** Add JS Functions here to Instrument
             * Format - "key" : { name : "Name of Function" }
             * Note: If the JS Function to be instrumented is a member function inside a JS object,
             *       you may need to add the keyword prototype
             */

            /**
             * Example 1 - "Math_Random" : { name : "Math.random" }
             *
             */

            /**
             * Example 2 - "XHR_SRH" : { name : "XMLHttpRequest.prototype.setRequestHeader" }
             *
             */

        },
        extAddJSFuncToInstrument : function () {

            /** DO NOT EDIT **/
            for ( var fn in BrowserAgentExtension.extJSFuncMap ) {
                BrowserAgentUtils.funcUtils.addFuncToGlobalsInstrumentMap(fn,
                                                                          BrowserAgentExtension.extJSFuncMap[fn]);
            }

            /** DO NOT EDIT **/
        },
        extCustomPageMetricMap : {},
        extAddCustomPageMetric : function () {
            /** Step 1
             *  Do your work to collect metrics
             *
             */

            /** Step 2
             *  Populate extCustomPageMetricMap with metrics
             *  Note: Keys in extCustomPageMetricMap are metric names
             *        Values are arrays with 2 values : [metric value, metric Aggregator Type]
             *        metric Aggregator Types are
             *        0 : INT_LONG_DURATION,
             *        1 : LONG_INTERVAL_COUNTER
             *
             *        INT_LONG_DURATION : These metrics are aggregated over time by taking
             *        the average of the values per interval
             *
             *        LONG_INTERVAL_COUNTER : These metrics are aggregated over time by
             *        summing the values per interval.
             */

            /**
             * Example 1 - Calculate Average DOM Depth
             *           Step 1: Do your work to collect metrics
             *
             *                   function getRandomNumberOneToFive() { return Math.floor(Math.random() * (5 - 1)) + 1; }
             *                   var avgDOMDepth = getRandomNumberOneToFive();
             *
             *           Step 2: Populate extCustomPageMetricMap with metrics
             *
             *                   this.extCustomPageMetricMap["Average DOM Depth"] = [avgDOMDepth, 0];
             */

            /**
             * Example 2 - Calculate Average JS Heap Usage in bytes
             *           Step 1: Do your work to collect metrics
             *
             *                   function getAverageHeapSize() { return window.performance.memory.usedJSHeapSize; }
             *                   var avgJSHeapUsage = getAverageHeapSize();
             *
             *           Step 2: Populate extCustomPageMetricMap with metrics
             *
             *                   this.extCustomPageMetricMap["Average Heap Usage (bytes)"] = [avgJSHeapUsage, 0];
             */

        },
        extCustomJSFuncMetricMap : {},
        extAddCustomJSFuncMetric : function () {
            /** Step 1
             *  Do your work to collect metrics
             *
             */

            /** Step 2
             *  Populate extCustomJSFuncMetricMap with metrics
             *  Note: Keys in extCustomJSFuncMetricMap are metric names
             *        Values are arrays with 2 values : [metric value, metric Aggregator Type]
             *        metric Aggregator Types are
             *        0 : INT_LONG_DURATION,
             *        1 : LONG_INTERVAL_COUNTER
             *
             *        INT_LONG_DURATION : These metrics are aggregated over time by taking
             *        the average of the values per interval
             *
             *        LONG_INTERVAL_COUNTER : These metrics are aggregated over time by
             *        summing the values per interval.
             *
             */

            /**
             * Example - Calculate Argument Length
             *           Step 1: Do your work to collect metrics
             *
             *                   function getRandomNumberOneToFive() { return Math.floor(Math.random() * (5 - 1)) + 1; };
             *                   var argLength = getRandomNumberOneToFive();
             *
             *           Step 2: Populate extCustomJSFuncMetricMap with metrics
             *
             *                   this.extCustomJSFuncMetricMap["Average Argument Length"] = [argLength, 0];
             */

        },
        extCustomAjaxMetricMap : {},
        extAddCustomAjaxMetric : function () {
            /** Step 1
             *  Do your work to collect metrics
             *
             */

            /** Step 2
             *  Populate extCustomAjaxMetricMap with metrics
             *  Note: Keys in extCustomAjaxMetricMap are metric names
             *        Values are arrays with 2 values : [metric value, metric Aggregator Type]
             *        metric Aggregator Types are
             *        0 : INT_LONG_DURATION,
             *        1 : LONG_INTERVAL_COUNTER
             *
             *        INT_LONG_DURATION : These metrics are aggregated over time by taking
             *        the average of the values per interval
             *
             *        LONG_INTERVAL_COUNTER : These metrics are aggregated over time by
             *        summing the values per interval.
             *
             */

            /**
             * Example - Capture and Report Content Length in Bytes
             *           Step 1: Do your work to collect metrics
             *
             *                   function getRandomNumber1Kto4K() { return Math.floor(Math.random() * (4096 - 1024)) + 1024; };
             *                   var contentLength = getRandomNumber1Kto4K();
             *
             *           Step 2: Populate extAddCustomAjaxMetric with metrics
             *
             *                   this.extCustomAjaxMetricMap["Average Content Length (bytes)"] = [contentLength, 0];
             */
        },
        extCustomMiscMetricMap : {},
        extCollectMiscMetrics : function () {
            /** Step 1
             *  Do your work to collect metrics
             *  a) Save the metrics in BrowserAgentGlobals.metricTypeToAccumulatorMap[BrowserAgentGlobals.metricType.MISC];
             *  b) Invoke BrowserAgentUtils.metricUtils.harvestMetrics(BrowserAgentGlobals.metricType.MISC); to trigger the
             *     harvest function to do calculations and dispatch of your custom metrics
             */

            /**
             * Example - Capture and Report Button Click Count
             *           Step 1: Do your work to collect metrics
             *
             *                   var el = document.getElementById("myButton");
             *                   var key = "myButton Click Count Per Interval";
             *                   el.addEventListener('click', function () {
             *                      // This is step 1(a) - Save metrics
             *                      BrowserAgentUtils.metricUtils.addDataPoint(BrowserAgentGlobals.metricTypeToAccumulatorMap[BrowserAgentGlobals.metricType.MISC], key, 1);
             *                      // This is step 1(b) - Harvest the metrics
             *                      BrowserAgentUtils.metricUtils.harvestMetrics(BrowserAgentGlobals.metricType.MISC);
             *                   });
             *           Steps 2 - 4 of this example are in extAddCustomMiscMetric
             */

        },
        extAddCustomMiscMetric : function () {
            /** Step 2
             *  Populate extCustomMiscMetricMap with metrics
             *  Note: Keys in extCustomMiscMetricMap are metric names
             *        Values are arrays with 2 values : [metric value, metric Aggregator Type]
             *        metric Aggregator Types are
             *        0 : INT_LONG_DURATION,
             *        1 : LONG_INTERVAL_COUNTER
             *
             *        INT_LONG_DURATION : These metrics are aggregated over time by taking
             *        the average of the values per interval
             *
             *        LONG_INTERVAL_COUNTER : These metrics are aggregated over time by
             *        summing the values per interval.
             */

            /**
             * Step 3
             * Delete Data Points in BrowserAgentGlobals.metricTypeToAccumulatorMap[BrowserAgentGlobals.metricType.MISC]
             * Note: If not deleted, then metrics will be duplicated
             */

            /** Step 4 (OPTIONAL)
             *  Validate the Metrics created above (e.g. Check for negative values)
             *
             */

            /**
             *   Example (Continued Steps 2 - 4) - Capture and Report Button Click Count
             *           Step 2 and 3: Populate extCustomMiscMetricMap with metrics and
             *                         Delete Data Points in BrowserAgentGlobals.metricTypeToAccumulatorMap[BrowserAgentGlobals.metricType.MISC]
             *
             *                          for ( var key in BrowserAgentGlobals.metricTypeToAccumulatorMap[BrowserAgentGlobals.metricType.MISC] ) {
             *                                  BrowserAgentExtension.extCustomMiscMetricMap[key] =
             *                                      [BrowserAgentGlobals.metricTypeToAccumulatorMap[BrowserAgentGlobals.metricType.MISC][key].length, 1];
             *                                  delete BrowserAgentGlobals.metricTypeToAccumulatorMap[BrowserAgentGlobals.metricType.MISC][key];
             *                          }
             *          Step 4 is skipped
             */

            /** DO NOT EDIT **/
            var extCustomMiscMetricData = "";
            var extCustomMiscMetricPfx = "MISC";
            var urlPath = BrowserAgentGlobals.UNDEFINED;

            if ( BrowserAgentGlobals.bs === BrowserAgentGlobals.UNDEFINED ) {
                extCustomMiscMetricPfx =
                    BrowserAgentUtils.metricUtils.convertURL(BrowserAgentUtils.metricUtils.sanitizeURL(BrowserAgentGlobals.currentURL));
                urlPath = extCustomMiscMetricPfx;
                extCustomMiscMetricPfx += BrowserAgentGlobals.pipeChar + "MISC";
            }
            for ( var metric in BrowserAgentExtension.extCustomMiscMetricMap ) {
                extCustomMiscMetricData += BrowserAgentUtils.metricUtils.constructMetricPath(extCustomMiscMetricPfx,
                                                                                             metric,
                                                                                             BrowserAgentExtension.extCustomMiscMetricMap[metric][0],
                                                                                             BrowserAgentExtension.extCustomMiscMetricMap[metric][1]);
            }

            BrowserAgentExtension.extCustomMiscMetricMap = {};

            if ( extCustomMiscMetricData.length > 0 ) {
                // Form the data in Post Parameter Data Format
                // b0: <optional Params>$bs=-1,bt=-1,btc=-1;Responses Per Interval=(2,1);
                extCustomMiscMetricData =
                    BrowserAgentUtils.metricUtils.placeInPostParameterFormat(BrowserAgentGlobals.bs,
                                                                             BrowserAgentGlobals.bt,
                                                                             BrowserAgentGlobals.btc,
                                                                             urlPath,
                                                                             "",
                                                                             extCustomMiscMetricData);
                BrowserAgentGlobals.bCount++;
            }
            return extCustomMiscMetricData;
            /** DO NOT EDIT **/
        },
        extAddCustomOptionalProperty : function () {
            /** DO NOT EDIT **/
            var extCustomOptionalProperty = "";

            /** DO NOT EDIT **/

            /** Add Txn Trace Properties here
             * Format - "propertyName1=value2; propertyName2=value2"
             *
             */

            /**
             * Example - Add Previous Page URL to transaction trace components
             *           Step 1: Do your work to collect metrics
             *
             *                   function getPreviousPage() {
             *                       var referrer = document.referrer;
             *                       if ( !referrer ) {
             *                          referrer = "N/A";
             *                       }
             *                       return referrer;
             *                   };
             *                   var prevPageURL = getPreviousPage();
             *
             *           Step 2: Concatenate to extCustomOptionalProperty variable (prepend with semi-colon)
             *
             *                   extCustomOptionalProperty += ";Previous Page=" + prevPageURL;
             */

            /** DO NOT EDIT **/
            return extCustomOptionalProperty;

            /** DO NOT EDIT **/
        },
        extNameFormatter : function ( unformattedMetricPath ) {
            /** DO NOT EDIT **/
            var formattedMetricPath = unformattedMetricPath;

            /** DO NOT EDIT **/

            /**
             *  Step 1
             *  Do your work to format the input metric path
             */

            /**
             *  Step 2
             *  Replace the formatted metric path as a string to "formattedMetricPath" variable
             *
             */

            /**
             *  Example - Let "unformattedMetricPath" comprises of metric paths such as the following:
             *            localhost/5080|/worldpop|AJAX Call|localhost/5080|/country_1/country.json:Invocation Count Per
             *            Interval=(1,1);
             *            localhost/5080|/worldpop|AJAX Call|localhost/5080|/country_2/country.json:Invocation Count Per
             *            Interval=(1,1);
             *            localhost/5080|/worldpop|AJAX Call|localhost/5080|/country_3/country.json:Invocation Count Per
             *            Interval=(1,1);
             *
             *            Let's combine all of the "localhost/5080|/worldpop|AJAX Call|localhost/5080|/country_#/country.json"
             *            into "localhost/5080|/worldpop|AJAX Call|localhost/5080|/country.json" and let's
             *            change the "Invocation Count Per Interval" to "Country Visit Count"
             *
             *            Step 1: Do your work to format the input metric path
             *
             *                    var myMetricPath = unformattedMetricPath.replace(/country_\d+\//g, "")
             *                                      .replace(/Invocation Count Per Interval/g,
             *                                               "Country Visit Count");
             *
             *            Step 2: Replace the formatted metric path as a string to "formattedMetricPath" variable
             *
             *                    formattedMetricPath = myMetricPath;
             */

            /** DO NOT EDIT **/
            return formattedMetricPath;

            /** DO NOT EDIT **/
        }

        /**
         * ADD YOUR OWN CODE HERE
         */

    };
} catch ( e ) {
    if ( BrowserAgentLogger ) {
        BrowserAgentLogger.log("BrowserAgentExtensionError: " + e.message);
    } else if ( window && window.console ) {
        window.console.log("BrowserAgentExtensionError: " + e.message)
    }
}
