/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.AddressHostNameHelper;
import com.wily.util.WilyStringBuilder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.net.InetSocketAddress;

public abstract class ASocketNameFormatter
implements INameFormatter {
    protected final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    protected final Module fModule = new Module("ASocketNameFormatter");
    public static final char[] kHostNamePlaceHolder = "{hostname}".toCharArray();
    public static final char[] kPortPlaceHolder = "{port}".toCharArray();
    protected static ThreadLocal<WilyStringBuilder> NameFormatterBuilder = new ThreadLocal<WilyStringBuilder>(){

        @Override
        protected WilyStringBuilder initialValue() {
            return new WilyStringBuilder();
        }
    };

    public ASocketNameFormatter(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
    }

    @Override
    public String INameFormatter_format(String name, InvocationData data) {
        String result = null;
        try {
            ResourceAndAddress socketInfo = this.getResourceAndAddress(data);
            if (name != null && socketInfo != null) {
                String resourceName = socketInfo.getResourceName();
                InetSocketAddress address = socketInfo.getAddress();
                WilyStringBuilder bldr = NameFormatterBuilder.get();
                bldr.setString(this.calculateMetricName(resourceName, name));
                int i = bldr.indexOf(kHostNamePlaceHolder);
                if (i >= 0) {
                    bldr = bldr.replace(i, i + kHostNamePlaceHolder.length, AddressHostNameHelper.getHostName(address));
                }
                if ((i = bldr.indexOf(kPortPlaceHolder)) >= 0) {
                    bldr = bldr.replace(i, i + kPortPlaceHolder.length, Integer.toString(address.getPort()));
                }
                result = bldr.toString();
            } else if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(this.fModule, "Name and/or SocketInfo null: name=" + name + ", socketInfo=" + socketInfo + ", invocation object=" + (data != null ? data.getInvocationObject().toString() : "null"));
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error(this.fModule, "An error occurred formatting socket name.");
                this.fFeedback.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    protected abstract ResourceAndAddress getResourceAndAddress(InvocationData var1);

    protected String calculateMetricName(String resourceName, String metricName) {
        return String.valueOf(resourceName) + ":" + metricName;
    }

    protected IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public IStringLocalizer getFLocalizer() {
        return this.fLocalizer;
    }

    protected static final class ResourceAndAddress {
        private final String resourceName;
        private final InetSocketAddress address;

        public ResourceAndAddress(String resourceName, InetSocketAddress address) {
            this.resourceName = resourceName;
            this.address = address;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final InetSocketAddress getAddress() {
            return this.address;
        }
    }
}

