/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.agent.ICompressedTimesliceData;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.util.io.IConstructorExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CompressingAgentMetricDataSet2
implements IConstructorExternalizable,
ICompressedTimesliceData {
    private static final long serialVersionUID = -5097803348005109597L;
    private final long fStartTime;
    private final long fEndTime;
    private final Frequency fFrequency;
    private final List fAbsent;
    private final List fIntegers;
    private final List fLongs;
    private final List fZeros;
    private final AgentMetricData[] fUncompressedBindings;

    public CompressingAgentMetricDataSet2(AgentMetricData[] bindings) {
        if (bindings.length > 0) {
            this.fStartTime = bindings[0].getDataValue().getStartTimestampInMillis();
            this.fEndTime = bindings[0].getDataValue().getStopTimestampInMillis();
            this.fFrequency = bindings[0].getFrequency();
        } else {
            this.fStartTime = 0L;
            this.fEndTime = 0L;
            this.fFrequency = null;
        }
        this.fIntegers = new ArrayList(bindings.length);
        this.fLongs = new ArrayList(bindings.length);
        this.fZeros = new ArrayList(bindings.length);
        ArrayList<AgentMetricData> uncompressed = new ArrayList<AgentMetricData>(bindings.length);
        this.fAbsent = new ArrayList(bindings.length);
        int iter = 0;
        while (iter < bindings.length) {
            IMetricDataValue value = bindings[iter].getDataValue();
            if (!bindings[iter].getFrequency().equals(this.fFrequency) || value.getStartTimestampInMillis() != this.fStartTime || value.getStopTimestampInMillis() != this.fEndTime) {
                uncompressed.add(bindings[iter]);
            } else if (value.dataIsAbsent()) {
                this.fAbsent.add(new AbsentTimeslice(bindings[iter].getAgentMetric(), value));
            } else if (value instanceof IntegerTimeslicedValue) {
                IntegerTimeslicedValue intValue = (IntegerTimeslicedValue)value;
                if (intValue.getDataPointCount() == 0L && intValue.getValue() == 0 && intValue.getMinimum() == 0 && intValue.getMaximum() == 0) {
                    this.fZeros.add(new ZeroTimeslice(bindings[iter].getAgentMetric(), intValue));
                } else {
                    this.fIntegers.add(new CompressedIntegerTimeslice(bindings[iter].getAgentMetric(), intValue));
                }
            } else if (value instanceof LongTimeslicedValue) {
                LongTimeslicedValue longValue = (LongTimeslicedValue)value;
                if (longValue.getDataPointCount() == 0L && longValue.getValue() == 0L && longValue.getMinimum() == 0L && longValue.getMaximum() == 0L) {
                    this.fZeros.add(new ZeroTimeslice(bindings[iter].getAgentMetric(), longValue));
                } else {
                    this.fLongs.add(new CompressedLongTimeslice(bindings[iter].getAgentMetric(), (LongTimeslicedValue)value));
                }
            } else {
                uncompressed.add(bindings[iter]);
            }
            ++iter;
        }
        this.fUncompressedBindings = uncompressed.toArray(new AgentMetricData[uncompressed.size()]);
    }

    public CompressingAgentMetricDataSet2(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fStartTime = in.readLong();
        this.fEndTime = in.readLong();
        this.fFrequency = (Frequency)in.readObject();
        int num = in.readInt();
        this.fAbsent = new ArrayList(num);
        int i = 0;
        while (i < num) {
            this.fAbsent.add(new AbsentTimeslice(in));
            ++i;
        }
        num = in.readInt();
        this.fZeros = new ArrayList(num);
        i = 0;
        while (i < num) {
            this.fZeros.add(new ZeroTimeslice(in));
            ++i;
        }
        num = in.readInt();
        this.fIntegers = new ArrayList(num);
        i = 0;
        while (i < num) {
            this.fIntegers.add(new CompressedIntegerTimeslice(in));
            ++i;
        }
        num = in.readInt();
        this.fLongs = new ArrayList(num);
        i = 0;
        while (i < num) {
            this.fLongs.add(new CompressedLongTimeslice(in));
            ++i;
        }
        this.fUncompressedBindings = (AgentMetricData[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.fStartTime);
        out.writeLong(this.fEndTime);
        out.writeObject(this.fFrequency);
        out.writeInt(this.fAbsent.size());
        Iterator i = this.fAbsent.iterator();
        while (i.hasNext()) {
            ((AbsentTimeslice)i.next()).writeExternal(out);
        }
        out.writeInt(this.fZeros.size());
        i = this.fZeros.iterator();
        while (i.hasNext()) {
            ((ZeroTimeslice)i.next()).writeExternal(out);
        }
        out.writeInt(this.fIntegers.size());
        i = this.fIntegers.iterator();
        while (i.hasNext()) {
            ((CompressedIntegerTimeslice)i.next()).writeExternal(out);
        }
        out.writeInt(this.fLongs.size());
        i = this.fLongs.iterator();
        while (i.hasNext()) {
            ((CompressedLongTimeslice)i.next()).writeExternal(out);
        }
        out.writeObject(this.fUncompressedBindings);
    }

    private List convertToMetricData(List data, long startTime, long endTime, Frequency frequency) {
        ArrayList<AgentMetricData> result = new ArrayList<AgentMetricData>(data.size());
        Iterator i = data.iterator();
        while (i.hasNext()) {
            result.add(((ICompressedMetric)i.next()).getAgentMetric(startTime, endTime, frequency));
        }
        return result;
    }

    public AgentMetricData[] toArray() {
        ArrayList<AgentMetricData> bindings = new ArrayList<AgentMetricData>(2048);
        bindings.addAll(this.convertToMetricData(this.fAbsent, this.fStartTime, this.fEndTime, this.fFrequency));
        bindings.addAll(this.convertToMetricData(this.fZeros, this.fStartTime, this.fEndTime, this.fFrequency));
        bindings.addAll(this.convertToMetricData(this.fIntegers, this.fStartTime, this.fEndTime, this.fFrequency));
        bindings.addAll(this.convertToMetricData(this.fLongs, this.fStartTime, this.fEndTime, this.fFrequency));
        if (this.fUncompressedBindings.length > 0) {
            bindings.addAll(Arrays.asList(this.fUncompressedBindings));
        }
        return bindings.toArray(new AgentMetricData[bindings.size()]);
    }

    private static final class AbsentTimeslice
    implements IConstructorExternalizable,
    ICompressedMetric {
        private final AgentMetric fMetric;
        private final int fType;

        public AbsentTimeslice(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fMetric = (AgentMetric)in.readObject();
            this.fType = in.readInt();
        }

        public AbsentTimeslice(AgentMetric metric, IMetricDataValue value) {
            this.fMetric = metric;
            this.fType = value.getType();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.fMetric);
            out.writeInt(this.fType);
        }

        public AgentMetricData getAgentMetric(long startTime, long endTime, Frequency frequency) {
            return new AgentMetricData(this.fMetric, frequency, ATimeslicedValue.createHoleValue(this.fType, startTime, endTime));
        }
    }

    private static final class CompressedIntegerTimeslice
    implements IConstructorExternalizable,
    ICompressedMetric {
        private final AgentMetric fMetric;
        private final int fValue;
        private final int fMin;
        private final int fMax;
        private final long fCount;
        private final int fType;

        public CompressedIntegerTimeslice(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fMetric = (AgentMetric)in.readObject();
            this.fType = in.readInt();
            this.fCount = in.readLong();
            this.fValue = in.readInt();
            this.fMin = in.readInt();
            this.fMax = in.readInt();
        }

        public CompressedIntegerTimeslice(AgentMetric metric, IntegerTimeslicedValue value) {
            this.fMetric = metric;
            this.fType = value.getType();
            this.fCount = value.getDataPointCount();
            this.fValue = value.getValue();
            this.fMin = value.getMinimum();
            this.fMax = value.getMaximum();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.fMetric);
            out.writeInt(this.fType);
            out.writeLong(this.fCount);
            out.writeInt(this.fValue);
            out.writeInt(this.fMin);
            out.writeInt(this.fMax);
        }

        public AgentMetricData getAgentMetric(long startTime, long endTime, Frequency frequency) {
            return new AgentMetricData(this.fMetric, frequency, new IntegerTimeslicedValue(this.fType, startTime, endTime, null, this.fCount, false, this.fValue, this.fMin, this.fMax));
        }
    }

    private static final class CompressedLongTimeslice
    implements IConstructorExternalizable,
    ICompressedMetric {
        private final AgentMetric fMetric;
        private final long fValue;
        private final long fMin;
        private final long fMax;
        private final long fCount;
        private final int fType;

        public CompressedLongTimeslice(ObjectInput in) throws ClassNotFoundException, IOException {
            this.fMetric = (AgentMetric)in.readObject();
            this.fType = in.readInt();
            this.fCount = in.readLong();
            this.fValue = in.readLong();
            this.fMin = in.readLong();
            this.fMax = in.readLong();
        }

        public CompressedLongTimeslice(AgentMetric metric, LongTimeslicedValue value) {
            this.fMetric = metric;
            this.fType = value.getType();
            this.fCount = value.getDataPointCount();
            this.fValue = value.getValue();
            this.fMin = value.getMinimum();
            this.fMax = value.getMaximum();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.fMetric);
            out.writeInt(this.fType);
            out.writeLong(this.fCount);
            out.writeLong(this.fValue);
            out.writeLong(this.fMin);
            out.writeLong(this.fMax);
        }

        public AgentMetricData getAgentMetric(long startTime, long endTime, Frequency frequency) {
            return new AgentMetricData(this.fMetric, frequency, new LongTimeslicedValue(this.fType, startTime, endTime, null, this.fCount, false, this.fValue, this.fMin, this.fMax));
        }
    }

    public static interface ICompressedMetric {
        public AgentMetricData getAgentMetric(long var1, long var3, Frequency var5);
    }

    private static final class ZeroTimeslice
    implements IConstructorExternalizable,
    ICompressedMetric {
        private final AgentMetric fMetric;
        private final int fType;

        public ZeroTimeslice(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fMetric = (AgentMetric)in.readObject();
            this.fType = in.readInt();
        }

        public ZeroTimeslice(AgentMetric metric, IMetricDataValue value) {
            this.fMetric = metric;
            this.fType = value.getType();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.fMetric);
            out.writeInt(this.fType);
        }

        public AgentMetricData getAgentMetric(long startTime, long endTime, Frequency frequency) {
            if (TypeInquisitor.isInteger(this.fType)) {
                return new AgentMetricData(this.fMetric, frequency, new IntegerTimeslicedValue(this.fType, startTime, endTime, null, 0L, false, 0, 0, 0));
            }
            return new AgentMetricData(this.fMetric, frequency, new LongTimeslicedValue(this.fType, startTime, endTime, null, 0L, false, 0L, 0L, 0L));
        }
    }
}

