/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.LazyMetricNameProvider;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.probe.net.ManagedSocketMapHelper;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultBackendHelper
implements ITransactionElementProvider {
    private static final DefaultBackendHelper kInstance = new DefaultBackendHelper();
    private volatile IAgent fAgent;
    private static volatile boolean fOldMode;
    private volatile WilyTransactionStructure structure;
    private static final Integer kMinusOne;
    private static final String kStallAttr = "Stall Count";
    private static final String kResponseTimeAttr = "Average Response Time (ms)";
    private static final String kPerIntervalAttr = "Responses Per Interval";
    private static final String kErrorsAttr = "Errors Per Interval";
    private static final String kAttributeSeparationString = ":";

    static {
        kMinusOne = new Integer(-1);
    }

    public static DefaultBackendHelper getInstance() {
        return kInstance;
    }

    public void setAgent(IAgent agent) {
        this.fAgent = agent;
        fOldMode = this.fAgent == null ? false : this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.configuration.defaultbackends.legacy", false);
        this.structure = WilyTransactionStructure.getInstance();
    }

    @Override
    public ITransactionElement getElement(Object key, ITransactionElement parent) {
        return this.getElementOnStartTrace(key, 0, null, parent);
    }

    @Override
    public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        return this.getElementOnStartTrace(key, tracerIndex, data, parent);
    }

    @Override
    public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        return this.getElementOnStartTrace(true, key, tracerIndex, data, parent);
    }

    private ITransactionElement getElementOnEndTrace(boolean doAlsoAppMap, Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        return this.getElementOnStartTrace(doAlsoAppMap, key, tracerIndex, data, parent);
    }

    private ITransactionElement getElementOnStartTrace(boolean alsoDoAppMap, Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        SocketTransactionElement result = null;
        String keyString = key.toString();
        if (parent instanceof IBlameTransactionElement) {
            String currentOldModeBackend;
            IBlameTransactionElement blameParent = (IBlameTransactionElement)parent;
            IBlameTransactionElement currentFrontend = BackendTracer.getFrontendElementForCalledBackendMetrics(blameParent);
            IBlameTransactionElement entrypointElement = BackendTracer.getAutomaticEntryPointElementForCalledBackendMetrics(blameParent);
            VirtualStack.TransactionCache cache = VirtualStack.getTransactionCache();
            String currentOldModeFrontend = cache.getFrontend();
            result = this.checkConditionsForDefaultBackend(blameParent, currentFrontend, currentOldModeFrontend, currentOldModeBackend = cache.getBackend(), tracerIndex, data) ? this.createSocketCursor(blameParent, keyString, currentFrontend, currentOldModeFrontend, entrypointElement) : this.createDummySocketCursor(parent, keyString);
        } else {
            result = this.createDummySocketCursor(parent, keyString);
        }
        return result;
    }

    private boolean checkConditionsForDefaultBackend(IBlameTransactionElement candidateForDefaultBackend, IBlameTransactionElement currentFrontend, String currentOldModeFrontend, String currentOldModeBackend, int tracerIndex, IStackElement data) {
        if (fOldMode) {
            boolean result;
            boolean bl = result = !candidateForDefaultBackend.isBackend() && currentFrontend != null && currentFrontend != candidateForDefaultBackend;
            if (result) {
                Iterator i = data.getStartCursorsIterator();
                while (i.hasNext()) {
                    Object startCursor = i.next();
                    if (startCursor != currentFrontend) continue;
                    return false;
                }
            }
            return result;
        }
        return !candidateForDefaultBackend.isBackend() && currentOldModeBackend == null;
    }

    private SocketTransactionElement createDummySocketCursor(ITransactionElement blameParent, String key) {
        return new SocketTransactionElement(key, blameParent);
    }

    private SocketTransactionElement createSocketCursor(IBlameTransactionElement blameParent, String metricName, IBlameTransactionElement currentFrontend, String currentOldModeFrontend, IBlameTransactionElement entryPointElement) {
        HashMap<IRepository, AgentMetric[]> metrics = new HashMap<IRepository, AgentMetric[]>(4);
        String calledPrefix = BackendTracer.getCalledPrefix(currentFrontend == null ? currentOldModeFrontend : ((WilyTransactionElement)currentFrontend).getBlameName());
        String calledPrefixForEntryPoint = entryPointElement == null ? null : BackendTracer.getCalledPrefix(((WilyTransactionElement)entryPointElement).getBlameName());
        AgentMetric[] timerMetric = this.createTimerMetric(calledPrefix, calledPrefixForEntryPoint, String.valueOf(metricName) + kAttributeSeparationString + kResponseTimeAttr);
        IRepository timerSds = BlamePointTracer.getAverageMetricRepository();
        metrics.put(timerSds, timerMetric);
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(calledPrefix, calledPrefixForEntryPoint, String.valueOf(metricName) + kAttributeSeparationString + kPerIntervalAttr);
        IRepository perIntervalSds = BlamePointTracer.getCountQueuedRepository(true);
        metrics.put(perIntervalSds, perIntervalMetric);
        AgentMetric[] stallMetric = this.createStallsMetric(calledPrefix, calledPrefixForEntryPoint, String.valueOf(metricName) + kAttributeSeparationString + kStallAttr);
        IRepository stallSds = BlamePointTracer.getCountImmediateRepository(false);
        metrics.put(stallSds, stallMetric);
        AgentMetric[] errorMetric = this.createErrorsMetric(calledPrefix, calledPrefixForEntryPoint, String.valueOf(metricName) + kAttributeSeparationString + kErrorsAttr);
        IRepository errorSds = BlamePointTracer.getCountQueuedRepository(true);
        metrics.put(errorSds, errorMetric);
        return new SocketTransactionElement(metricName, blameParent, currentFrontend, metrics, timerSds, perIntervalSds, errorSds);
    }

    protected AgentMetric[] createTimerMetric(String prefixForFrontend, String prefixForEntryPoint, String formattedMetricName) {
        int metricType = 536871937;
        ArrayList<AgentMetric> metrics = new ArrayList<AgentMetric>();
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        metrics.add(metric);
        if (prefixForFrontend != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForFrontend) + formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
            metrics.add(metric);
        }
        if (prefixForEntryPoint != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForEntryPoint) + formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
            metrics.add(metric);
        }
        AgentMetric[] array = new AgentMetric[metrics.size()];
        return metrics.toArray(array);
    }

    protected AgentMetric[] createPerIntervalMetric(String prefixForFrontend, String prefixForEntryPoint, String formattedMetricName) {
        int metricType = 0x20002002;
        ArrayList<AgentMetric> metrics = new ArrayList<AgentMetric>();
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        metrics.add(metric);
        if (prefixForFrontend != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForFrontend) + formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
            metrics.add(metric);
        }
        if (prefixForEntryPoint != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForEntryPoint) + formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
            metrics.add(metric);
        }
        AgentMetric[] array = new AgentMetric[metrics.size()];
        return metrics.toArray(array);
    }

    protected AgentMetric[] createErrorsMetric(String prefixForFrontend, String prefixForEntryPoint, String formattedMetricName) {
        int metricType = 0x20002002;
        ArrayList<AgentMetric> metrics = new ArrayList<AgentMetric>();
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        metrics.add(metric);
        if (prefixForFrontend != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForFrontend) + formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
            metrics.add(metric);
        }
        if (prefixForEntryPoint != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForEntryPoint) + formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
            metrics.add(metric);
        }
        AgentMetric[] array = new AgentMetric[metrics.size()];
        return metrics.toArray(array);
    }

    protected AgentMetric[] createStallsMetric(String prefixForFrontend, String prefixForEntryPoint, String formattedMetricName) {
        int metricType = 536871297;
        ArrayList<AgentMetric> metrics = new ArrayList<AgentMetric>();
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        metrics.add(metric);
        if (prefixForFrontend != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForFrontend) + formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
            metrics.add(metric);
        }
        if (prefixForEntryPoint != null) {
            metric = RepositoryFactory.unSafeGetMetricOfType(WilyTransactionStructure.getInstance().getAgent(), String.valueOf(prefixForEntryPoint) + formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
            metrics.add(metric);
        }
        AgentMetric[] array = new AgentMetric[metrics.size()];
        return metrics.toArray(array);
    }

    public SocketTransactionElement submitNextDefaultBackendCursor(Object key, LazyMetricNameProvider provider, ITransactionElement currentCursor, IStackElement currentData) {
        return this.submitNextDefaultBackendCursor(key, provider, currentCursor, currentData, false);
    }

    public SocketTransactionElement submitNextDefaultBackendCursor(Object key, final LazyMetricNameProvider provider, ITransactionElement currentCursor, IStackElement currentData, final boolean alsoDoAppMap) {
        SocketTransactionElement socketTransactionElement = (SocketTransactionElement)this.structure.submitNextCursor(key, currentCursor, currentData, new ITransactionElementProvider(){

            @Override
            public ITransactionElement getElement(Object key, ITransactionElement parent) {
                return DefaultBackendHelper.getInstance().getElement(key, parent);
            }

            @Override
            public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
                return DefaultBackendHelper.getInstance().getElementOnStartTrace(alsoDoAppMap, provider.getMetricName(data), tracerIndex, data, parent);
            }

            @Override
            public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
                return DefaultBackendHelper.getInstance().getElementOnEndTrace(alsoDoAppMap, provider.getMetricName(data), tracerIndex, data, parent);
            }
        });
        if (socketTransactionElement != null && socketTransactionElement.needToSendAppMapAgain(WilyTransactionStructure.getInstance().getAppMapAgingCounter()) && currentData instanceof InvocationData) {
            this.reportAppMapComponent(key, currentData, alsoDoAppMap);
        }
        return socketTransactionElement;
    }

    public SocketTransactionElement submitNextDefaultBackendCursor(Object key, ITransactionElement currentCursor, IStackElement currentData) {
        return (SocketTransactionElement)this.structure.submitNextCursor(key, currentCursor, currentData, this);
    }

    public SocketTransactionElement submitNextDefaultBackendCursor(Object key, ITransactionElement currentCursor, IStackElement currentData, final boolean alsoDoAppMap) {
        SocketTransactionElement socketTransactionElement = (SocketTransactionElement)this.structure.submitNextCursor(key, currentCursor, currentData, new ITransactionElementProvider(){

            @Override
            public ITransactionElement getElement(Object key, ITransactionElement parent) {
                return DefaultBackendHelper.getInstance().getElement(key, parent);
            }

            @Override
            public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
                return DefaultBackendHelper.getInstance().getElementOnStartTrace(alsoDoAppMap, key, tracerIndex, data, parent);
            }

            @Override
            public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
                return DefaultBackendHelper.getInstance().getElementOnEndTrace(alsoDoAppMap, key, tracerIndex, data, parent);
            }
        });
        if (socketTransactionElement != null && socketTransactionElement.needToSendAppMapAgain(WilyTransactionStructure.getInstance().getAppMapAgingCounter()) && currentData instanceof InvocationData) {
            this.reportAppMapComponent(key, currentData, alsoDoAppMap);
        }
        return socketTransactionElement;
    }

    private void reportAppMapComponent(Object key, IStackElement currentData, boolean alsoDoAppMap) {
        String keyString = key.toString();
        if (alsoDoAppMap) {
            String socketName = keyString;
            if (keyString.startsWith("Backends|")) {
                socketName = keyString.substring("Backends|".length());
            }
            ManagedSocketMapHelper.markForAppMapIfEnabled(socketName, (InvocationData)currentData, kMinusOne);
        } else {
            ((InvocationData)currentData).setHasNewCursor();
        }
    }
}

