/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.VirtualStackFeatureHelper;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceListProvider;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampHelper;
import com.wily.introscope.agent.trace.intelligent.AutoTracingHelper;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class TransactionHarvestHelper {
    public static final int kTempChildrenDefaultSize = 4;
    private static IAgent sAgent;
    public static boolean fIntelligentInstrumentationEnabled;
    public static final String kIntelligentInstrumentationEnablingProperty = "introscope.agent.deep.instrumentation.enabled";
    public static final boolean kIntelligentInstrumentationEnablingPropertyDefaultValue = true;
    public static final String kLanguageDefaultValue = "java";
    public static volatile String fLanguage;

    static {
        fLanguage = kLanguageDefaultValue;
        try {
            sAgent = AgentShim.getAgent();
            fIntelligentInstrumentationEnabled = sAgent.IAgent_getIndexedProperties().getBooleanProperty(kIntelligentInstrumentationEnablingProperty, true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static void doHarvest(ITransactionInstanceListProvider structure, IStackElement stckElement) {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceCallBack;
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        if (tcs == null) {
            IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
            feedback.warn("TransactionHarvestHelper.doHarvest fails with null tcs. need to configure a tracer that creates tcs");
            return;
        }
        if (!tcs.isSampled() && TransactionTraceController.getHasBeenClamped()) {
            if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
                HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.cleanupOnWhenTraceIsClamped();
            }
            return;
        }
        boolean currentTxnMarkedForCollection = FilterController.canCurrentTransactionBeMarkedForCollection(stckElement);
        List trace = stckElement.getTransactionInstanceList();
        int position = trace.size() - 1;
        if (position <= 0) {
            return;
        }
        ITransactionInstance tFirstEnd = (ITransactionInstance)trace.get(position);
        if (!currentTxnMarkedForCollection) {
            Map filterParams = tcs.getFilterParameters();
            filterParams.put("introscope.transactiontrace.threshold.key", new Long(tFirstEnd.getDuration()));
            if (tcs.getErrorsSeenInThisTxn().size() > 0) {
                filterParams.put("introscope.transactiontrace.errorfilter.key", tcs.getErrorsSeenInThisTxn());
            }
            boolean bl = currentTxnMarkedForCollection = FilterController.finalFiltersExecute(tcs) || FilterController.pessimisticFiltersExecute(tcs);
            if (!currentTxnMarkedForCollection && !tcs.anyPendingTailFilters()) {
                TransactionHarvestHelper.processAutoTracing(stckElement);
                return;
            }
        }
        Stack<TransactionComponentData> traversingStack = new Stack<TransactionComponentData>();
        if (!structure.validateTransaction(tFirstEnd)) {
            return;
        }
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled && IntelligentTransactionHarvesterHelper.harvestTransaction(stckElement, highPerformanceCallBack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal(), true)) {
            return;
        }
        long duration = 0L;
        TransactionComponentData root = null;
        do {
            ITransactionInstance tend;
            if ((tend = (ITransactionInstance)trace.get(position)) == null) {
                return;
            }
            ITransactionElement te = tend.getTransactionElement();
            if (te == null) {
                return;
            }
            if (!(te instanceof BlameTransactionElement)) continue;
            BlameTransactionElement last = (BlameTransactionElement)te;
            if (!last.isStartTrace()) {
                TransactionComponentData bizDefComponent;
                ITransactionInstance tStart = tend.getStartInstance();
                if (tStart == null) {
                    return;
                }
                tStart.getTransactionElement();
                long startTrace = tStart.getData().getWallClockStartTime();
                duration = tend.getDuration();
                if (duration < 0L) {
                    Assertion.wilyAssert(duration >= 0L, "The duration should be bigger than zero");
                    duration = 0L;
                }
                TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(last.getResourceName(), startTrace, duration);
                BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", startTrace);
                if (traversingStack.isEmpty()) {
                    root = component;
                } else {
                    TransactionComponentData peekedItem = (TransactionComponentData)traversingStack.peek();
                    peekedItem.tempChildren.add(0, component);
                }
                component.tempChildren = new ArrayList(4);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                component.setParameters(parameters);
                IStackElement dataElement = tend.getData();
                if (dataElement != null) {
                    ProbeInformation fInfo;
                    if (last instanceof WilyTransactionElement && dataElement instanceof InvocationData && (fInfo = ((InvocationData)dataElement).getProbeInformation()) != null) {
                        parameters.put("Method", fInfo.getProbeIdentification().getProbeMethodName());
                        parameters.put("Method Descriptor", fInfo.getProbeIdentification().getProbeMethodDescriptor());
                        parameters.put("Class", fInfo.getProbeIdentification().getRuntimeFullClassName());
                        parameters.put("Resource Name", component.getResource());
                        IFactoryLevelParameterCallback[] staticCallbacks = fInfo.getCallbacks();
                        int i = 0;
                        while (i < staticCallbacks.length) {
                            if (staticCallbacks[i] != null) {
                                staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
                            }
                            ++i;
                        }
                    }
                    VirtualStack.addParameterCallbacks(parameters, dataElement);
                    dataElement.addParameterCallbacks(parameters);
                }
                Object error = dataElement.get("Exception");
                Object errMsg = dataElement.get("Error Message");
                if (error != null) {
                    parameters.put("Exception", error);
                }
                if (errMsg != null) {
                    parameters.put("Error Message", errMsg);
                }
                if (!currentTxnMarkedForCollection) {
                    currentTxnMarkedForCollection = TransactionHarvestHelper.passesLegacyTailFilters(component, tcs);
                }
                TransactionHarvestHelper.includeSocketParams(parameters, tend.getData());
                if (root == component && !component.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(component)) != null) {
                    root = bizDefComponent;
                    traversingStack.push(bizDefComponent);
                }
                traversingStack.push(component);
                continue;
            }
            if (traversingStack.isEmpty()) continue;
            traversingStack.pop();
        } while (--position >= 0);
        TransactionHarvestHelper.includeRootParams(root.getParameters(), stckElement);
        VirtualStackFeatureHelper.realizeSubcomponent(root);
        if (tcs.isSampled()) {
            root.getParameters().put("Trace Type", "Sampled");
        }
        if (tcs.isComponentClampAlreadyHitForTxn()) {
            root.setParameterValue("Components Not Shown", Integer.toString(tcs.getComponentClampAfterCount()));
        }
        sAgent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(root);
    }

    private static void processAutoTracing(IStackElement stckElement) {
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack highPerformanceCallBack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            if (AutoTracingHelper.checkForAutoTracing()) {
                if (!AutoTracingClampHelper.checkClampAndIncrement()) {
                    highPerformanceCallBack.setAutoTracedSuccess(true);
                    boolean result = IntelligentTransactionHarvesterHelper.harvestTransaction(stckElement, highPerformanceCallBack, false);
                    if (result) {
                        SustainabilityMetricsHelper.reportAutoTracingSustainibilityMetricsSent(1);
                    }
                } else {
                    TransactionHarvestHelper.submitTransactionToCache(stckElement);
                }
            } else {
                TransactionHarvestHelper.submitTransactionToCache(stckElement);
            }
        }
    }

    public static void submitTransactionToCache(IStackElement stckElement) {
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
            IntelligentTransactionHarvesterHelper.submitTransactionToCache(stckElement);
        }
    }

    private static IEventDataNode findFrontendNode(IEventDataNode root) {
        LinkedList<IEventDataNode> queue = new LinkedList<IEventDataNode>();
        queue.offer(root);
        int level = 0;
        queue.offer(null);
        while (!queue.isEmpty()) {
            IEventDataNode node = (IEventDataNode)queue.poll();
            if (node.getParameterValue("Business Definition") != null) {
                return node;
            }
            int i = 0;
            while (i < node.getSubNodeCount()) {
                queue.offer(node.getSubNode(i));
                ++i;
            }
            if (queue.peek() != null) continue;
            if (level >= 15) {
                return null;
            }
            queue.poll();
            if (queue.isEmpty()) continue;
            ++level;
            queue.offer(null);
        }
        return null;
    }

    public static TransactionComponentData buildBusinessTransactionComponent(TransactionComponentData component) {
        TransactionComponentData bizDefComponent = null;
        IEventDataNode frontendComponent = component;
        String bizDefStr = frontendComponent.getParameterValue("Business Definition");
        if (bizDefStr == null && frontendComponent.getResource().startsWith("Automatic Entry Points") && (frontendComponent = TransactionHarvestHelper.findFrontendNode(component)) != null) {
            bizDefStr = frontendComponent.getParameterValue("Business Definition");
        }
        if (bizDefStr != null) {
            String EBTFeature;
            bizDefComponent = TransactionComponentData.createMilliSecTransactionComponentData(bizDefStr, component.getStartTimeInMillisecs(), component.getDurationInMillisecs());
            HashMap<String, String> bizDefParameters = new HashMap<String, String>();
            bizDefComponent.setParameters(bizDefParameters);
            Map params = frontendComponent.getParameters();
            bizDefParameters.put("Business Definition", bizDefStr);
            params.remove("Business Definition");
            bizDefParameters.put("Language", fLanguage);
            String ttParamName = frontendComponent.getParameterValue("EUM Business Transaction");
            String corGuid = frontendComponent.getParameterValue("CorGUID");
            String url = frontendComponent.getParameterValue("URL");
            String traceId = frontendComponent.getParameterValue("TxnTraceId");
            if (ttParamName != null) {
                bizDefParameters.put("EUM Business Transaction", ttParamName);
                params.remove("EUM Business Transaction");
            }
            if (corGuid != null) {
                bizDefParameters.put("CorGUID", corGuid);
                params.remove("CorGUID");
            }
            if (url != null) {
                bizDefParameters.put("URL", url);
            }
            if (traceId != null) {
                bizDefParameters.put("TxnTraceId", traceId);
            }
            String userId = component.getParameterValue("User ID");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("BS/BT User Id Problem: UserId got is: " + userId);
            }
            if (userId != null) {
                bizDefParameters.put("User ID", userId);
            }
            if ((EBTFeature = sAgent.IAgent_getConfigurationManager().getProperty("introscope.agent.external.biz.enabled")) != null && "true".equalsIgnoreCase(EBTFeature)) {
                String appname;
                String tenant;
                String sdk;
                String connection;
                String os;
                String device;
                String location;
                String carrier = component.getParameterValue("x-apm-bt.Carrier");
                if (carrier != null) {
                    bizDefParameters.put("x-apm-bt.Carrier", carrier);
                    params.remove("x-apm-bt.Carrier");
                }
                if ((location = component.getParameterValue("x-apm-bt.Location")) != null) {
                    bizDefParameters.put("x-apm-bt.Location", location);
                    params.remove("x-apm-bt.Location");
                }
                if ((device = component.getParameterValue("x-apm-bt.Device")) != null) {
                    bizDefParameters.put("x-apm-bt.Device", device);
                    params.remove("x-apm-bt.Device");
                }
                if ((os = component.getParameterValue("x-apm-bt.OS Version")) != null) {
                    bizDefParameters.put("x-apm-bt.OS Version", os);
                    params.remove("x-apm-bt.OS Version");
                }
                if ((connection = component.getParameterValue("x-apm-bt.Connection")) != null) {
                    bizDefParameters.put("x-apm-bt.Connection", connection);
                    params.remove("x-apm-bt.Connection");
                }
                if ((sdk = component.getParameterValue("x-apm-bt.Identifier Version")) != null) {
                    bizDefParameters.put("x-apm-bt.Identifier Version", sdk);
                    params.remove("x-apm-bt.Identifier Version");
                }
                if ((tenant = component.getParameterValue("x-apm-bt.Tenant")) != null) {
                    bizDefParameters.put("x-apm-bt.Tenant", tenant);
                    params.remove("x-apm-bt.Tenant");
                }
                if ((appname = component.getParameterValue("x-apm-bt.Application Name")) != null) {
                    bizDefParameters.put("x-apm-bt.Application Name", appname);
                    params.remove("x-apm-bt.Application Name");
                }
            }
            bizDefComponent.tempChildren = new ArrayList(4);
            bizDefComponent.tempChildren.add(component);
        }
        return bizDefComponent;
    }

    private static void includeCorParams(Map parameters) {
        String corid;
        SharedCrossProcessData cache = sAgent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache != null && (corid = cache.getCorrelationID()) != null) {
            String seqid;
            parameters.put("CorCrossProcessData", corid);
            SequenceId id = cache.getSeqID();
            if (id != null && (seqid = id.getSequenceId()) != null) {
                parameters.put("SeqNoCrossProcessData", seqid);
            }
            String txnTraceId = cache.getStringParamIn("TxnTraceId");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller GUID " + txnTraceId);
            }
            if (txnTraceId != null) {
                parameters.put("CallerTxnTraceId", txnTraceId);
            }
            String callerTxnTime = cache.getStringParamIn("CallerTimestamp");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller's timestamp " + callerTxnTime);
            }
            if (callerTxnTime != null) {
                parameters.put("CallerTimestamp", callerTxnTime);
            }
            String nonBlockTxn = cache.getStringParamIn("NBThreadTxn");
            if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack current Txn Non Blocking = " + nonBlockTxn);
            }
            if (nonBlockTxn != null) {
                parameters.put("NBThreadTxn", nonBlockTxn);
            }
        }
    }

    public static void includeRootParams(Map parameters, IStackElement data) {
        parameters.put("Trace Type", "Normal");
        Runnable thread = null;
        if (data != null) {
            thread = data.getMyThread();
        }
        String threadName = null;
        String threadGroupName = null;
        if (thread == null) {
            threadName = InvocationData.limitSize(Thread.currentThread().getName());
            threadGroupName = InvocationData.limitSize(Thread.currentThread().getThreadGroup().getName());
        } else if (thread instanceof Thread) {
            Thread t = (Thread)thread;
            threadName = InvocationData.limitSize(t.getName());
            threadGroupName = InvocationData.limitSize(t.getThreadGroup().getName());
        } else {
            threadName = thread.toString();
            threadGroupName = "NA";
        }
        if (threadName != null) {
            parameters.put("Thread Name", threadName);
        }
        if (threadGroupName != null) {
            parameters.put("Thread Group Name", threadGroupName);
        }
        parameters.put("Language", fLanguage);
        TransactionHarvestHelper.includeCorParams(parameters);
    }

    public static void includeSocketParams(Map parameters, IStackElement data) {
        Iterator i;
        if (data != null && (i = data.getAppMapSocketCursors()) != null) {
            int index = 1;
            while (i.hasNext()) {
                parameters.put("Socket" + index++, ((SocketTransactionElement)i.next()).getSocketDescription());
            }
        }
    }

    private static boolean passesLegacyTailFilters(TransactionComponentData root, TransactionCollectStatus tcs) {
        return FilterController.pessimisticLegacyFiltersExecute(root, tcs);
    }
}

