/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class DatagramNameFormatter
extends ASocketNameFormatter {
    public DatagramNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected ASocketNameFormatter.ResourceAndAddress getResourceAndAddress(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel) {
            DatagramChannel channel = (DatagramChannel)invocationObject;
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
            String resourceName = DatagramChannelMap.getResourceName(channel, remoteAddress);
            InetSocketAddress address = DatagramChannelMap.getAddress(channel, remoteAddress);
            if (resourceName != null && address != null) {
                return new ASocketNameFormatter.ResourceAndAddress(resourceName, address);
            }
        }
        return null;
    }
}

