/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe;

import com.wily.diagnos.cmp.DGVersion;
import com.wily.diagnos.cmp.batch.IClassCompiler;
import com.wily.diagnos.cmp.batch.IMethodCompiler;
import com.wily.diagnos.cmp.batch.MethodCompilerSettingsCache;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.DirectivesDirectoryException;
import com.wily.diagnos.cmp.directives.DirectivesException;
import com.wily.diagnos.cmp.directives.DirectivesFile;
import com.wily.diagnos.cmp.directives.DirectivesFileList;
import com.wily.diagnos.cmp.directives.DirectivesListFile;
import com.wily.diagnos.cmp.directives.IDirective;
import com.wily.diagnos.cmp.directives.IExportDirectiveCallback;
import com.wily.diagnos.cmp.directives.IExportableDirective;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.UnsupportedDGCompilerSettingModificationException;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.apply.MethodSettingsApplier;
import com.wily.diagnos.cmp.directives.apply.ParentPersistenceFileLockHelper;
import com.wily.diagnos.cmp.directives.apply.PersistenceFileLockHelper;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.cmp.log.AsynchCompilerLogWrapper;
import com.wily.diagnos.cmp.log.CompilerLogCollection;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.DGCompilerLog;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.NullCompilerLog;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.diagnos.personality.NativePersonality;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.attributes.DGCode;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiPlugin;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationService;
import com.wily.introscope.agent.trace.TracerEncoding;
import com.wily.introscope.agent.transformer.ClassFileTransformer;
import com.wily.introscope.agent.transformer.ClassFileTransformerShouldNotRunException;
import com.wily.introscope.agent.transformer.IInstrumentationAcceptor;
import com.wily.introscope.agent.transformer.IMethodTransformer;
import com.wily.introscope.agent.transformer.IllegalClassFormatException;
import com.wily.introscope.agent.transformer.OnInstrumentationAcceptedCallback;
import com.wily.introscope.agent.transformer.dynamic.ACodeIntrospectionService;
import com.wily.introscope.agent.transformer.dynamic.ADynamicDirectivesService;
import com.wily.introscope.agent.transformer.dynamic.ADynamicInstrumentationService;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.transformer.dynamic.IBootstrapTransformer;
import com.wily.introscope.agent.transformer.dynamic.IClassLoaderVerifier;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionCallback;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.ICodeIntrospectionService;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.agent.transformer.dynamic.IDynamicDirectivesService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicDirectivesServiceCallback;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationFilter;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationManager;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.transformer.dynamic.IGroupInstrumentationService;
import com.wily.introscope.agent.transformer.dynamic.IRedefinitionCallback;
import com.wily.introscope.agent.transformer.dynamic.ITracerProviderService;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.introscope.autoprobe.AutoProbeExtensionLoader;
import com.wily.introscope.autoprobe.ClassCompilerTransformerWrapper;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.introscope.autoprobe.RecordingMethodMutator;
import com.wily.introscope.autoprobe.loading.ADirectiveLoader;
import com.wily.introscope.autoprobe.loading.FallbackDirectiveLoader;
import com.wily.introscope.autoprobe.loading.IDirectiveLoader;
import com.wily.introscope.autoprobe.loading.NullDirectiveLoader;
import com.wily.introscope.extension.IPluginLoaderCallback;
import com.wily.introscope.extension.PlatformCheckUtil;
import com.wily.introscope.extension.PluginLoader;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.introscope.probebuilder.InternalDirectivesLoader;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicDirectivesResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IDynamicInstrumentationListener;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.UnsupportedDIOperationException;
import com.wily.util.LogFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.IResourceWriter;
import com.wily.util.resource.InvalidResourceException;
import com.wily.util.task.AsynchExecutionQueue;
import com.wily.util.text.ALocalizableException;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.ValidationException;
import com.wily.util.version.IVersion;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoProbeTransformer
implements ClassFileTransformer,
IAutoProbeConfig,
IInstrumentationAcceptor,
IMethodTransformer,
IDynamicInstrumentationTransformer,
ICompilerLogger,
IDynamicInstrumentationFilter,
ClassCompilerTransformerWrapper,
IGroupInstrumentationService,
ITracerProviderService,
IClassLoaderVerifier,
IOSGiPlugin {
    private static final int kSendEnvironmentCycleTime = 30000;
    private static final IClassRedefinitionCallback kEmptyCallback;
    private static final Module sModule;
    private static final String kListSeparator = ",";
    private static final String kDirectivesCheckBehaviorName = "Introscope Directives Check Behavior";
    private static final String kMethodTracerParameterTemporaryValue = "&temporary=";
    private static final String kMethodTracerParameterLabelValue = "&label=";
    private static final long kMultipleOfHeartbeatPeriod = 8L;
    private final DirectivesCheckHeartbeatBehavior fDirCheckBehavior;
    private final IntervalHeartbeat fHeartbeat;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IAgent fAgent;
    private final ICompilerPersonality fPersonality;
    private final MethodCompilerSettingsCache fMethodCompilerSettingsCache;
    private final IVersion fVersion;
    private final IResource fResource;
    private IndexedProperties fProperties;
    private final boolean fSkipUnnamedClasses;
    private final String fUnnamedClassPlaceholder;
    private final ICompilerLog fLog;
    private IDirectiveLoader fLoader;
    private IBootstrapTransformer bt;
    private IDynamicInstrumentationManager fInstrumentationManager;
    private static final String kBootstrapGenericError = "Bootstrap_Class_Generic_Error";
    private static final String kBootstrapClassLoaded = "Bootstrap_Classes_Loaded";
    private static final String kBootstrapClassInstrumentationNameNotValid = "Bootstrap_Class_Instrumentation_Name_Not_Valid";
    private static final String kBootstrapClassNotFound = "Bootstrap_Class_Not_Found";
    private volatile DGCompilerSettings fCompilerSettings = null;
    private volatile Map<File, Long> fFileToLastModTimeMap;
    private static final int kDirectiveFilesMapInitialCapacity = 40;
    private File fAgentPropFile;
    private long fAgentPropFileLastModTime = 0L;
    private IClassRedefinitionDelegate fClassRedefinitionDelegate;
    private IDynamicDirectivesService fDynamicDirectivesService;
    private IDynamicInstrumentationService fDynamicInstrumentationService;
    private ICodeIntrospectionService fCodeIntrospectionService;
    private IDynamicInstrumentationFilter fFilter;
    private volatile IClassLoaderVerifier fClassLoaderVerifier;
    private IIntelligentInstrumentationService fIntelligentInstrumentationService = null;
    private IRegisteredBehavior fDirCheckRegisteredBehavior = null;
    private static final int kAllOK = 0;
    private static final int kBadList = 1;
    private static final int kBadFile = 2;
    private static final Class[] kParameterTypeList;
    private String fLogConfigurationProperty;
    private static final String kLogConfigurationPropertyName = "introscope.autoprobe.logging";
    private static final String kLogSkippedClassesEnablingProperty = "introscope.autoprobe.logskippedclasses.enabled";
    private final boolean fLogSkippedClasses;
    private final LogSkippedClassesEnabledConfigurationProperty fLogSkippedClassesProperty;
    private boolean fIntelligentInstrumentationEnabled = false;
    private final IntelligentInstrumentationEnabledConfigurationProperty fIntelligentInstrumentationEnabledProperty;
    public static final boolean kIntelligentInstrumentationEnablingPropertyDefaultValue = true;
    public static final String kIntelligentInstrumentationEnablingProperty = "introscope.agent.deep.instrumentation.enabled";
    private long currentLoadTimeStamp;
    private ClassLoader fAgentClassLoader;
    private static String[] allDirectivesFileList;
    private List fDirectiveLoadListeners = new ArrayList(2);
    private HashSet<String> fExtensionPBDs = null;

    static {
        try {
            Class.forName(ThreadLocalClassHelper.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {}
        kEmptyCallback = new IClassRedefinitionCallback(){

            public void executeOnRedefinition(Class redefinedClass, ByteArrayInputStream stream) {
            }

            public void executeOnUnsupportedOperation(UnsupportedDIOperationException exception, Class candidate, ByteArrayInputStream stream) {
            }
        };
        sModule = new Module("ProbeTransformer");
        kParameterTypeList = new Class[]{IAgent.class, IStringLocalizer.class, IResourceReader.class, String.class, String[].class, ICompilerPersonality.class};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AutoProbeTransformer(IAgent agent) throws ClassFileTransformerShouldNotRunException {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        this.fPersonality = NativePersonality.getNativePersonality();
        this.fHeartbeat = agent.IAgent_getConfigHeartbeat();
        this.fVersion = new IntroscopeVersion(this.fLocalizer);
        this.fResource = agent.IAgent_getConfigurationResource();
        this.fProperties = agent.IAgent_getIndexedProperties();
        this.feedbackStartupMessage();
        this.confirmEnabled();
        String[] directivesFiles = this.getDirectivesFiles(this.fProperties);
        allDirectivesFileList = directivesFiles;
        String[] dynamicDirectivesFiles = this.getDynamicDirectivesFiles(this.fProperties);
        this.fDirCheckBehavior = new DirectivesCheckHeartbeatBehavior(directivesFiles, this.fProperties);
        if (directivesFiles == null) {
            throw new ClassFileTransformerShouldNotRunException("Null or empty directives file list property in agent profile");
        }
        this.fSkipUnnamedClasses = this.shouldSkipUnnamedClasses();
        this.fUnnamedClassPlaceholder = this.loadUnnamedClassPlaceholder();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        cm.add(new StringSetConfigurationProperty(kLogConfigurationPropertyName, null, this.fFeedback, sModule, agent.IAgent_getStringLocalizer()){

            public final void set(Object value) {
                Set cv = (Set)value;
                AutoProbeTransformer.this.fLogConfigurationProperty = cv == null || cv.size() == 0 ? null : (String)cv.iterator().next();
            }
        });
        this.fLog = this.createLog(agent);
        this.fMethodCompilerSettingsCache = new MethodCompilerSettingsCache(this.fProperties, this.fLog);
        if (this.fResource == null) {
            this.fAgentPropFile = null;
        } else if (this.fResource.IResource_isFileResource()) {
            this.fAgentPropFile = new File(this.fResource.IResource_getLocation());
            this.fAgentPropFileLastModTime = this.fAgentPropFile.lastModified();
        } else {
            this.fAgentPropFile = null;
        }
        if (this.fAgentPropFile == null) {
            if (this.getFeedback().isDebugEnabled()) {
                this.getFeedback().debug("Agent properties not set by a config file.");
            }
        } else if (this.getFeedback().isDebugEnabled()) {
            this.getFeedback().debug("Agent properties set by config file " + this.fAgentPropFile.getAbsolutePath());
        }
        this.setupInstrumentationProperties();
        this.setDynamicInstrumentationService(new ADynamicInstrumentationService(this.fAgent, this, this.getFeedback()));
        this.setDynamicDirectivesService(new ADynamicDirectivesService(this.getAgent(), dynamicDirectivesFiles));
        this.setCodeIntrospectionService(new ACodeIntrospectionService(this, this, this.fAgent, this.getFeedback()));
        this.addDynamicInstrumentationFilter(this);
        IDirectiveLoader[] loaders = null;
        loaders = !PlatformCheckUtil.getInstance().isOsgiEnvironment() ? this.getLoaderExtensions(agent, directivesFiles) : this.getOSGiLoaderExtensions(agent, directivesFiles);
        this.fIntelligentInstrumentationEnabledProperty = new IntelligentInstrumentationEnabledConfigurationProperty(agent);
        agent.IAgent_getConfigurationManager().add(this.fIntelligentInstrumentationEnabledProperty, true);
        this.fIntelligentInstrumentationEnabled = this.fIntelligentInstrumentationEnabledProperty.isEnabled();
        if (loaders == null) throw new ClassFileTransformerShouldNotRunException("No valid directives loader extension found");
        this.fLoader = this.chooseLoader(loaders);
        try {
            if (this.loadDirectivesHelper(this.fLoader, true)) {
                this.fProperties = this.fAgent.IAgent_getIndexedProperties();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassFileTransformerShouldNotRunException();
        }
        this.registerDirectivesCheckBehavior();
        this.initializeBootstrapClasses();
        this.fClassLoaderVerifier = this;
        this.fClassLoaderVerifier = this;
        this.fLogSkippedClassesProperty = new LogSkippedClassesEnabledConfigurationProperty(agent);
        cm.add(this.fLogSkippedClassesProperty, true);
        this.fLogSkippedClasses = this.fLogSkippedClassesProperty.isEnabled();
        PersistenceFileLockHelper.initialize(this.fAgent);
        ParentPersistenceFileLockHelper.initialize(this.fAgent);
    }

    private void setupInstrumentationProperties() {
        DGClass.setDeepInheritance(this.fProperties.getBooleanProperty("introscope.autoprobe.deepinheritance.enable", true));
        DGCode.setConstructorInstrumentationPolicy(this.fProperties.getTrimmedProperty("introscope.autoprobe.constructor.policy", "Default"), this.fProperties.getTrimmedProperty("introscope.autoprobe.constructor.instrumentation.affected.vendors", "Oracle,SAP"));
    }

    private IDirectiveLoader chooseLoader(IDirectiveLoader[] loaders) {
        Assertion.wilyAssert(loaders != null);
        IDirectiveLoader result = null;
        int bestPrecedence = Integer.MAX_VALUE;
        int i = 0;
        while (i < loaders.length) {
            int precedence = loaders[i].getPrecedence();
            if (precedence < bestPrecedence) {
                result = loaders[i];
                bestPrecedence = precedence;
            }
            ++i;
        }
        return result;
    }

    private IDirectiveLoader[] getLoaderExtensions(IAgent agent, String[] directivesFiles) {
        ExtensionAdministrator ea = agent.IAgent_getExtensionAdministrator();
        IPlugin[] plugins = ea.getAgentPluginsByType("directiveloader");
        IDirectiveLoader[] result = null;
        if (agent.isTestAgent()) {
            String whatClassToUse = agent.IAgent_getIndexedProperties().getProperty("introscope.autoprobe.test.directivesLoaderClass");
            if (whatClassToUse == null) {
                agent.IAgent_getModuleFeedback().info("No directive loader extensions found, using the default directive loader");
                result = new IDirectiveLoader[]{new NullDirectiveLoader(agent, agent.IAgent_getStringLocalizer(), this.fResource.IResource_getResourceReader(), null, directivesFiles, this.fPersonality)};
            } else {
                try {
                    Class<?> c = Class.forName(whatClassToUse);
                    Constructor<?> cc = c.getConstructor(IAgent.class, IStringLocalizer.class, IResourceReader.class, String.class, String[].class, ICompilerPersonality.class);
                    Object[] objectArray = new Object[6];
                    objectArray[0] = agent;
                    objectArray[1] = agent.IAgent_getStringLocalizer();
                    objectArray[2] = this.fResource.IResource_getResourceReader();
                    objectArray[4] = directivesFiles;
                    objectArray[5] = this.fPersonality;
                    Object o = cc.newInstance(objectArray);
                    result = new IDirectiveLoader[]{(IDirectiveLoader)o};
                }
                catch (Exception exception) {
                    agent.IAgent_getModuleFeedback().info("Exception when creating specific classloader, using the default directive loader");
                    result = new IDirectiveLoader[]{new NullDirectiveLoader(agent, agent.IAgent_getStringLocalizer(), this.fResource.IResource_getResourceReader(), null, directivesFiles, this.fPersonality)};
                }
            }
        } else if (plugins != null && plugins.length > 0) {
            result = new IDirectiveLoader[plugins.length];
            try {
                int i = 0;
                while (i < plugins.length) {
                    IDirectiveLoader loader;
                    IStringLocalizer localizer = plugins[i].IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getLocalizer());
                    String source = plugins[i].IPlugin_getOwningExtension().IExtension_getSource();
                    Object[] args = new Object[]{agent, localizer, this.fResource.IResource_getResourceReader(), source, directivesFiles, this.fPersonality};
                    result[i] = loader = (IDirectiveLoader)ExtensionUtilities.createEntryPointClass(agent.IAgent_getModuleFeedback(), this.getLocalizer(), plugins[i], IDirectiveLoader.class, kParameterTypeList, args);
                    ++i;
                }
            }
            catch (Exception e) {
                agent.IAgent_getModuleFeedback().error("Exception creating directive loader");
                agent.IAgent_getModuleFeedback().verbose(e);
            }
        } else {
            agent.IAgent_getModuleFeedback().info("No directive loader extensions found, using the default directive loader");
            result = new IDirectiveLoader[]{new FallbackDirectiveLoader(agent, agent.IAgent_getStringLocalizer(), this.fResource.IResource_getResourceReader(), null, directivesFiles, this.fPersonality)};
        }
        return result;
    }

    private final IVersion getVersion() {
        return this.fVersion;
    }

    private final IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    private final IStringLocalizer getLocalizer() {
        return this.fLocalizer;
    }

    private final void feedbackStartupMessage() {
        this.getFeedback().info(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("FormattedProductNameAndReleaseAndBuildString", this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Printable_Name"), this.getVersion().IVersion_getReleaseAndBuildString(this.getLocalizer())));
    }

    private String[] getDynamicDirectivesFiles(IndexedProperties properties) {
        return this.parseFileList("dynamic");
    }

    private String[] getDirectivesFiles(IndexedProperties properties) {
        String[] result = null;
        String directivesFileList = properties.getTrimmedProperty("introscope.autoprobe.directivesFile");
        if (directivesFileList == null || directivesFileList.equals("")) {
            this.getFeedback().error(this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Directives_Files_Not_Specified_Error"));
        } else {
            result = this.parseFileList(directivesFileList);
        }
        return result;
    }

    private final void confirmEnabled() throws ClassFileTransformerShouldNotRunException {
        if (!this.fProperties.getBooleanProperty("introscope.autoprobe.enable", false)) {
            this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Disabled_By_User_Error", "introscope.autoprobe.enable"));
            throw new ClassFileTransformerShouldNotRunException();
        }
    }

    private final boolean shouldSkipUnnamedClasses() {
        if (this.fProperties.getBooleanProperty("introscope.autoprobe.processUnnamedClasses", false)) {
            this.getFeedback().info(this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Process_Unnamed_Classes"));
            return false;
        }
        return true;
    }

    private final String loadUnnamedClassPlaceholder() {
        return this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Unnamed_Class_Placeholder");
    }

    private final ICompilerLog createLog(IAgent agent) {
        block10: {
            if (AInstrumentationHelper.isValidate()) {
                return null;
            }
            String logFileName = this.getLogFileName();
            if (logFileName == null) {
                return new NullCompilerLog();
            }
            String logFileLocation = null;
            try {
                IResourceWriter writer = this.fResource.IResource_getResourceWriter();
                boolean enableLogFileAutoNaming = agent.IAgent_isLogFileAutoNamingEnabled();
                String baseLogFileName = logFileName;
                baseLogFileName = writer.IResourceWriter_getResourceLocation(baseLogFileName);
                logFileLocation = writer.IResourceWriter_getResourceLocation(logFileName);
                if (enableLogFileAutoNaming && logFileLocation != null) {
                    try {
                        logFileLocation = LogFileUtilities.appendUniqueTimestampToLogFileName(logFileLocation);
                    }
                    catch (IOException ioe) {
                        this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Log_File_Unable_To_Append_Unique_Timestamp_To_Log_File", ioe.getMessage(), logFileLocation));
                    }
                }
                IResource logResource = FileBasedResource.getRelativeResourceIfNotAbsolute(logFileLocation, this.fResource);
                LogFileUtilities.ensureLogFilePath(logResource.IResource_getLocation(), this.fFeedback);
                OutputStream resource = writer.IResourceWriter_getResource(logResource.IResource_getLocation());
                final DGCompilerLog synchLog = new DGCompilerLog(logFileLocation, baseLogFileName, resource, logResource.IResource_getLocation(), this.getLocalizer().IStringLocalizer_getLocalizedString("Introscope_AutoProbe_Long_Name"), this.getLocalizer(), this.getFeedback());
                AsynchCompilerLogWrapper asynchLog = new AsynchCompilerLogWrapper(synchLog, agent.IAgent_getSharedAsyncQueue());
                asynchLog.ICompilerLog_logHeader(this.getLocalizer().IStringLocalizer_getLocalizedString("Long_Copyright"), this.getVersion().IVersion_getReleaseAndBuildString(this.getLocalizer()), DGVersion.getVersionString());
                if (enableLogFileAutoNaming) {
                    new WaitAndExecuteBehavior(this.fAgent.IAgent_getCommonHeartbeat(), 30000L, "Check Connection for setup AutoProbe log negotiated name listener"){

                        protected boolean execute() {
                            IsengardServerConnectionManager m = AutoProbeTransformer.this.fAgent.IAgent_getIsengardServerConnection();
                            if (m != null && m.getConnectedServer() != null && m.getConnectedServer().isConnected()) {
                                AutoProbeTransformer.this.fAgent.IAgent_addNameChangeListener(synchLog);
                                AutoProbeTransformer.this.fAgent.IAgent_addNegotiatedNameChangeListener(synchLog);
                                return true;
                            }
                            return false;
                        }
                    };
                }
                this.getFeedback().info(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Log_File_Opened", logFileLocation));
                CompilerLogCollection finalLog = new CompilerLogCollection(asynchLog);
                if (this.fLogConfigurationProperty != null && this.fLogConfigurationProperty.equals("null")) {
                    return new NullCompilerLog();
                }
                return finalLog;
            }
            catch (ALocalizableException ale) {
                String location = logFileLocation == null ? logFileName : logFileLocation;
                String message = ale.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
                this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Log_Creation_Failure_Reason_Attached", location, message));
            }
            catch (Throwable t) {
                String location = logFileLocation == null ? logFileName : logFileLocation;
                this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Log_Creation_Failure_Reason_Attached", location, t.getMessage()));
                if (!this.getFeedback().isDebugEnabled()) break block10;
                this.getFeedback().debug(t);
            }
        }
        return new NullCompilerLog();
    }

    private String getLogFileName() {
        String logFileName = this.fProperties.getTrimmedProperty("introscope.autoprobe.logfile");
        if (logFileName == null || logFileName.equals("")) {
            this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Log_File_Not_Specified_Error"));
            return null;
        }
        return logFileName;
    }

    private final synchronized boolean loadDirectives(IDirectiveLoader loader) throws ClassFileTransformerShouldNotRunException, FileNotFoundException {
        return this.loadDirectivesHelper(loader, false);
    }

    private final synchronized boolean loadDirectivesHelper(IDirectiveLoader loader, boolean isStartingup) throws ClassFileTransformerShouldNotRunException, FileNotFoundException {
        boolean result = false;
        DGCompilerSettings newSettings = this.loadDirectives(loader, false, this.fLog, isStartingup);
        if (this.setCompilerSettings(newSettings)) {
            if (isStartingup) {
                try {
                    DGCompilerSettings newSettingsWithOpt = this.loadDirectives(loader, false, this.fLog, false);
                    if (!this.setCompilerSettings(newSettingsWithOpt)) {
                        this.getFeedback().error("Failed to load extensions bundles PBDs");
                    }
                }
                catch (Exception exception) {
                    this.getFeedback().error("Failed to load extensions bundles PBDs");
                }
            }
            result = true;
            if (this.fInstrumentationManager != null) {
                this.fInstrumentationManager.checkDirectivesNow();
            }
        } else {
            throw new ClassFileTransformerShouldNotRunException();
        }
        return result;
    }

    private final synchronized DGCompilerSettings loadDirectives(IDirectiveLoader loader, boolean onlyStatic, ICompilerLog log, boolean isStartingUp) throws ClassFileTransformerShouldNotRunException, FileNotFoundException {
        if (loader != null) {
            try {
                DirectivesFile requiredDirectives = this.getRequiredDirectivesFile();
                DirectivesFileList directives = new DirectivesFileList(this.getFeedback(), log, this.getLocalizer(), this.fPersonality);
                loader.loadDirectives(directives);
                directives.add(requiredDirectives);
                if (!onlyStatic) {
                    try {
                        this.addDynamicDirectives(directives);
                    }
                    catch (DirectivesException directivesException) {
                        this.getFeedback().warn("Cannot load permanent dynamic instrumentation");
                    }
                }
                if (!isStartingUp) {
                    this.loadExtensionDirectives(directives);
                }
                CompilerSettingsBuilder builder = new CompilerSettingsBuilder(this.getFeedback(), log, this.getLocalizer(), this.fPersonality);
                builder.setAutoProbeConfig(this);
                builder.setAgent(this.fAgent);
                directives.applyToSettings(builder, log);
                this.generateFileToLastModTimeMap(directives);
                builder.setInstrumentationInfo(this.getVersion().IVersion_getReleaseAndBuildString(this.getLocalizer()));
                builder.setIntelligentInstrumentationEnabled(this.fIntelligentInstrumentationEnabled);
                DGCompilerSettings compilerSettings = builder.generateSettings(log);
                this.currentLoadTimeStamp = new Date().getTime();
                this.notifyDirectiveLoadComplete();
                return compilerSettings;
            }
            catch (InvalidResourceException ire) {
                String message = ire.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
                this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Directives_Files_Loading_Error", message));
                throw new ClassFileTransformerShouldNotRunException();
            }
            catch (FileNotFoundException fnf) {
                this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Directives_Files_Loading_Error", fnf.getMessage()));
                this.getFeedback().debug(fnf);
                throw fnf;
            }
            catch (IOException ioe) {
                this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Directives_Files_Loading_Error", ioe.getMessage()));
                throw new ClassFileTransformerShouldNotRunException();
            }
            catch (DGParserException dgpe) {
                String message = dgpe.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
                log.ICompilerLog_logInvalidSettings("1 " + message);
                this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Invalid_Directives_Error", message));
                throw new ClassFileTransformerShouldNotRunException();
            }
            catch (DirectivesException de) {
                String message = de.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
                log.ICompilerLog_logInvalidSettings("2 " + message);
                String msg = this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Invalid_Directives_Error", message);
                this.getFeedback().error(msg);
                this.getFeedback().debug(msg, de);
                throw new ClassFileTransformerShouldNotRunException();
            }
            catch (ValidationException ve) {
                String message = ve.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
                log.ICompilerLog_logInvalidSettings("3 " + message);
                this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Invalid_Directives_Error", message));
                throw new ClassFileTransformerShouldNotRunException();
            }
            catch (ALocalizableException e) {
                String message = e.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
                log.ICompilerLog_logInvalidSettings("3 " + message);
                this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Invalid_Directives_Error", message));
                throw new ClassFileTransformerShouldNotRunException();
            }
        }
        return null;
    }

    private void loadExtensionDirectives(DirectivesFileList directives) throws DGParserException, DirectivesException, IOException {
        OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
        if (oem == null) {
            return;
        }
        HashSet<String> extensions = this.fExtensionPBDs;
        if (this.fExtensionPBDs == null) {
            extensions = oem.calculateExtensionPBDsDuringLoad();
        }
        ExtendedFile extFolder = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionDirectory();
        String extFolderPath = null;
        if (extFolder != null) {
            extFolderPath = extFolder.getAbsolutePath();
        }
        for (String ext : extensions) {
            try {
                StringBuffer extBuf = new StringBuffer();
                extBuf.append(extFolderPath);
                extBuf.append("/");
                extBuf.append(ext);
                extBuf.append("/");
                extBuf.append("directives");
                directives.add(extBuf.toString());
            }
            catch (DirectivesDirectoryException directivesDirectoryException) {
            }
            catch (FileNotFoundException fnf) {
                oem.addExtensionWithError(ext);
                throw fnf;
            }
            catch (DGParserException e) {
                oem.addExtensionWithError(ext);
                throw e;
            }
            catch (DirectivesException e) {
                oem.addExtensionWithError(ext);
                throw e;
            }
            catch (IOException e) {
                oem.addExtensionWithError(ext);
                throw e;
            }
        }
    }

    private void addDynamicDirectives(final DirectivesFileList directives) throws ALocalizableException, IOException {
        DynamicDirectivesResult dynResult;
        if (this.fDynamicDirectivesService != null && (dynResult = this.fDynamicDirectivesService.addDynamicDirectiveCollection(this.getDynamicInstrumentationService(), this.fPersonality.getClassSchemaPolicy(), new IDynamicDirectivesServiceCallback(){

            public void addToCollection(String directiveLocationOrFile) throws ALocalizableException, IOException {
                directives.add(directiveLocationOrFile);
            }

            public Collection getCollection() {
                return directives;
            }
        }, this.fFeedback)).isError()) {
            this.getFeedback().error(dynResult.getException().getLocalizedMessage());
        }
    }

    private void exportDynamicDirectiveFiles(IExportDirectiveCallback callback) throws ALocalizableException, IOException, ValidationException {
        DirectivesFileList directivesList = new DirectivesFileList(this.getFeedback(), this.fLog, this.getLocalizer(), this.fPersonality);
        this.addDynamicDirectives(directivesList);
        DirectivesFile[] file = directivesList.toArray(new DirectivesFile[0]);
        int i = 0;
        while (i < file.length) {
            Iterator directives = file[i].getDirectives();
            while (directives.hasNext()) {
                IDirective directive = (IDirective)directives.next();
                if (!(directive instanceof IExportableDirective)) continue;
                ((IExportableDirective)directive).IExportableDirective_export(callback);
            }
            ++i;
        }
    }

    private DirectivesFile getRequiredDirectivesFile() throws DGParserException, IOException, ClassFileTransformerShouldNotRunException {
        DirectivesFile requiredDirectives = InternalDirectivesLoader.loadRequiredDirectives(this.fPersonality);
        if (requiredDirectives == null) {
            this.getFeedback().error(this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Required_Directives_File_Does_Not_Exist_Error"));
            throw new ClassFileTransformerShouldNotRunException();
        }
        return requiredDirectives;
    }

    private void generateFileToLastModTimeMap(DirectivesFileList directives) {
        String[] directiveFileNameList = this.getFileNames(directives);
        this.fFileToLastModTimeMap = new ConcurrentHashMap<File, Long>(40, 0.75f, 4);
        int i = 0;
        while (i < directiveFileNameList.length) {
            File f = new File(directiveFileNameList[i]);
            if (f.exists()) {
                long ts = f.lastModified();
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("Put File::Timestamp into map: " + f + "::" + ts);
                }
                this.fFileToLastModTimeMap.put(f, new Long(ts));
            } else {
                this.fFileToLastModTimeMap.put(f, new Long(-1L));
            }
            ++i;
        }
        String[] directiveFolderNameList = this.fLoader.getDirectiveFiles();
        int i2 = 0;
        while (i2 < directiveFolderNameList.length) {
            File f = new File(directiveFolderNameList[i2]);
            if (f.exists() && f.isDirectory()) {
                long ts = f.lastModified();
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("Put Folder::Timestamp into map: " + f + "::" + ts);
                }
                this.fFileToLastModTimeMap.put(f, new Long(ts));
            }
            ++i2;
        }
    }

    private String[] getFileNames(DirectivesFileList directivesFileList) {
        HashSet<String> h = new HashSet<String>();
        for (Object o : directivesFileList) {
            String name;
            if (o instanceof DirectivesListFile) {
                DirectivesListFile dlf = (DirectivesListFile)o;
                String directiveFileListName = name = dlf.getLocation();
                h.add(name);
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("load directives: found directives list file = " + name);
                }
                Iterator iterator2 = dlf.getDirectiveFiles();
                while (iterator2.hasNext()) {
                    DirectivesFile curFile = (DirectivesFile)iterator2.next();
                    name = curFile.getName();
                    h.add(name);
                    if (!this.fFeedback.isDebugEnabled()) continue;
                    this.fFeedback.debug("load directives: found directives file = " + name + " specified in directives list file " + directiveFileListName);
                }
                continue;
            }
            if (o instanceof DirectivesFile) {
                DirectivesFile curFile = (DirectivesFile)o;
                name = curFile.getName();
                h.add(name);
                if (!this.fFeedback.isDebugEnabled()) continue;
                this.fFeedback.debug("load directives: found directives file = " + name);
                continue;
            }
            if (!this.fFeedback.isDebugEnabled()) continue;
            this.fFeedback.debug("load directives: found unexpected directives element = " + o);
        }
        String[] names = h.toArray(new String[0]);
        return names;
    }

    private final String[] parseFileList(String list) {
        ArrayList<String> files = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, kListSeparator);
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            name = name.trim();
            files.add(name);
        }
        String[] result = new String[files.size()];
        files.toArray(result);
        this.makePaths(result, this.fResource);
        return result;
    }

    private void makePaths(String[] relativePaths, IResource resource) {
        if (resource.IResource_isFileResource()) {
            int i = 0;
            while (i < relativePaths.length) {
                File pathFile = new File(relativePaths[i]);
                if (!pathFile.isAbsolute()) {
                    String newPath;
                    IResource newResource = FileBasedResource.getRelativeResource(relativePaths[i], resource);
                    relativePaths[i] = newPath = newResource.IResource_getLocation();
                }
                ++i;
            }
        }
    }

    private IndexedProperties loadProfilePropertiesFromPropertyFile() throws IllegalStateException {
        if (this.fResource != null) {
            IndexedProperties candidateProperties = null;
            try {
                candidateProperties = new IndexedProperties();
                this.fAgentPropFileLastModTime = this.fAgentPropFile.lastModified();
                candidateProperties.load(this.fResource.IResource_getContents());
            }
            catch (IOException ioe) {
                this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Agent_Profile_Loading_Error", ioe.toString()));
                this.getFeedback().verbose(ioe);
                throw new IllegalStateException(ioe.getMessage());
            }
            catch (RuntimeException re) {
                this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Agent_Profile_Loading_Error", re.toString()));
                this.getFeedback().verbose(re);
                throw new IllegalStateException(re.getMessage());
            }
            return candidateProperties;
        }
        throw new IllegalStateException("there is no Agent property file to load from");
    }

    @Override
    public final byte[] transform(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classBytes) throws IllegalClassFormatException {
        ThreadLocalClassHelper.setInstrumentedClass(classBeingRedefined, loader);
        ThreadLocalClassHelper.setInstrumentationHelper(this.getClassRedefinitionDelegate());
        byte[] result = null;
        if (this.filterBootstrap(classLoaderIsAvailable, loader, className)) {
            if (this.fLogSkippedClasses) {
                this.fLog.ICompilerLog_logSkippedBootstrapClass(className);
            }
            return null;
        }
        if (className == null) {
            if (this.filterUnnamedClasses(className)) {
                return null;
            }
            className = this.fUnnamedClassPlaceholder;
        } else if (this.filterCompilerSettingFilter(className)) {
            if (this.fLogSkippedClasses) {
                this.fLog.ICompilerLog_logSkippedClass(className);
            }
            return null;
        }
        this.fLog.ICompilerLog_logClassTraced(className);
        IClassCompiler compiler = this.fPersonality.newClassCompiler(this.getCompilerSettings(), this.fLog);
        result = this.transform(className, classBytes, compiler);
        ThreadLocalClassHelper.unsetInstrumentedClass();
        return result;
    }

    private boolean filterCompilerSettingFilter(String className) {
        if (this.getCompilerSettings().getFilter().shouldSkip(className)) {
            if (this.fLog.ICompilerLog_isLogDynamicInstrEnabled()) {
                this.fLog.ICompilerLog_logSkippedClass(className);
            }
            return true;
        }
        return false;
    }

    private boolean filterUnnamedClasses(String className) {
        if (this.fSkipUnnamedClasses) {
            if (this.fLog.ICompilerLog_isLogDynamicInstrEnabled()) {
                CompilerLogDetails.logImmediately(this.fLog, "<Empty class name>", null, "Skipping class with null name", 524488);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setAgentClassLoader(ClassLoader agentClassLoader) {
        this.fAgentClassLoader = agentClassLoader;
    }

    private boolean filterBootstrap(boolean classLoaderIsAvailable, ClassLoader loader, String className) {
        if (classLoaderIsAvailable && (loader == null || this.fAgentClassLoader != null && this.fAgentClassLoader == loader)) {
            if (this.fLog.ICompilerLog_isLogDynamicInstrEnabled()) {
                CompilerLogDetails.logImmediately(this.fLog, className, null, "Skipping bootstrap class", 524488);
            }
            return true;
        }
        return false;
    }

    @Override
    public final byte[] transform(String className, byte[] classBytes, IClassCompiler compiler) {
        try {
            return compiler.compileOneClass(className, classBytes);
        }
        catch (DGClassLoadingException dgcle) {
            this.logException(className, dgcle);
            String message = dgcle.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
            this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Exception_While_Instrumenting_Error", className, message));
            this.dumpClassFile(className, classBytes);
        }
        catch (DGClassException dgce) {
            this.logException(className, dgce);
            String message = dgce.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer());
            this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Exception_While_Instrumenting_Error", className, message));
            this.dumpClassFile(className, classBytes);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.logException(className, t);
            this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Exception_While_Instrumenting_Error", className, t.getMessage()));
            this.getFeedback().error(t);
            this.dumpClassFile(className, classBytes);
        }
        return null;
    }

    public void dumpClassFile(String className, byte[] classBytes) {
        String pathPrefix = System.getProperty("introscope.agent.instrumentation.debugdump.path");
        if (pathPrefix != null) {
            File debugFile = new File(String.valueOf(pathPrefix) + className.replace('/', '.') + "." + System.currentTimeMillis() + "before.class");
            try {
                FileOutputStream stream = new FileOutputStream(debugFile);
                stream.write(classBytes);
                stream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public byte[] transform(IModeledClass modeledClass, IModeledMethod modeledMethod, byte[] methodBytes, Object contextCallback) throws IllegalClassFormatException {
        if (this.getCompilerSettings().getFilter().shouldSkip(modeledClass) || this.getCompilerSettings().getFilter().shouldSkip(modeledMethod) || this.getCompilerSettings().getFilter().shouldSkip(modeledClass, modeledMethod)) {
            this.fLog.ICompilerLog_logSkippedMethod(modeledClass.getClassName(), modeledMethod.getMethodName());
            return null;
        }
        IMethodCompiler compiler = this.fPersonality.newMethodCompiler(this.getCompilerSettings(), this.fLog, this.getFeedback(), this.getLocalizer(), contextCallback);
        return compiler.compileOneMethod(modeledClass, modeledMethod, this.fMethodCompilerSettingsCache, methodBytes);
    }

    private final void logException(String className, Throwable t) {
        this.fLog.ICompilerLog_logException(className, t);
    }

    private void registerDirectivesCheckBehavior() {
        if (this.fHeartbeat != null) {
            long defaultPeriod = 60000L;
            long period = this.fProperties.getLongProperty("introscope.autoprobe.directives.checkperiod", defaultPeriod);
            this.fDirCheckRegisteredBehavior = this.fHeartbeat.addBehavior((ITimestampedRunnable)this.fDirCheckBehavior, kDirectivesCheckBehaviorName, true, period, false);
            if (this.getFeedback().isDebugEnabled()) {
                this.getFeedback().debug("AutoProbeTransformer: registered directives check behavior");
            }
        }
    }

    @Override
    public ICompilerLog getCompilerLog() {
        return this.fLog;
    }

    @Override
    public DGCompilerSettings getCompilerSettings() {
        return this.fCompilerSettings;
    }

    @Override
    public synchronized boolean setDGCompilerSettings(DGCompilerSettings oldSettings, DGCompilerSettings newSettings) {
        if (oldSettings == this.fCompilerSettings) {
            this.setCompilerSettings(newSettings);
            return true;
        }
        this.getFeedback().warn(sModule, "While trying to update compiler settings, the agent detected that the settings have changed.");
        return false;
    }

    @Override
    public void setInstrumentation(Object instrumentation, OnInstrumentationAcceptedCallback callback) {
        if (!PlatformCheckUtil.getInstance().isOsgiEnvironment()) {
            AutoProbeExtensionLoader pbExtLoader = new AutoProbeExtensionLoader(this.fAgent, this, instrumentation);
            List loadedPlugins = pbExtLoader.loadAllExtensions();
            for (Object plugin : loadedPlugins) {
                if (plugin != null && plugin instanceof IBootstrapTransformer) {
                    this.bt = (IBootstrapTransformer)plugin;
                }
                if (!(plugin instanceof IDynamicInstrumentationManager)) continue;
                this.fInstrumentationManager = (IDynamicInstrumentationManager)plugin;
            }
        }
        if (callback != null) {
            callback.onInstrumentationAccepted(this);
        }
    }

    private synchronized boolean setCompilerSettings(DGCompilerSettings compilerSettings) {
        if (this.fCompilerSettings != null) {
            try {
                compilerSettings = compilerSettings.validateReloadedSettings(this.getFeedback(), this.getLocalizer(), this.fCompilerSettings);
            }
            catch (UnsupportedDGCompilerSettingModificationException unsupportedDGCompilerSettingModificationException) {
                this.getFeedback().info(this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Illegal_Directive_Refresh_Info"));
                compilerSettings = this.fCompilerSettings;
                return false;
            }
        }
        this.fCompilerSettings = compilerSettings;
        this.fMethodCompilerSettingsCache.getMethodSpanningCache().invalidateMethodSpanningCache();
        this.getFeedback().info(this.getLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Directives_Reloaded"));
        return true;
    }

    @Override
    public void addCompilerLog(ICompilerLog additionalLog) {
        this.fFeedback.info("Trying to add additional compiler log: " + additionalLog.getClass().getName());
        if (this.fLog != null && this.fLog instanceof CompilerLogCollection) {
            try {
                AsynchExecutionQueue databaseLogQueue = new AsynchExecutionQueue("Database Log Thread", this.getFeedback(), this.getLocalizer(), this.fAgent.IAgent_getAgentThreadFactory(), true);
                AsynchCompilerLogWrapper wrapper = new AsynchCompilerLogWrapper(additionalLog, databaseLogQueue);
                ((CompilerLogCollection)this.fLog).addDelegate(wrapper);
                this.fFeedback.info("Additional compiler log " + additionalLog.getClass().getName() + " added");
            }
            catch (Exception e) {
                this.getFeedback().error(e);
                this.fFeedback.error("Error trying to add additional compiler log: ", e);
            }
        } else {
            this.fFeedback.warn("Cannot add additional compiler log: " + additionalLog.getClass().getName());
        }
    }

    @Override
    public synchronized void setClassRedefinitionDelegate(IClassRedefinitionDelegate instrumentationDelegate) {
        if (this.fClassRedefinitionDelegate == null) {
            this.fClassRedefinitionDelegate = instrumentationDelegate;
        } else {
            this.fFeedback.warn("Trying to add Dynamic Instumentation Delegate when it is already present");
        }
    }

    @Override
    public boolean redefineClassTree(IClassName className, IClassRedefinitionCallback callback, boolean shouldWarnOnFailure) {
        return this.redefineClass(className, callback, true, shouldWarnOnFailure);
    }

    @Override
    public boolean redefineClass(IClassName className, IClassRedefinitionCallback callback) {
        return this.redefineClass(className, callback, false, false);
    }

    private boolean redefineClass(IClassName className, IClassRedefinitionCallback callback, boolean isTree, boolean shouldWarnOnFailure) {
        boolean result = false;
        if (this.fClassRedefinitionDelegate != null) {
            block10: {
                ThreadLocalClassHelper.setInstrumentationHelper(this.fClassRedefinitionDelegate);
                try {
                    result = this.loadDirectives(this.fLoader);
                    if (!result) break block10;
                    try {
                        if (isTree) {
                            result = this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_redefineTree(className, callback, shouldWarnOnFailure);
                            break block10;
                        }
                        result = this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_redefine(className, callback);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        result = true;
                    }
                    catch (Throwable t) {
                        this.getFeedback().error("Unable to redefine class " + className);
                        this.getFeedback().trace(new Module("AutoProbeTransformer"), "Unable to redefine class " + className, t);
                        result = false;
                    }
                }
                catch (FileNotFoundException e) {
                    this.getFeedback().error("Unable to redefine class " + className);
                    this.getFeedback().trace(new Module("AutoProbeTransformer"), "Unable to redefine class " + className, e);
                    result = false;
                }
                catch (ClassFileTransformerShouldNotRunException e) {
                    this.getFeedback().error("Unable to apply Class Redefintion");
                    this.getFeedback().trace(new Module("AutoProbeTransformer"), "Unable to apply Class Redefintion", e);
                    result = false;
                }
            }
            ThreadLocalClassHelper.setInstrumentationHelper(null);
        } else {
            this.getFeedback().info("Class Redefinition delegate is null");
        }
        if (result) {
            this.fLog.ICompilerLog_suggestFlush();
        }
        return result;
    }

    @Override
    public void setDynamicDirectivesService(IDynamicDirectivesService service) {
        try {
            if (service instanceof IExportDirectiveCallback) {
                this.exportDynamicDirectiveFiles((IExportDirectiveCallback)((Object)service));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fDynamicDirectivesService = service;
    }

    @Override
    public IDynamicInstrumentationService getDynamicInstrumentationService() {
        return this.fDynamicInstrumentationService;
    }

    @Override
    public void setDynamicInstrumentationService(IDynamicInstrumentationService service) {
        this.fDynamicInstrumentationService = service;
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAsynchronously(int batchInterval, int batchAmount) {
        return this.IClassRedefinitionDelegate_redefineAsynchronously(batchInterval, batchAmount, kEmptyCallback);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAsynchronously(int batchInterval, int batchAmount, IClassRedefinitionCallback callback) {
        boolean result;
        block8: {
            result = false;
            if (this.fClassRedefinitionDelegate != null) {
                try {
                    result = this.loadDirectives(this.fLoader);
                    if (!result) break block8;
                    try {
                        result = batchInterval > 0 && batchAmount > 0 ? this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_redefineAllAsynchronously(batchInterval, batchAmount) : this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_redefineAllAsynchronously(null);
                    }
                    catch (Throwable t) {
                        this.getFeedback().error("Unable to apply Dynamic Instrumentation for all class ");
                        t.printStackTrace();
                        result = false;
                    }
                }
                catch (FileNotFoundException e) {
                    this.getFeedback().error("Unable to apply Dynamic Instrumentation");
                    this.fFeedback.error(e);
                    result = false;
                }
                catch (ClassFileTransformerShouldNotRunException e) {
                    this.getFeedback().error("Unable to apply Dynamic Instrumentation");
                    this.fFeedback.error(e);
                    result = false;
                }
            } else {
                this.getFeedback().info("Dynamic Instrumentation delegate is null");
            }
        }
        if (result) {
            this.fLog.ICompilerLog_suggestFlush();
        }
        return result;
    }

    @Override
    public boolean redefineAll() {
        return this.redefineAll(kEmptyCallback);
    }

    @Override
    public boolean redefineAll(IClassRedefinitionCallback callback) {
        boolean result = false;
        if (this.fClassRedefinitionDelegate != null) {
            ThreadLocalClassHelper.setInstrumentationHelper(this.fClassRedefinitionDelegate);
            try {
                result = this.loadDirectives(this.fLoader);
                if (result) {
                    try {
                        result = this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_redefineAll(callback);
                    }
                    catch (Throwable t) {
                        this.getFeedback().error("Unable to apply Dynamic Instrumentation for all class ");
                        t.printStackTrace();
                        result = false;
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.getFeedback().error("Unable to apply Dynamic Instrumentation");
                this.fFeedback.error(e);
                result = false;
            }
            catch (ClassFileTransformerShouldNotRunException e) {
                this.getFeedback().error("Unable to apply Dynamic Instrumentation");
                this.fFeedback.error(e);
                result = false;
            }
            ThreadLocalClassHelper.setInstrumentationHelper(null);
        } else {
            this.getFeedback().info("Dynamic Instrumentation delegate is null");
        }
        if (result) {
            this.fLog.ICompilerLog_suggestFlush();
        }
        return result;
    }

    @Override
    public boolean redefineGroup(IRedefinitionCallback completionCallback, String group, IClassRedefinitionCallback callback) {
        boolean result = false;
        if (this.fClassRedefinitionDelegate != null) {
            block9: {
                ThreadLocalClassHelper.setInstrumentationHelper(this.fClassRedefinitionDelegate);
                try {
                    result = this.loadDirectives(this.fLoader);
                    if (!result) break block9;
                    try {
                        final TracerGroup tracerGroup = this.getCompilerSettings().getTracerGroup(group);
                        if (tracerGroup != null) {
                            IClassRedefinitionDelegate.IRedefinedClassRepository rep = new IClassRedefinitionDelegate.IRedefinedClassRepository(){
                                Class[] filteredClasses;

                                public Class[] getAllClassInVM() {
                                    if (this.filteredClasses == null) {
                                        HashSet<Class> target = new HashSet<Class>();
                                        Class[] classes = AutoProbeTransformer.this.fClassRedefinitionDelegate.getRedefinableClassRepository().getAllClassInVM();
                                        int i = 0;
                                        while (i < classes.length) {
                                            Class c = classes[i];
                                            try {
                                                if (tracerGroup.getClassMatcher().IClassMatcher_matches(ClassName.getClassName(c.getName()))) {
                                                    target.add(c);
                                                    int j = 0;
                                                    while (j < classes.length) {
                                                        if (c.isAssignableFrom(classes[j])) {
                                                            target.add(classes[j]);
                                                        }
                                                        ++j;
                                                    }
                                                }
                                            }
                                            catch (InvalidClassNameException invalidClassNameException) {}
                                            ++i;
                                        }
                                        this.filteredClasses = target.toArray(new Class[0]);
                                    }
                                    return this.filteredClasses;
                                }
                            };
                            result = this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_redefineAllAsynchronously(completionCallback, rep, callback);
                            break block9;
                        }
                        this.getFeedback().error("Cannot find tracer group " + group);
                        result = false;
                    }
                    catch (Throwable t) {
                        this.getFeedback().error("Unable to apply Dynamic Instrumentation for all class ");
                        t.printStackTrace();
                        result = false;
                    }
                }
                catch (FileNotFoundException e) {
                    this.getFeedback().error("Unable to apply Dynamic Instrumentation");
                    this.fFeedback.error(e);
                    result = false;
                }
                catch (ClassFileTransformerShouldNotRunException e) {
                    this.getFeedback().error("Unable to apply Dynamic Instrumentation");
                    this.fFeedback.error(e);
                    result = false;
                }
            }
            ThreadLocalClassHelper.setInstrumentationHelper(null);
        } else {
            this.getFeedback().info("Dynamic Instrumentation delegate is null");
        }
        if (result) {
            this.fLog.ICompilerLog_suggestFlush();
        }
        return result;
    }

    @Override
    public IDynamicInstrumentationFilter getDynamicInstrumentationFilter() {
        return this.fFilter;
    }

    private boolean filterRedefine(String className, boolean classLoaderIsAvailable, ClassLoader loader, boolean log) {
        return this.filterBootstrap(classLoaderIsAvailable, loader, className) || this.filterBasedOnClassName(className);
    }

    private boolean filterBasedOnClassName(String className) {
        return className == null && this.filterUnnamedClasses(className) || className != null && this.filterArrayClasses(className) || className != null && this.filterCompilerSettingFilter(className);
    }

    private boolean filterArrayClasses(String className) {
        return className.startsWith("[");
    }

    @Override
    public boolean canRedefine(Class cls) {
        String reflectionFriendlyClassName = cls.getName();
        ClassLoader loader = cls.getClassLoader();
        if (this.fClassLoaderVerifier.verify(loader)) {
            boolean classLoaderIsAvailable = true;
            return this.getCompilerSettings().getFilter().shouldInstrument(reflectionFriendlyClassName) || !this.filterRedefine(reflectionFriendlyClassName, classLoaderIsAvailable, loader, false);
        }
        return false;
    }

    public boolean isSkippedByNormalInstrumentation(String className) {
        return this.filterBasedOnClassName(className);
    }

    public boolean isSkippedByIntellionigentInstrumentat(String className) {
        return this.fCompilerSettings.getFilter().shouldSkipIntelligentInstrumentation(className);
    }

    public ArrayList filterInstrumentedMethods(IModeledClass modeledClass, ArrayList modeledMethods) {
        ArrayList methodsToInstrument = new ArrayList();
        ClassSettingsApplier csa = new ClassSettingsApplier(this.fCompilerSettings, this.fLog, modeledClass, null);
        methodsToInstrument = csa.filterMethodsInstrumentedByNormalTracer(modeledMethods);
        return methodsToInstrument;
    }

    @Override
    public Class[] getInstrumentedClasses() {
        return new Class[0];
    }

    @Override
    public void deactivate() {
        this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_deactivate();
        this.redefineAll();
    }

    @Override
    public void addDynamicInstrumentationFilter(IDynamicInstrumentationFilter newFilter) {
        this.fFilter = newFilter;
    }

    @Override
    public IClassRedefinitionDelegate getClassRedefinitionDelegate() {
        return this.fClassRedefinitionDelegate;
    }

    @Override
    public boolean isLikelyToChangeIfRedefined(Class cls) {
        try {
            return this.getCompilerSettings().isLikelyToChange(this.getCompilerLog(), cls);
        }
        catch (InvalidClassNameException invalidClassNameException) {
            return true;
        }
    }

    @Override
    public boolean hasTracers(Class cls) {
        try {
            return this.getCompilerSettings().hasTracers(this.getCompilerLog(), cls);
        }
        catch (InvalidClassNameException invalidClassNameException) {
            return false;
        }
    }

    @Override
    public boolean hasTracers(IModeledClass cls, IModeledMethod m) {
        try {
            boolean result = this.getCompilerSettings().hasTracers(this.getCompilerLog(), cls, m);
            if (this.fIntelligentInstrumentationService != null && !result) {
                result = this.fIntelligentInstrumentationService.isMethodTraced(cls, m);
            }
            return result;
        }
        catch (InvalidClassNameException invalidClassNameException) {
            return false;
        }
    }

    @Override
    public IClassRedefinitionDelegate.IRedefinedClassRepository getClasses() {
        return this.fClassRedefinitionDelegate.getRedefinableClassRepository();
    }

    @Override
    public IAgent getAgent() {
        return this.fAgent;
    }

    @Override
    public long getMostRecentLoadTimeStamp() {
        return this.currentLoadTimeStamp;
    }

    public static String[] getDirectivesFileList() {
        return allDirectivesFileList;
    }

    @Override
    public boolean initializeDynamicInstrumentation() {
        IClassRedefinitionDelegate.IRedefinedClassRepository classesWithTracers = this.fClassRedefinitionDelegate.getRedefinableTracedClassRepository();
        return this.fClassRedefinitionDelegate.IClassRedefinitionDelegate_redefineAll(classesWithTracers);
    }

    @Override
    public void getDynamicInstrumentationPBD(IDynamicInstrumentationListener listener, String label, boolean permanentOnly) {
        if (this.fLoader != null && this.fDynamicDirectivesService != null) {
            this.fDynamicDirectivesService.getDynamicInstrumentationPBD(listener, label, permanentOnly, this.getDynamicInstrumentationService(), this.fPersonality.getClassSchemaPolicy(), this.fFeedback);
        } else {
            DynamicDirectivesResult result = new DynamicDirectivesResult(106);
            result.setException(new Exception("Cannot load directives; unable to check dynamic instrumentation"));
            listener.deliverResult(result);
        }
    }

    @Override
    public boolean checkDynamicInstrumentationDirective(int directiveId, DynamicInstrumentationResult target) {
        ArrayList<Throwable> result;
        block11: {
            result = new ArrayList<Throwable>();
            if (this.fLoader != null && this.fDynamicDirectivesService != null) {
                try {
                    final DirectivesFileList directives = new DirectivesFileList(this.getFeedback(), this.fLog, this.getLocalizer(), this.fPersonality);
                    DynamicDirectivesResult dynResult = this.fDynamicDirectivesService.addDynamicInstrumentationDirective(directiveId, this.getDynamicInstrumentationService(), this.fPersonality.getClassSchemaPolicy(), new IDynamicDirectivesServiceCallback(){

                        public void addToCollection(String directiveLocationOrFile) throws ALocalizableException, IOException {
                            directives.add(directiveLocationOrFile);
                        }

                        public Collection getCollection() {
                            return directives;
                        }
                    }, this.fFeedback);
                    if (!dynResult.isError()) {
                        DirectivesFile requiredDirectives = this.getRequiredDirectivesFile();
                        this.fLoader.loadDirectives(directives);
                        directives.add(requiredDirectives);
                        CompilerSettingsBuilder builder = new CompilerSettingsBuilder(this.getFeedback(), this.fLog, this.getLocalizer(), this.fPersonality);
                        directives.applyToSettings(builder, this.fLog);
                        builder.validate();
                        break block11;
                    }
                    result.add(dynResult.getException());
                }
                catch (DGParserException e) {
                    result.add(e);
                }
                catch (IOException e) {
                    result.add(e);
                }
                catch (ClassFileTransformerShouldNotRunException e) {
                    result.add(e);
                }
                catch (InvalidResourceException e) {
                    result.add(e);
                }
                catch (DirectivesException e) {
                    result.add(e);
                }
                catch (ValidationException e) {
                    result.add(new Exception(e.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getLocalizer())));
                }
            } else {
                result.add(new Exception("Cannot load directives; unable to check dynamic instrumentation"));
            }
        }
        if (result.size() > 0) {
            target.setException((Throwable)result.get(0));
        }
        return result.size() == 0;
    }

    @Override
    public IDynamicDirectivesService getDynamicDirectivesService() {
        return this.fDynamicDirectivesService;
    }

    @Override
    public ITracerProviderService getTracerProviderService() {
        return this;
    }

    @Override
    public boolean canRedefine(IModeledClass cls, IModeledMethod m) {
        return !this.filterBasedOnClassName(cls.getClassName().getReflectionFriendlyQualifiedNameString()) && !this.getCompilerSettings().getFilter().shouldSkip(cls, m, false);
    }

    private void setCodeIntrospectionService(ICodeIntrospectionService codeIntrospectionService) {
        this.fCodeIntrospectionService = codeIntrospectionService;
    }

    @Override
    public ICodeIntrospectionService getCodeIntrospectionService() {
        return this.fCodeIntrospectionService;
    }

    @Override
    public int getDynamicInstrumentationStatusCode(boolean forceRecomputation) {
        boolean isTraceEnabled = this.getFeedback().isTraceEnabled(sModule);
        int statusFromService = -1;
        if (this.fDynamicInstrumentationService != null) {
            statusFromService = this.fDynamicInstrumentationService.getDynamicInstrumentationStatusCode(forceRecomputation);
            if (isTraceEnabled) {
                this.getFeedback().trace("Dynamic Instrumentation status from delegate is " + statusFromService);
            }
            if (statusFromService == -1 && this.fDynamicInstrumentationService.isEnabled()) {
                statusFromService = 1;
                Iterator i = this.getCompilerSettings().getTracersIterator();
                while (i.hasNext()) {
                    MethodTracer tracer = (MethodTracer)i.next();
                    String tracerParameters = tracer.getTracerParameters();
                    if (tracerParameters.indexOf(kMethodTracerParameterLabelValue) < 0 || tracerParameters.indexOf(kMethodTracerParameterTemporaryValue) < 0) continue;
                    if (isTraceEnabled) {
                        this.getFeedback().trace("Dynamic Instrumentation status from autoprobe is " + (statusFromService + 2 + 4));
                    }
                    return statusFromService + 2 + 4;
                }
            }
        }
        return statusFromService;
    }

    @Override
    public Map getStaticGroups() {
        Map result = new HashMap();
        try {
            result = this.loadDirectives(this.fLoader, true, new NullCompilerLog(), false).getGroupInstrumentableMap();
        }
        catch (ClassFileTransformerShouldNotRunException classFileTransformerShouldNotRunException) {
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return result;
    }

    @Override
    public TracerEncoding getTracerEncoding(IModeledMethod modeledMethod) {
        RecordingMethodMutator mutator = new RecordingMethodMutator();
        try {
            this.getCompilerLog().ICompilerLog_setCurrentMethod(modeledMethod.getModeledClass().getClassName(), modeledMethod.getMethodName());
            new MethodSettingsApplier(this.getCompilerSettings(), this.getCompilerLog(), this.fMethodCompilerSettingsCache.getMethodSpanningCache(), modeledMethod, mutator).apply();
            return mutator.getTracerEncoding();
        }
        catch (DGClassModificationException dGClassModificationException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private List initializeBootstrapClasses() {
        new Socket();
        ArrayList<ClassName> result = new ArrayList<ClassName>();
        List classesToRedefine = this.getCompilerSettings().getFilter().getInstrumentableBootstrapClassesPremain();
        if (classesToRedefine != null) {
            for (String fullyQualifiedName : classesToRedefine) {
                try {
                    ClassName className = ClassName.getClassName(fullyQualifiedName);
                    Class.forName(className.getReflectionFriendlyQualifiedNameString());
                    if (this.fFeedback.isDebugEnabled()) {
                        this.fFeedback.debug(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString(kBootstrapClassLoaded, fullyQualifiedName));
                    }
                    result.add(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.fFeedback.debug(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString(kBootstrapClassInstrumentationNameNotValid, fullyQualifiedName));
                }
                catch (InvalidClassNameException invalidClassNameException) {
                    this.fFeedback.debug(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString(kBootstrapClassInstrumentationNameNotValid, fullyQualifiedName));
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    this.fFeedback.debug(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString(kBootstrapClassNotFound, fullyQualifiedName));
                }
                catch (Throwable e) {
                    this.fFeedback.debug(sModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString(kBootstrapGenericError, fullyQualifiedName), e);
                }
            }
        }
        return result;
    }

    @Override
    public void executeBootstrapTransform() {
        if (this.bt != null) {
            this.bt.executePremainTransform(this.getAgent(), this);
        } else {
            this.getFeedback().warn(sModule, "Unable to execute Bootstrap Transformation. A suitable plugin has not been loaded");
        }
    }

    @Override
    public void addClassloaderVerifier(IClassLoaderVerifier c) {
        if (c != null) {
            this.fClassLoaderVerifier = c;
        }
    }

    @Override
    public void registerDirectiveLoadListener(IDirectiveLoadListener directiveLoadListener) {
        this.fDirectiveLoadListeners.add(directiveLoadListener);
    }

    @Override
    public boolean verify(ClassLoader loader) {
        return true;
    }

    @Override
    public String getName() {
        return "AutoProbe Transformer";
    }

    private IDirectiveLoader[] getOSGiLoaderExtensions(final IAgent agent, final String[] directivesFiles) {
        final ArrayList result = new ArrayList();
        PluginLoader.loadPlugins("com.wily.introscope.probebuilder.directiveloader", new IPluginLoaderCallback(){

            public void onExtensionFound(Object configurationElement, Object elementInstance) {
                if (elementInstance instanceof ADirectiveLoader) {
                    try {
                        Constructor<?> c = elementInstance.getClass().getConstructor(kParameterTypeList);
                        Object[] objectArray = new Object[6];
                        objectArray[0] = agent;
                        objectArray[1] = agent.IAgent_getStringLocalizer();
                        objectArray[2] = AutoProbeTransformer.this.fResource.IResource_getResourceReader();
                        objectArray[4] = directivesFiles;
                        objectArray[5] = AutoProbeTransformer.this.fPersonality;
                        Object[] args = objectArray;
                        Object directiveLoader = c.newInstance(args);
                        result.add(directiveLoader);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return result.toArray(new IDirectiveLoader[0]);
    }

    @Override
    public IIntelligentInstrumentationService getIntelligentInstrumentationService() {
        return this.fIntelligentInstrumentationService;
    }

    @Override
    public void setIntelligentInstrumentationService(IIntelligentInstrumentationService svc) {
        this.fIntelligentInstrumentationService = svc;
    }

    @Override
    public void redefinitionComplete() {
        for (IDirectiveLoadListener listener : this.fDirectiveLoadListeners) {
            if (listener == null) continue;
            listener.notifyRedefinitionComplete();
        }
    }

    private void notifyDirectiveLoadComplete() {
        for (IDirectiveLoadListener listener : this.fDirectiveLoadListeners) {
            if (listener == null) continue;
            listener.notifyDirectivesLoaded();
        }
    }

    @Override
    public boolean isDirectiveFileModified(String fileName) {
        File f = new File(fileName);
        long curTS = f.lastModified();
        long compTS = 0L;
        try {
            compTS = this.fFileToLastModTimeMap.get(f);
        }
        catch (NullPointerException nullPointerException) {
            this.fFeedback.debug(sModule, "Skipped SetDirectivesTimestamps for " + f);
        }
        if (compTS == -1L) {
            return false;
        }
        return curTS == 0L || compTS < curTS;
    }

    @Override
    public boolean reloadDirectives(HashSet<String> extPBDs) {
        boolean ret = false;
        try {
            this.fExtensionPBDs = extPBDs;
            this.loadDirectives(this.fLoader);
            ret = true;
        }
        catch (FileNotFoundException e) {
            this.fFeedback.debug(sModule, "Failed to reload directives " + e);
        }
        catch (ClassFileTransformerShouldNotRunException e) {
            this.fFeedback.debug(sModule, "Failed to reload directives " + e);
        }
        return ret;
    }

    private final class DirectivesCheckHeartbeatBehavior
    implements ITimestampedRunnable {
        private Set fDirectivesFiles;
        private String[] fDirectivesFilesArray;
        private IndexedProperties fProperties;
        private static final int kOK = 0;
        private static final int kChanged = 1;
        private static final int kInvalid = 2;

        DirectivesCheckHeartbeatBehavior(String[] directivesFiles, IndexedProperties properties) {
            this.fDirectivesFilesArray = directivesFiles;
            this.fDirectivesFiles = this.fDirectivesFilesArray != null ? new HashSet<String>(Arrays.asList(this.fDirectivesFilesArray)) : new HashSet();
            this.fProperties = properties;
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            int testState = 0;
            testState = this.testAndSetDirectivesList();
            if (testState == 0) {
                if (this.testAndSetDirectivesTimestamps()) {
                    this.reloadDirectives();
                }
            } else if (testState == 1) {
                AutoProbeTransformer.this.fLoader.updateDirectiveFiles(this.fDirectivesFilesArray);
                this.reloadDirectives();
            }
        }

        private void reloadDirectives() {
            try {
                AutoProbeTransformer.this.loadDirectives(AutoProbeTransformer.this.fLoader);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (ClassFileTransformerShouldNotRunException classFileTransformerShouldNotRunException) {}
        }

        private boolean testAndSetDirectivesTimestamps() {
            boolean result = false;
            try {
                Iterator it = AutoProbeTransformer.this.fFileToLastModTimeMap.keySet().iterator();
                while (it.hasNext() && !result) {
                    File f = (File)it.next();
                    if (f.exists()) {
                        long curTS = f.lastModified();
                        long compTS = 0L;
                        try {
                            compTS = (Long)AutoProbeTransformer.this.fFileToLastModTimeMap.get(f);
                        }
                        catch (NullPointerException nullPointerException) {
                            AutoProbeTransformer.this.fFeedback.debug(sModule, "Skipped SetDirectivesTimestamps for " + f);
                        }
                        if (curTS != 0L && compTS >= curTS) continue;
                        if (f.isFile()) {
                            if (AutoProbeTransformer.this.fFeedback.isDebugEnabled()) {
                                AutoProbeTransformer.this.fFeedback.debug(sModule, "Reloading directives because file " + f + " has been modified.");
                            }
                        } else if (AutoProbeTransformer.this.fFeedback.isDebugEnabled()) {
                            AutoProbeTransformer.this.fFeedback.debug(sModule, "Reloading directives because folder " + f + " has been modified.");
                        }
                        result = true;
                        continue;
                    }
                    Long compTS = (Long)AutoProbeTransformer.this.fFileToLastModTimeMap.get(f);
                    if (compTS != null && compTS == -1L) continue;
                    if (f.isFile()) {
                        if (AutoProbeTransformer.this.fFeedback.isDebugEnabled()) {
                            AutoProbeTransformer.this.fFeedback.debug(sModule, "Reloading directives because file " + f + " has been removed.");
                        }
                    } else if (AutoProbeTransformer.this.fFeedback.isDebugEnabled()) {
                        AutoProbeTransformer.this.fFeedback.debug(sModule, "Reloading directives because folder " + f + " has been removed.");
                    }
                    result = true;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                AutoProbeTransformer.this.getFeedback().error("An exception occurred checking directives files");
                AutoProbeTransformer.this.getFeedback().debug(t);
            }
            return result;
        }

        private int testAndSetDirectivesList() {
            int result = 0;
            if (AutoProbeTransformer.this.fAgentPropFile != null && AutoProbeTransformer.this.fAgentPropFileLastModTime < AutoProbeTransformer.this.fAgentPropFile.lastModified()) {
                if (AutoProbeTransformer.this.getFeedback().isDebugEnabled()) {
                    AutoProbeTransformer.this.getFeedback().debug("AutoProbeTransformer: noticed change to agent property file");
                }
                AutoProbeTransformer.this.fAgentPropFileLastModTime = AutoProbeTransformer.this.fAgentPropFile.lastModified();
                this.fProperties = AutoProbeTransformer.this.loadProfilePropertiesFromPropertyFile();
                String[] directivesFiles = AutoProbeTransformer.this.getDirectivesFiles(this.fProperties);
                if (directivesFiles != null) {
                    HashSet<String> directivesFilesSet = new HashSet<String>(Arrays.asList(directivesFiles));
                    if (!directivesFilesSet.equals(this.fDirectivesFiles)) {
                        result = 1;
                        this.fDirectivesFiles = directivesFilesSet;
                        this.fDirectivesFilesArray = directivesFiles;
                    }
                } else {
                    result = 2;
                }
            }
            return result;
        }
    }

    private final class IntelligentInstrumentationEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private IntelligentInstrumentationEnabledConfigurationProperty(IAgent agent) {
            super(AutoProbeTransformer.kIntelligentInstrumentationEnablingProperty, new Boolean(true), agent.IAgent_getModuleFeedback(), sModule, agent.IAgent_getStringLocalizer());
        }

        public boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    public final class LogConfigurationProperty
    extends StringSetConfigurationProperty {
        public LogConfigurationProperty(String name, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, descriptionKey, feedback, module, localizer);
        }
    }

    private final class LogSkippedClassesEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private LogSkippedClassesEnabledConfigurationProperty(IAgent agent) {
            super(AutoProbeTransformer.kLogSkippedClassesEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), sModule, agent.IAgent_getStringLocalizer());
        }

        public boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }
}

