/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.messageprimitives.InterfaceVersionException;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectInputStream;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectOutputStream;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;

public class MethodCallMessage
extends AMessage {
    private static final long serialVersionUID = -7453473739997317730L;
    private Method fMethod;
    private int fInterfaceVersion;
    private Object[] fParams;
    transient String fMethodName;
    static /* synthetic */ Class class$0;

    public MethodCallMessage() {
    }

    public MethodCallMessage(Method method, int interfaceVersion, Object[] params) {
        this.fMethod = method;
        this.fInterfaceVersion = interfaceVersion;
        this.fParams = params;
    }

    public String toString() {
        String values = "[";
        if (this.fParams != null) {
            int i = 0;
            while (i < this.fParams.length) {
                values = this.fParams[i] == null ? String.valueOf(values) + "null" : String.valueOf(values) + this.fParams[i].toString();
                if (i < this.fParams.length - 1) {
                    values = String.valueOf(values) + ", ";
                }
                ++i;
            }
        }
        values = String.valueOf(values) + "]";
        return String.valueOf(this.getClass().getName()) + ": {" + this.fMethod.getDeclaringClass().getName() + "." + this.fMethod.getName() + ", v" + this.fInterfaceVersion + ", " + values + ", source: " + this.getSourceAddress() + ", remoteHost: " + this.getRemoteHost() + "}";
    }

    public void writeExternal(ObjectOutput pOut) throws IOException {
        super.writeExternal(pOut);
        IsengardObjectOutputStream out = (IsengardObjectOutputStream)pOut;
        out.writeInt(this.fInterfaceVersion);
        out.writeMethod(this.fMethod);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean hadCachedByteArray = out.isCached(clazz);
        Object params = this.getParamsForWriting(out, this.fParams);
        if (!hadCachedByteArray && params instanceof byte[]) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("[B");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (out.isCached(clazz2)) {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("[B");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                out.removeCache(clazz3);
            }
        }
        out.writeObject(params);
    }

    protected Object getParamsForWriting(IsengardObjectOutputStream out, Object[] params) throws IOException {
        return params;
    }

    protected Object[] getParamsForReading(IsengardObjectInputStream in, Object params) throws IOException, ClassNotFoundException {
        return (Object[])params;
    }

    public void readExternal(ObjectInput pIn) throws IOException, ClassNotFoundException {
        super.readExternal(pIn);
        IsengardObjectInputStream in = (IsengardObjectInputStream)pIn;
        try {
            this.fInterfaceVersion = in.readInt();
            this.fMethod = in.readMethod(this.fInterfaceVersion);
            Assertion.wilyAssert(this.fMethod != null);
        }
        catch (InterfaceVersionException e) {
            this.fInterfaceVersion = e.getVersion();
            this.fMethod = null;
            this.fMethodName = e.getMethodName();
        }
        Object params = in.readObject();
        this.fParams = this.getParamsForReading(in, params);
    }

    public Method getMethod() {
        return this.fMethod;
    }

    public Object[] getParams() {
        return this.fParams;
    }

    public int getInterfaceVersion() {
        return this.fInterfaceVersion;
    }

    public String getMethodName() {
        return this.fMethodName;
    }
}

