/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.powerpack.webservices.JAXWSUtils;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class AsyncCallbackTracer
extends ASingleInstanceTracerFactory
implements KConstants {
    protected final IModuleFeedbackChannel logger;

    public AsyncCallbackTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            Throwable objError = (Throwable)data.getInvocationParameterAsObject(1);
            Map mapResponseCtx = JAXWSUtils.get();
            Long reqStartTime = (Long)mapResponseCtx.get("wily.request.startTime");
            long startTime = 0L;
            if (reqStartTime != null) {
                startTime = reqStartTime;
            }
            long endTime = System.currentTimeMillis();
            int avgrestime = (int)(endTime - startTime);
            String component = this.formatParameterizedResource(data);
            this.createUpdateCustomMetrics(component, avgrestime, startTime, endTime, objError);
        }
        catch (Exception e) {
            WSMUtils.handleError(this.getAgent(), e.getMessage(), e);
        }
    }

    protected void createUpdateCustomMetrics(String metricResourceName, long elapsed, long startTime, long endTime, Throwable objError) {
        AgentMetric responseTimeMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(metricResourceName) + ":" + "Average Response Time (ms)", 1025, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository newResp = BlamePointTracer.getAverageMetricRepository();
        IRepository prevResp = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)AAgentMetricArray.getInstance((AgentMetric)responseTimeMetric), (IRepository)newResp);
        if (prevResp != null) {
            prevResp.update(BlamePointTracer.getUpdater(), elapsed, startTime, endTime);
        } else {
            newResp.update(BlamePointTracer.getUpdater(), elapsed, startTime, endTime);
        }
        AgentMetric responsePerIntervalMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(metricResourceName) + ":" + "Responses Per Interval", 8194, "Invalid Names:Invalid name given for a long interval counter metric");
        IRepository newPerInt = BlamePointTracer.getCountQueuedRepository((boolean)true);
        IRepository prevPerInt = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)AAgentMetricArray.getInstance((AgentMetric)responsePerIntervalMetric), (IRepository)newPerInt);
        if (prevPerInt != null) {
            prevPerInt.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
        } else {
            newPerInt.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
        }
        if (objError != null) {
            AgentMetric errorsPerIntervalMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(metricResourceName) + ":" + "Errors Per Interval", 8194, "Invalid Names:Invalid name given for a long interval counter metric");
            IRepository newErr = BlamePointTracer.getCountQueuedRepository((boolean)true);
            IRepository prevErr = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)AAgentMetricArray.getInstance((AgentMetric)errorsPerIntervalMetric), (IRepository)newErr);
            if (prevErr != null) {
                prevErr.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            } else {
                newErr.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            }
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kMethodName;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

