/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery;

import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Hashtable;

public final class MQDiscoveryConnector
implements MQDiscoveryConstants {
    private static IModuleFeedbackChannel logger = null;
    private static String hostName = TraceProperties.HANDSHAKE_QM_HOST_VALUE;
    private static String chlName = TraceProperties.HANDSHAKE_QM_CHANNEL_VALUE;
    private static Integer port = TraceProperties.HANDSHAKE_QM_PORT_VALUE;
    private static String ssl = TraceProperties.HANDSHAKE_QM_SSL_VALUE;
    private static String cipher = TraceProperties.HANDSHAKE_QM_CHANNEL_CIPHERSPEC_VALUE;
    private static Integer characterSet = TraceProperties.HANDSHAKE_QM_CHARACTER_SET_VALUE;
    private static StringBuffer sb = new StringBuffer();
    private static boolean sb_done = false;

    public static void setIModuleFeedbackChannel(IModuleFeedbackChannel feedback) {
        if (logger == null) {
            logger = feedback;
        }
    }

    public static synchronized Object getQueueManager() {
        Object discoveryQM = null;
        Hashtable<String, Object> mqProps = new Hashtable<String, Object>();
        mqProps.put("hostname", hostName);
        mqProps.put("port", port);
        mqProps.put("channel", chlName);
        mqProps.put("transport", "MQSeries Client");
        if (!sb_done) {
            sb = new StringBuffer();
            sb.append(" hostName: ").append(hostName).append(" port: ").append(port);
        }
        if (TraceConstants.VALUE_HANDSHAKE_QM_SSL_ENABLE.equals(ssl)) {
            mqProps.put("SSL Cipher Suite", cipher);
            if (!sb_done) {
                sb.append(" cipher: ").append(TraceProperties.handshake_qm_channel_cipherspec_prop_value);
            }
        }
        if (-1 != characterSet) {
            mqProps.put("CCSID", characterSet);
            if (!sb_done) {
                sb.append(" characterSet: ").append(characterSet);
            }
        }
        if (!sb_done) {
            sb_done = true;
        }
        try {
            discoveryQM = Reflection.createMQQueueManager("", mqProps);
            if (discoveryQM != null) {
                logger.debug(discoveryModule, "Successful connection to queue manager for discovery using " + sb.toString() + " channel: " + chlName);
                return discoveryQM;
            }
            logger.debug(discoveryModule, "Not able to create queue manager connection for discovery using " + sb.toString() + " channel: " + chlName + ". Will try with another channel.");
        }
        catch (Exception e) {
            logger.debug(discoveryModule, "Not able to create queue manager connection for discovery using " + sb.toString() + " channel: " + chlName + ". Will try with " + "SYSTEM.DEF.SVRCONN" + " channel. ");
            logger.debug(discoveryModule, e.getMessage(), (Throwable)e);
        }
        if (discoveryQM == null) {
            mqProps.put("channel", "SYSTEM.DEF.SVRCONN");
            try {
                discoveryQM = Reflection.createMQQueueManager("", mqProps);
                if (discoveryQM != null) {
                    chlName = "SYSTEM.DEF.SVRCONN";
                    logger.debug(discoveryModule, "Successful connection to queue manager for discovery using " + sb.toString() + " channel: " + chlName);
                    return discoveryQM;
                }
                logger.debug(discoveryModule, "Not able to create queue manager connection for discovery using " + sb.toString() + " using different default channel: " + "SYSTEM.DEF.SVRCONN" + ". Verify the discovery properties in MQMonitor.properties. " + "Connection is important for MQ transaction trace to start");
            }
            catch (Exception e) {
                logger.debug(discoveryModule, "Not able to create queue manager connection for discovery using different channel " + sb.toString() + " channel: " + "SYSTEM.DEF.SVRCONN" + ". Verify the discovery properties in MQMonitor.properties. " + "Connection is important for MQ transaction trace to start. ");
                logger.debug(discoveryModule, e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

