/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery;

import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.QueuePacket;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.StringTokenizer;

public final class MQDiscoveryDataPacket
implements MQDiscoveryConstants {
    private IModuleFeedbackChannel logger = null;
    private static MQDiscoveryDataPacket instance = null;
    private String agentName = null;
    public static String MQDISCOVERY_AGENT_START_STRING = "MQDISCOVERY_AGENT_START_STRING";
    public static int MQMONITOR_AGENTNAME = 0;
    public static int MQMONITOR_HOST = 1;

    private MQDiscoveryDataPacket(String agentName, IModuleFeedbackChannel feedback) {
        this.agentName = agentName;
        this.logger = MQPPLog.getLogger();
    }

    public static synchronized MQDiscoveryDataPacket getInstance(String agentName, IModuleFeedbackChannel feedback) {
        if (instance == null) {
            instance = new MQDiscoveryDataPacket(agentName, feedback);
        }
        return instance;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Object createMessageForMQMonitorAgent(QueuePacket queuePacket) {
        Object msg = null;
        try {
            msg = Reflection.createMessageForMQMonitorAgent(queuePacket, this.agentName);
        }
        catch (Exception e) {
            this.logger.debug((Throwable)e);
            this.logger.error(discoveryModule, e.getMessage());
        }
        return msg;
    }

    public String[] extractMQMonitorInformation(String text) {
        this.logger.debug(discoveryModule, "Received message text: " + text);
        boolean messageFromMQMonitorAgentFlag = text.startsWith(MQDISCOVERY_AGENT_START_STRING);
        if (messageFromMQMonitorAgentFlag) {
            String[] s = new String[text.length()];
            StringTokenizer st = new StringTokenizer(text, "-|-");
            int count = 0;
            while (st != null && st.hasMoreElements()) {
                st.nextToken();
                s[count++] = st.nextToken();
            }
            return s;
        }
        return null;
    }
}

