/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

public final class ScatteringBufferInputStream
extends InputStream {
    private static final int kDefaultBufferSize = 32768;
    private final int fBuffersSize;
    private int fReadPosition;
    private BufferedData fBuffer;
    private LinkedList fBufferList;
    private int fBufferMaxNum;

    public ScatteringBufferInputStream() {
        this(32768);
    }

    public ScatteringBufferInputStream(int buffersSize) {
        this(buffersSize, 0);
    }

    public ScatteringBufferInputStream(int buffersSize, int bufferMaxNum) {
        this.fBuffersSize = buffersSize;
        this.fReadPosition = 0;
        this.fBufferList = new LinkedList();
        this.fBuffer = new BufferedData(this.fBuffersSize);
        this.fBufferMaxNum = bufferMaxNum;
    }

    private void fill() {
        if (this.fReadPosition == this.fBuffer.getPosition()) {
            if (this.fBufferList.size() == 0) {
                this.fReadPosition = 0;
                this.fBuffer.fPosition = 0;
            } else {
                this.fBuffer = (BufferedData)this.fBufferList.removeFirst();
                this.fReadPosition = 0;
            }
        }
    }

    public final int read() {
        this.fill();
        if (this.fReadPosition == this.fBuffer.getPosition()) {
            return -1;
        }
        return this.fBuffer.getBuffer()[this.fReadPosition++] & 0xFF;
    }

    public int available() {
        int avail = this.fBuffer.getPosition() - this.fReadPosition;
        for (BufferedData data : this.fBufferList) {
            avail += data.getPosition();
        }
        return avail;
    }

    public boolean hasAvailable() {
        int avail = this.fBuffer.getPosition() - this.fReadPosition;
        if (avail > 0) {
            return true;
        }
        for (BufferedData data : this.fBufferList) {
            if (data.getPosition() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative: " + off);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative: " + len);
        }
        maxPos = off + len;
        if (maxPos > b.length) {
            throw new IndexOutOfBoundsException("len too large: len=" + len + ", buffer length=" + b.length + ", offset=" + off);
        }
        pos = off;
        this.fill();
        if (this.fReadPosition != this.fBuffer.getPosition()) ** GOTO lbl23
        return -1;
lbl-1000:
        // 1 sources

        {
            availInBuffer = this.fBuffer.getPosition() - this.fReadPosition;
            if (availInBuffer == 0) {
                return -1;
            }
            lenToCopy = 0;
            lenToCopy = availInBuffer > maxPos - pos ? maxPos - pos : availInBuffer;
            System.arraycopy(this.fBuffer.getBuffer(), this.fReadPosition, b, pos, lenToCopy);
            pos += lenToCopy;
            this.fReadPosition += lenToCopy;
            this.fill();
lbl23:
            // 2 sources

            ** while (pos < maxPos && this.hasAvailable())
        }
lbl24:
        // 1 sources

        return pos - off;
    }

    public void fillFromArray(byte[] source) {
        int numBytesToRead = source.length;
        BufferedData buffer = this.fBufferList.size() > 0 ? (BufferedData)this.fBufferList.getLast() : this.fBuffer;
        int bytesRemaining = numBytesToRead;
        int pos = 0;
        while (bytesRemaining > 0) {
            if (buffer.freeSpaceAvailable() == 0) {
                buffer = this.createNewBuffer();
            }
            int numToRead = bytesRemaining;
            int numRead = buffer.fillFromArray(source, pos, numToRead);
            pos += numRead;
            bytesRemaining -= numRead;
        }
    }

    private BufferedData createNewBuffer() {
        if (this.fBufferMaxNum > 0 && this.fBufferList.size() > this.fBufferMaxNum) {
            throw new RuntimeException("Incoming data too big consumed " + this.fBufferList.size() + " buffers exceeded max allowed: " + this.fBufferMaxNum);
        }
        BufferedData buffer = new BufferedData(this.fBuffersSize);
        this.fBufferList.add(buffer);
        return buffer;
    }

    public void fillFromStream(InputStream source) throws IOException {
        int numBytesToRead = source.available();
        BufferedData buffer = this.fBufferList.size() > 0 ? (BufferedData)this.fBufferList.getLast() : this.fBuffer;
        int bytesRemaining = numBytesToRead;
        while (bytesRemaining > 0) {
            if (buffer.freeSpaceAvailable() == 0) {
                buffer = this.createNewBuffer();
            }
            int numToRead = Math.min(numBytesToRead, buffer.freeSpaceAvailable());
            int numRead = buffer.fillFromStream(source, numToRead);
            bytesRemaining -= numRead;
        }
    }

    int numBuffers() {
        return this.fBufferList.size() + 1;
    }

    int allBuffersSize() {
        int s = this.fBuffer.fBuffer.length;
        Iterator i = this.fBufferList.iterator();
        while (i.hasNext()) {
            s += ((BufferedData)i.next()).fBuffer.length;
        }
        return s;
    }

    private static final class BufferedData {
        int fPosition = 0;
        byte[] fBuffer;

        public BufferedData(int bufferSize) {
            this.fBuffer = new byte[bufferSize];
        }

        public int fillFromArray(byte[] source, int startIndex, int numToRead) {
            int numRead = Math.min(numToRead, this.fBuffer.length - this.fPosition);
            System.arraycopy(source, startIndex, this.fBuffer, this.fPosition, numRead);
            this.fPosition += numRead;
            return numRead;
        }

        public int fillFromStream(InputStream source, int numToRead) throws IOException {
            int numRead = source.read(this.fBuffer, this.fPosition, numToRead);
            if (numRead < 0) {
                throw new EOFException("End of stream");
            }
            this.fPosition += numRead;
            return numRead;
        }

        public void setPosition(int position) {
            this.fPosition = position;
        }

        public int getPosition() {
            return this.fPosition;
        }

        public void incrementPosition(int value) {
            this.fPosition += value;
        }

        public byte[] getBuffer() {
            return this.fBuffer;
        }

        public int freeSpaceAvailable() {
            return this.fBuffer.length - this.fPosition;
        }
    }
}

