/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.HashCodeUtils;
import com.wily.util.event.EventMarkerGenerator;
import com.wily.wilyassert.Assertion;
import java.util.Arrays;

public final class EventMarker
implements Comparable {
    private final EventMarkerGenerator fGenerator;
    private final EventMarker fParent;
    private final long fEventTimestamp;
    private final long fEventIndex;
    private final long[] fFullIndex;
    private long fNextSlaveEventIndex;

    static EventMarker createMasterEventMarker(EventMarkerGenerator generator, long eventTimestamp, long eventIndex) {
        return new EventMarker(generator, null, eventTimestamp, eventIndex);
    }

    static EventMarker createSlaveEventMarker(EventMarker parent) {
        return new EventMarker(parent.getGenerator(), parent, parent.getEventTimestamp(), parent.getNextSlaveEventIndex());
    }

    private EventMarker(EventMarkerGenerator generator, EventMarker parent, long eventTimestamp, long eventIndex) {
        this.fGenerator = generator;
        this.fParent = parent;
        this.fEventTimestamp = eventTimestamp;
        this.fEventIndex = eventIndex;
        this.fFullIndex = this.calculateFullIndex(parent, eventIndex);
        this.fNextSlaveEventIndex = 1L;
    }

    private long[] calculateFullIndex(EventMarker parent, long eventIndex) {
        long[] parentFullIndex = parent == null ? new long[]{} : parent.fFullIndex;
        long[] fullIndex = new long[parentFullIndex.length + 1];
        System.arraycopy(parentFullIndex, 0, fullIndex, 0, parentFullIndex.length);
        fullIndex[fullIndex.length - 1] = eventIndex;
        return fullIndex;
    }

    private EventMarkerGenerator getGenerator() {
        return this.fGenerator;
    }

    private synchronized long getNextSlaveEventIndex() {
        return this.fNextSlaveEventIndex++;
    }

    public long getEventTimestamp() {
        return this.fEventTimestamp;
    }

    public boolean isMasterEventMarker() {
        return this.fParent == null;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        EventMarker argument = (EventMarker)o;
        Assertion.wilyAssert(this.getGenerator() == argument.getGenerator());
        int sharedLength = this.fFullIndex.length <= argument.fFullIndex.length ? this.fFullIndex.length : argument.fFullIndex.length;
        for (int i = 0; i < sharedLength; ++i) {
            if (this.fFullIndex[i] < argument.fFullIndex[i]) {
                return -1;
            }
            if (this.fFullIndex[i] <= argument.fFullIndex[i]) continue;
            return 1;
        }
        if (this.fFullIndex.length < argument.fFullIndex.length) {
            return -1;
        }
        if (this.fFullIndex.length > argument.fFullIndex.length) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof EventMarker) {
            EventMarker other = (EventMarker)o;
            Assertion.wilyAssert(this.getGenerator() == other.getGenerator());
            return Arrays.equals(this.fFullIndex, other.fFullIndex);
        }
        return false;
    }

    public int hashCode() {
        int result = this.fParent == null ? 17 : this.fParent.hashCode();
        return HashCodeUtils.accumulateHashCode(result, HashCodeUtils.hashLong(this.fEventIndex));
    }

    private String generateFullIndex() {
        String result = String.valueOf(this.fEventIndex);
        if (this.fParent != null) {
            result = this.fParent.generateFullIndex() + "." + result;
        }
        return result;
    }

    public String toString() {
        return this.generateFullIndex();
    }
}

