/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ctg.server;

import com.ibm.ctg.monitoring.FlowTopology;
import com.ibm.ctg.monitoring.FlowType;
import com.ibm.ctg.monitoring.RequestData;
import com.ibm.ctg.monitoring.RequestEvent;
import com.ibm.ctg.monitoring.RequestExit;
import com.ibm.ctg.monitoring.TransientPayLoad;
import com.ibm.ctg.server.APM_GlobalStatsExit_Poller;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.api.DataRecorderFactory;
import com.wily.introscope.agent.api.IntAverageDataRecorder;
import com.wily.introscope.agent.api.IntCounterDataRecorder;
import com.wily.introscope.agent.api.LongCounterDataRecorder;
import com.wily.introscope.agent.api.PerIntervalCounterDataRecorder;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.feedback.ABufferedApplicationFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APM_RequestExit_Monitor
implements RequestExit {
    public static final String copyright = "\nLicensed Materials - Property of IBM 5724-I81 5655-W10(c) Copyright IBM Corp. 2001, 2010  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
    public static final String STDOUT_PROPERTY = "com.ibm.ctg.samples.requestexit.out";
    public File destFile;
    public PrintStream stdout = null;
    public boolean use_debug_println = false;
    public boolean onZos;
    public boolean onWindows;
    public String event_data_string;
    private static ABufferedApplicationFeedbackChannel sFeedback;
    private static IStringLocalizer sLocalizer;
    private static IVersion sVersion;
    public IAgent my_agent;
    public DataAccumulatorFactory dataaccumulator_factory;
    public APM_GlobalStatsExit_Poller gStatsPoller;
    public Thread statsThread;
    public String statHostname_property;
    public int statPort_property;
    public int statSleep_property;
    public boolean statsEnabled;
    public String stats_filter;
    public int num_times_invoked;
    public IntCounterDataRecorder AggEci_ProgInvokeIntRecorder;
    public IntAverageDataRecorder AggEci_RspIntRecorder;
    public IntCounterDataRecorder AggEci_ErrorsIntRecorder;
    public PerIntervalCounterDataRecorder AggEci_InvokesIntRecorder;
    public IIntegerFluctuatingCounterDataAccumulator ConcurInvokesCounter;

    public APM_RequestExit_Monitor() {
        String destination = null;
        String prefix_name = null;
        this.gStatsPoller = null;
        this.num_times_invoked = 0;
        this.onWindows = System.getProperty("os.name").contains("Windows");
        if (this.onWindows) {
            String productDataPath = System.getenv("CTG_DATA_PATH");
            destination = String.valueOf(productDataPath) + "\\" + "APM_TRACE.txt";
            this.destFile = new File(destination);
            try {
                this.stdout = new PrintStream(this.destFile);
            }
            catch (FileNotFoundException e) {
                System.err.println("Write to Trace file: '" + destination + "' failed with " + e);
                System.err.println("Using default Stderr instead");
                this.stdout = this.getDefaultStderr();
            }
        } else {
            destination = System.getProperty(STDOUT_PROPERTY);
            if (destination == null) {
                this.stdout = this.getDefaultStdout();
            } else {
                this.destFile = new File(destination);
                try {
                    this.stdout = new PrintStream(this.destFile);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Write to Trace file: '" + destination + "' failed with " + e);
                    this.stdout = this.getDefaultStdout();
                }
            }
        }
        this.trace_println("  ---****  APM_RequestExit_Monitor PP CTG starting up  ****---");
        this.onZos = System.getProperty("os.name").equals("z/OS");
        this.onWindows = System.getProperty("os.name").contains("Windows");
        if (this.use_debug_println) {
            this.trace_println("APM_RequestExit_Monitor  starting " + this.getClass().getSimpleName() + " log stream  at " + new Date());
            this.trace_println(this.getSystemEnvironment());
        }
        this.my_agent = null;
        this.dataaccumulator_factory = null;
        try {
            this.trace_println("APM_RequestExit_Monitor calling Introscope initialize/startup logic.");
            this.my_agent = AgentShim.getAgent();
            APM_RequestExit_Monitor.initialize_Iscope(this.my_agent);
            this.dataaccumulator_factory = this.my_agent.IAgent_getDataAccumulatorFactory();
            this.trace_println("APM_RequestExit_Monitor Introscope startup logic completed successfully. my_agent=" + this.my_agent);
            this.ConcurInvokesCounter = null;
            this.stats_filter = "ALL";
            this.statsEnabled = this.onWindows ? false : this.my_agent.IAgent_getIndexedProperties().safeGetBooleanProperty("ppctg.statistics.enable", true, this.my_agent.IAgent_getModuleFeedback(), this.my_agent.IAgent_getStringLocalizer());
            if (!this.statsEnabled) {
                if (!this.onWindows) {
                    this.trace_println("PP CTG Global Statistics are disabled.");
                    sFeedback.warn("PP CTG Global Statistics are disabled.");
                }
            } else {
                this.statHostname_property = this.my_agent.IAgent_getIndexedProperties().getProperty("ppctg.statistics.host");
                this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Hostname property=" + this.statHostname_property);
                if (this.statHostname_property == null) {
                    this.statHostname_property = "localhost";
                }
                this.statPort_property = this.my_agent.IAgent_getIndexedProperties().safeGetIntProperty("ppctg.statistics.port", 2980, this.my_agent.IAgent_getModuleFeedback(), this.my_agent.IAgent_getStringLocalizer());
                if (this.statPort_property != 0) {
                    this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics TCP Port property=" + this.statPort_property);
                } else {
                    sFeedback.warn("CTG Global Stats Service statistics port was not defined. Will use default port=2980");
                    this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Port property NOT defined. Will use default port=2980");
                    this.statPort_property = 2980;
                }
                this.statSleep_property = this.my_agent.IAgent_getIndexedProperties().safeGetIntProperty("ppctg.statistics.sleep", 60, this.my_agent.IAgent_getModuleFeedback(), this.my_agent.IAgent_getStringLocalizer());
                if (this.statSleep_property != 0) {
                    this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Sleep property=" + this.statSleep_property);
                } else {
                    sFeedback.warn("CTG Global Stats Service statistics sleep time was not defined. Will use default sleep = 60 secoonds");
                    this.trace_println("APM_RequestExit_Monitor PP CTG Global Statistics Sleep property NOT defined. Will use default sleep = 60 seconds");
                    this.statSleep_property = 60;
                }
                try {
                    this.gStatsPoller = new APM_GlobalStatsExit_Poller(this.my_agent, this.stdout, sFeedback, this.stats_filter, this.statHostname_property, this.statPort_property, this.statSleep_property);
                    this.trace_println("  ---****  APM_RequestExit_Monitor initialized Global Stats Poller service  ****---");
                }
                catch (Exception e) {
                    this.trace_println("PP CTG Global Stats Service statistics are not available." + e.toString());
                    sFeedback.warn("PP CTG Global Stats Service statistics are not available.", (Throwable)e);
                    this.statsEnabled = false;
                }
                if (this.statsEnabled) {
                    sFeedback.info("APM_RequestExit_Monitor PP CTG Global Stats Service successfully loaded.");
                    this.statsThread = new Thread(this.gStatsPoller);
                    this.statsThread.start();
                    this.trace_println("  ---****  APM_RequestExit_Monitor started Global Stats Poller service Run Thread ****---");
                }
            }
            prefix_name = "Backends|CTG_to_CICS_ECI_IPIC_RequestExit:Program Aggregate Count ECI_IPIC";
            this.AggEci_ProgInvokeIntRecorder = DataRecorderFactory.createIntCounterDataRecorder((String)prefix_name);
            prefix_name = "Backends|CTG_to_CICS_ECI_IPIC_RequestExit:Program Average Response Time (ms)";
            this.AggEci_RspIntRecorder = DataRecorderFactory.createIntAverageDataRecorder((String)prefix_name);
            prefix_name = "Backends|CTG_to_CICS_ECI_IPIC_RequestExit:Program Invocations Per Interval";
            this.AggEci_InvokesIntRecorder = DataRecorderFactory.createPerIntervalCounterDataRecorder((String)prefix_name);
            prefix_name = "Backends|CTG_to_CICS_ECI_IPIC_RequestExit:Program Aggregate Errors";
            this.AggEci_ErrorsIntRecorder = DataRecorderFactory.createIntCounterDataRecorder((String)prefix_name);
        }
        catch (Exception e) {
            this.trace_println("APM_RequestExit_Monitor Introscope startup logic failed: " + e.toString());
            e.printStackTrace();
        }
    }

    public static void initialize_Iscope(IAgent my_Agent) {
        APM_RequestExit_Monitor.class.getClassLoader();
        sFeedback = new ABufferedApplicationFeedbackChannel("PPCTG: RequestExit");
        sLocalizer = my_Agent.IAgent_getStringLocalizer();
        sVersion = new IntroscopeVersion(sLocalizer);
    }

    public void eventFired(RequestEvent event, Map<RequestData, Object> data) {
        if (event.equals((Object)RequestEvent.RequestEntry) || event.equals((Object)RequestEvent.ResponseExit)) {
            this.event_data_string = this.dumpEventData(String.valueOf(this.myName()) + ":eventFired", event, data);
            if (this.use_debug_println) {
                this.trace_println(this.event_data_string);
            }
        } else {
            if (event.equals((Object)RequestEvent.ShutDown) && this.gStatsPoller != null) {
                this.gStatsPoller.requestShutdown();
            }
            if (!this.use_debug_println) {
                return;
            }
            new Date();
        }
    }

    public String myName() {
        return this.getClass().getCanonicalName();
    }

    public PrintStream getDefaultStdout() {
        return System.out;
    }

    public PrintStream getDefaultStderr() {
        return System.err;
    }

    public String dumpEventData(String originator, RequestEvent event, Map<RequestData, Object> data) {
        TransientPayLoad tpl;
        Object object;
        int ctgCorrelator = (Integer)data.get(RequestData.CtgCorrelator);
        String prefix = String.format("\n[%011d]: ", ctgCorrelator);
        EnumSet<RequestData> remainingData = EnumSet.allOf(RequestData.class);
        StringBuffer message = null;
        String prefix_name = null;
        String metric_name = null;
        String Server_Name = null;
        String Program_Name = null;
        String EPI_Tran_Name = null;
        Server_Name = (String)data.get(RequestData.Server);
        if (Server_Name != null) {
            int url_Index = (Server_Name = Server_Name.toUpperCase()).indexOf(":");
            if (url_Index > 0 && Server_Name.charAt(url_Index + 1) == '/') {
                int url_End = Server_Name.length();
                int port_Index = Server_Name.indexOf(":", url_Index + 1);
                if (port_Index > 0 && port_Index < url_End) {
                    url_End = port_Index;
                }
                Server_Name = url_End > 0 ? Server_Name.substring(url_Index + 3, url_End) : Server_Name.substring(url_Index + 3);
            }
        } else {
            return null;
        }
        remainingData.remove(RequestData.Server);
        Program_Name = (String)data.get(RequestData.Program);
        if (Program_Name != null) {
            Program_Name = Program_Name.toUpperCase();
            prefix_name = "Backends|CTG_to_CICS_ECI_IPIC_RequestExit|" + Server_Name + "|" + Program_Name;
        }
        remainingData.remove(RequestData.Program);
        EPI_Tran_Name = (String)data.get(RequestData.TranName);
        if (EPI_Tran_Name != null) {
            EPI_Tran_Name = EPI_Tran_Name.toUpperCase();
            prefix_name = "Backends|CTG_to_CICS_EPI_RequestExit|" + Server_Name + "|" + EPI_Tran_Name;
        }
        remainingData.remove(RequestData.TranName);
        if (prefix_name == null) {
            return null;
        }
        if (event.equals((Object)RequestEvent.RequestEntry)) {
            try {
                metric_name = String.valueOf(prefix_name) + ":Concurrent Invocations";
                this.ConcurInvokesCounter = AgentShim.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metric_name);
                this.ConcurInvokesCounter.IIntegerFluctuatingCounterDataAccumulator_increment();
                object = data.get(RequestData.PayLoad);
                if (object != null && prefix_name != null) {
                    tpl = (TransientPayLoad)object;
                    metric_name = String.valueOf(prefix_name) + ":CommArea Aggregate Request Data";
                    LongCounterDataRecorder fAggReqLngRecorder = DataRecorderFactory.createLongCounterDataRecorder((String)metric_name);
                    fAggReqLngRecorder.add((long)tpl.getLength());
                }
            }
            catch (Exception e) {
                this.trace_println("APM_RequestExit_Monitor Introscope record metric failed: " + e.toString());
                e.printStackTrace();
            }
        }
        if (event.equals((Object)RequestEvent.ResponseExit)) {
            try {
                ++this.num_times_invoked;
                if (prefix_name != null) {
                    metric_name = String.valueOf(prefix_name) + ":Aggregate Program Count ECI_IPIC";
                    IntCounterDataRecorder fAggIntRecorder = DataRecorderFactory.createIntCounterDataRecorder((String)metric_name);
                    fAggIntRecorder.add(1);
                    metric_name = String.valueOf(prefix_name) + ":Responses Per Interval";
                    PerIntervalCounterDataRecorder fInvokesIntRecorder = DataRecorderFactory.createPerIntervalCounterDataRecorder((String)metric_name);
                    fInvokesIntRecorder.recordIncident();
                    if (this.ConcurInvokesCounter != null) {
                        this.ConcurInvokesCounter.IIntegerFluctuatingCounterDataAccumulator_decrement();
                    }
                    if ((object = data.get(RequestData.PayLoad)) != null) {
                        tpl = (TransientPayLoad)object;
                        metric_name = String.valueOf(prefix_name) + ":CommArea Aggregate Reply Data";
                        LongCounterDataRecorder fAggRspLngRecorder = DataRecorderFactory.createLongCounterDataRecorder((String)metric_name);
                        fAggRspLngRecorder.add((long)tpl.getLength());
                    }
                }
                this.AggEci_ProgInvokeIntRecorder.add(1);
                this.AggEci_InvokesIntRecorder.recordIncident();
            }
            catch (Exception e) {
                this.trace_println("Introscope record metric failed: " + e.toString());
                e.printStackTrace();
            }
        }
        FlowType flowType = (FlowType)data.get(RequestData.FlowType);
        FlowTopology flowTopology = (FlowTopology)data.get(RequestData.FlowTopology);
        this.appendRequestData(message, RequestData.FlowType, flowType, prefix);
        this.appendRequestData(message, RequestData.FlowTopology, flowTopology, prefix);
        remainingData.remove(RequestData.FlowType);
        remainingData.remove(RequestData.FlowTopology);
        Object qualifier = data.get(RequestData.CtgApplidQualifier);
        Object applid = data.get(RequestData.CtgApplid);
        this.appendFullyQualifiedApplid(message, "Fully qualified applid", qualifier, applid, prefix);
        this.appendRequestData(message, RequestData.CtgCorrelator, ctgCorrelator, prefix);
        remainingData.remove(RequestData.CtgApplidQualifier);
        remainingData.remove(RequestData.CtgApplid);
        remainingData.remove(RequestData.CtgCorrelator);
        Object dataItem = data.get(RequestData.ClientCtgCorrelator);
        if (dataItem != null) {
            qualifier = data.get(RequestData.ClientCtgApplidQualifier);
            applid = data.get(RequestData.ClientCtgApplid);
            this.appendFullyQualifiedApplid(message, "Client fully qualified applid", qualifier, applid, prefix);
            this.appendRequestData(message, RequestData.ClientCtgCorrelator, dataItem, prefix);
        }
        remainingData.remove(RequestData.ClientCtgApplidQualifier);
        remainingData.remove(RequestData.ClientCtgApplid);
        remainingData.remove(RequestData.ClientCtgCorrelator);
        dataItem = data.get(RequestData.Xid);
        if (dataItem != null) {
            this.appendXid(message, dataItem, prefix);
        }
        remainingData.remove(RequestData.Xid);
        dataItem = data.get(RequestData.Urid);
        if (dataItem != null) {
            this.appendRequestData(message, RequestData.Urid, dataItem, prefix);
        }
        remainingData.remove(RequestData.Urid);
        dataItem = data.get(RequestData.LuwToken);
        if (dataItem != null) {
            this.appendRequestData(message, RequestData.LuwToken, dataItem, prefix);
        }
        remainingData.remove(RequestData.LuwToken);
        dataItem = data.get(RequestData.OriginData);
        if (dataItem != null) {
            this.appendOriginData(message, dataItem, prefix);
        }
        remainingData.remove(RequestData.OriginData);
        long base = (Long)data.get(RequestData.RequestReceived);
        this.appendTimeStamp(event, message, base, RequestData.RequestReceived, base, 1, prefix, prefix_name);
        remainingData.remove(RequestData.RequestReceived);
        dataItem = data.get(RequestData.RequestSent);
        if (dataItem != null) {
            this.appendTimeStamp(event, message, base, RequestData.RequestSent, dataItem, 2, prefix, prefix_name);
        }
        remainingData.remove(RequestData.RequestSent);
        dataItem = data.get(RequestData.ResponseReceived);
        if (dataItem != null) {
            this.appendTimeStamp(event, message, base, RequestData.ResponseReceived, dataItem, 3, prefix, prefix_name);
        }
        remainingData.remove(RequestData.ResponseReceived);
        dataItem = data.get(RequestData.ResponseSent);
        if (dataItem != null) {
            this.appendTimeStamp(event, message, base, RequestData.ResponseSent, dataItem, 4, prefix, prefix_name);
        }
        remainingData.remove(RequestData.ResponseSent);
        if (event.equals((Object)RequestEvent.ResponseExit)) {
            try {
                metric_name = String.valueOf(prefix_name) + ":Stall Count";
                ILongIntervalCounterDataAccumulator fStallsIntervalRecorder = this.dataaccumulator_factory.safeGetLongIntervalCounterDataAccumulator(metric_name);
                fStallsIntervalRecorder.ILongAggregatingDataAccumulator_recordDataPoint(0L);
                metric_name = String.valueOf(prefix_name) + ":Errors Per Interval";
                ILongIntervalCounterDataAccumulator fErrorsIntervalRecorder = this.dataaccumulator_factory.safeGetLongIntervalCounterDataAccumulator(metric_name);
                Integer cics_err_code_obj = (Integer)data.get(RequestData.CicsReturnCode);
                if (cics_err_code_obj != null) {
                    int cics_err_code = cics_err_code_obj;
                    if (cics_err_code != 0) {
                        String cics_abend_code;
                        metric_name = String.valueOf(prefix_name) + ":Errors Per Interval";
                        fErrorsIntervalRecorder.ILongIntervalCounterDataAccumulator_addSingleIncident();
                        String cics_error_text = " ";
                        if (cics_err_code == -3) {
                            cics_error_text = "ECI_ERR_NO_CICS";
                        }
                        if (cics_err_code == -4) {
                            cics_error_text = "ECI_ERR_CICS_DIED";
                        }
                        if (cics_err_code == -5) {
                            cics_error_text = "ECI_ERR_REQUEST_TIMEOUT";
                        }
                        if (cics_err_code == -6) {
                            cics_error_text = "ECI_ERR_RESPONSE_TIMEOUT";
                        }
                        if (cics_err_code == -7) {
                            cics_error_text = "ECI_ERR_TRANSACTION_ABEND";
                        }
                        if (cics_err_code == -16) {
                            cics_error_text = "ECI_ERR_RESOURCE_SHORTAGE";
                        }
                        if (cics_err_code == -17) {
                            cics_error_text = "ECI_ERR_NO_SESSIONS";
                        }
                        if (cics_err_code == -22) {
                            cics_error_text = "ECI_ERR_UNKNOWN_SERVER";
                        }
                        metric_name = (cics_abend_code = (String)data.get(RequestData.CicsAbendCode)) == null ? String.valueOf(prefix_name) + ":Aggregate Errors " + cics_error_text + " " + cics_err_code + " " + cics_abend_code : String.valueOf(prefix_name) + ":Aggregate Errors " + cics_error_text + " " + cics_err_code;
                        IntCounterDataRecorder fErrorsIntRecorder = DataRecorderFactory.createIntCounterDataRecorder((String)metric_name);
                        fErrorsIntRecorder.add(1);
                        this.AggEci_ErrorsIntRecorder.add(1);
                        String err_detect_errMessage = "Program invoke error: " + cics_err_code + "  " + cics_abend_code + " " + prefix_name;
                        if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)err_detect_errMessage)) {
                            this.my_agent.IAgent_getComponentTracer().noteBoundaryError();
                        }
                    } else {
                        fErrorsIntervalRecorder.ILongAggregatingDataAccumulator_recordDataPoint(0L);
                    }
                } else {
                    fErrorsIntervalRecorder.ILongAggregatingDataAccumulator_recordDataPoint(0L);
                }
            }
            catch (Exception e) {
                this.trace_println("Introscope record metric failed: " + e.toString());
                e.printStackTrace();
            }
        }
        if (this.use_debug_println) {
            for (RequestData requestData : remainingData) {
                Object object2 = data.get(requestData);
                if (object2 == null) continue;
                if (requestData == RequestData.PayLoad) {
                    this.appendPayLoad(message, requestData, object2, prefix);
                    continue;
                }
                this.appendRequestData(message, requestData, object2, prefix);
            }
        }
        return null;
    }

    private void appendTimeStamp(RequestEvent event, StringBuffer message, long base, RequestData requestData, Object dataItem, int tFlag, String prefix, String prfx_name) {
        Long value = (Long)dataItem;
        new Date(value);
        if (value != 0L && tFlag > 1 && event.equals((Object)RequestEvent.ResponseExit)) {
            try {
                long long_result = value - base;
                if (prfx_name != null) {
                    String metric_name = String.valueOf(prfx_name) + ":Average Response Time (ms)";
                    IntAverageDataRecorder fRspIntRecorder = DataRecorderFactory.createIntAverageDataRecorder((String)metric_name);
                    fRspIntRecorder.recordDataPoint((int)long_result);
                }
                this.AggEci_RspIntRecorder.recordDataPoint((int)long_result);
            }
            catch (Exception e) {
                this.trace_println("Introscope record metric failed: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    private void appendPayLoad(StringBuffer message, RequestData requestData, Object object, String prefix) {
        if (!this.use_debug_println) {
            return;
        }
    }

    private void appendOriginData(StringBuffer message, Object dataItem, String prefix) {
        if (!this.use_debug_println) {
            return;
        }
    }

    private void appendXid(StringBuffer message, Object dataItem, String prefix) {
        if (!this.use_debug_println) {
            return;
        }
    }

    public void appendFullyQualifiedApplid(StringBuffer message, String name, Object qualifier, Object applid, String prefix) {
        if (!this.use_debug_println) {
            return;
        }
    }

    public void appendRequestData(StringBuffer message, RequestData requestData, Map<RequestData, Object> data, String prefix) {
        if (!this.use_debug_println) {
            return;
        }
    }

    public void appendRequestData(StringBuffer message, RequestData requestData, Object object, String prefix) {
        if (!this.use_debug_println) {
            return;
        }
    }

    private void appendProperty(StringBuffer message, String property) {
    }

    private void appendOsDetails(StringBuffer message) {
    }

    public static String dumpToHex(byte[] bytes) {
        String hexString = APM_RequestExit_Monitor.toHex(bytes);
        if (bytes != null) {
            hexString = String.valueOf(hexString) + " '";
            int x = 0;
            while (x < bytes.length) {
                int ch = bytes[x];
                if (ch < 32 || ch > 127) {
                    ch = 63;
                }
                hexString = String.valueOf(hexString) + new String(Character.toChars(ch));
                ++x;
            }
            hexString = String.valueOf(hexString) + "'";
        }
        return hexString;
    }

    public static String toHex(byte[] bytes) {
        String hexString = "";
        if (bytes == null) {
            hexString = "{empty}";
        } else {
            int x = 0;
            while (x < bytes.length) {
                if (x > 0 && x % 4 == 0) {
                    hexString = String.valueOf(hexString) + " ";
                }
                hexString = String.valueOf(hexString) + String.format("%02X", bytes[x] & 0xFF);
                ++x;
            }
        }
        return hexString;
    }

    public String getSystemEnvironment() {
        return null;
    }

    public synchronized void trace_println(String string) {
        this.trace_print(String.valueOf(string) + "\r\n");
        if (this.stdout == null) {
            System.out.flush();
        } else {
            this.stdout.flush();
        }
    }

    public void trace_print(String args) {
        if (this.stdout == null) {
            System.out.print(args);
        } else {
            try {
                this.stdout.print(args);
            }
            catch (Throwable t) {
                System.err.println("Error using stdout: " + t + "\r\n");
                if (this.stdout == this.getDefaultStdout()) {
                    throw new RuntimeException("Default PrintStream has failed!\r\n");
                }
                this.stdout = this.getDefaultStdout();
                System.err.println("Using default PrintStream\r\n");
                System.err.println(args);
            }
        }
    }
}

