/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.batch;

import com.wily.diagnos.cmp.classfile.DGAlreadyInstrumentedException;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.DGSetAsSkippedException;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class ASingleCompiler {
    private final DGCompilerSettings fSettings;
    private final ICompilerLog fLog;
    public static final boolean kIsVerificationDebugEnabled;
    public static final String kVerificationDebugPrefix;

    static {
        kVerificationDebugPrefix = System.getProperty("introscope.agent.instrumentation.verification.debug");
        kIsVerificationDebugEnabled = kVerificationDebugPrefix != null;
    }

    protected ASingleCompiler(DGCompilerSettings settings, ICompilerLog log) {
        Assertion.wilyAssert(log != null);
        this.fSettings = settings;
        this.fLog = log;
    }

    protected final ICompilerLog getLog() {
        return this.fLog;
    }

    protected final DGCompilerSettings getSettings() {
        return this.fSettings;
    }

    public final void compileOneClass() throws DGClassException, IOException {
        IModeledClass targetClass = this.doNewModeledClass();
        long stamp = System.currentTimeMillis();
        if (kIsVerificationDebugEnabled) {
            this.dumpClassBytes(targetClass, stamp);
        }
        IClassMutator mutator = this.doNewMutator(targetClass);
        this.fLog.ICompilerLog_setCurrentClass(targetClass.getClassName());
        try {
            ClassSettingsApplier applier = this.getSettingsApplier(targetClass, mutator);
            applier.apply();
        }
        catch (DGSetAsSkippedException dGSetAsSkippedException) {
            this.fLog.ICompilerLog_setSkippedClass(targetClass.getClassName());
        }
        catch (DGAlreadyInstrumentedException dGAlreadyInstrumentedException) {
            this.fLog.ICompilerLog_logClassAlreadyInstrumented();
        }
        if (kIsVerificationDebugEnabled) {
            this.fLog.ICompilerLog_saveLastMutatedClass(targetClass);
            if (targetClass.getClassName().getPackageAndNameString().startsWith(kVerificationDebugPrefix)) {
                this.fLog.ICompilerLog_logLastMutatedClass();
            }
            this.dumpClassBytes(targetClass, stamp);
        }
        this.doCommit(targetClass, mutator);
    }

    private void dumpClassBytes(IModeledClass targetClass, long stamp) throws IOException {
        DGClass javaClass = (DGClass)targetClass;
        String pathPrefix = System.getProperty("introscope.agent.instrumentation.debugdump.path");
        if (pathPrefix != null && targetClass.getClassName().getPackageAndNameString().startsWith(kVerificationDebugPrefix)) {
            IClassName className = javaClass.getClassName();
            String modifier = javaClass.isDirty() ? "after.class" : "before.class";
            File debugFile = new File(String.valueOf(pathPrefix) + className.getReflectionFriendlyQualifiedNameString() + "." + stamp + modifier);
            FileOutputStream stream = new FileOutputStream(debugFile);
            javaClass.write(stream);
            stream.close();
        }
    }

    protected ClassSettingsApplier getSettingsApplier(IModeledClass targetClass, IClassMutator mutator) {
        ClassSettingsApplier applier = new ClassSettingsApplier(this.fSettings, this.fLog, targetClass, mutator);
        return applier;
    }

    protected abstract IModeledClass doNewModeledClass() throws DGClassException, IOException;

    protected abstract IClassMutator doNewMutator(IModeledClass var1) throws DGClassException, IOException;

    protected abstract void doCommit(IModeledClass var1, IClassMutator var2) throws DGClassException, IOException;
}

