/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.CommonFeatureHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.errors.ErrorReportingService;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.errors.ILegacyErrorFeature;
import com.wily.introscope.agent.errors.Throttle;
import com.wily.introscope.agent.feature.VirtualStackFeatureHelper;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IErrorSubscriber;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.SharedDataStructure2;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentErrorFeature;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.HashSet;
import java.util.Iterator;

public class ErrorFeature
implements ILegacyErrorFeature {
    private static final Module kModule = new Module("ErrorFeature");
    private static IAgent sAgent;
    public static Throttle sThrottle;
    public static int sThrottleCount;
    private static ConfigurationManager cm;
    private static PositiveIntegerConfigurationProperty throttleValue;
    private static PositiveIntegerConfigurationProperty sMaxUniqueErrCountInTxnProperty;
    public static final String kThrottleKey = "introscope.agent.errorsnapshots.throttle";
    public static final String kMaxUniqueErrorInTxnKey = "introscope.agent.errors.maxcount";
    public static final int DefaultThrottle = 10;
    public static final int sDefaultUniqueMaxErrCount = 10;
    public static int sMaxErrorCacheSize;
    private static volatile boolean throttleInitialized;
    private static volatile boolean bIsMaxUniqueErrCountInitialized;
    private static boolean fIntelligentInstrumentationEnabled;

    static {
        throttleInitialized = false;
        bIsMaxUniqueErrCountInitialized = false;
        try {
            fIntelligentInstrumentationEnabled = AgentShim.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.deep.instrumentation.enabled", true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static TransactionComponentData fetchErrorSnapshot(InvocationData data, String errorMessage) {
        Thread t = Thread.currentThread();
        Throwable error = data.getInvocationThrownException();
        return ErrorFeature.fetchErrorSnapshotExtend(data, t, error, errorMessage);
    }

    public static TransactionComponentData fetchErrorSnapshot(Throwable error, IStackElement data, String errorMessage) {
        Runnable t = null;
        t = InvocationData.getCacheHelper().isUseExternalThreadId() ? VirtualStack.getTransactionCache().getThread() : Thread.currentThread();
        return ErrorFeature.fetchErrorSnapshotExtend(data, t, error, errorMessage);
    }

    public static TransactionComponentData fetchErrorSnapshotExtend(IStackElement data, Runnable t, Throwable error, String errorMessage) {
        TransactionComponentData root = null;
        if (fIntelligentInstrumentationEnabled && data instanceof InvocationData) {
            int id = ((InvocationData)data).getInvocationId();
            HighPerformanceIntelligenceStackElement currentIIElement = null;
            HighPerformanceIntelligenceStackElement lastChildWithException = null;
            if (id != -1) {
                int exceptionElementCount = 0;
                currentIIElement = (HighPerformanceIntelligenceStackElement)HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getPopped();
                if (currentIIElement != null && currentIIElement.hasInvocationThrownException()) {
                    ++exceptionElementCount;
                    lastChildWithException = currentIIElement;
                    while (lastChildWithException != null && lastChildWithException.getLastChild() != null && lastChildWithException.hasInvocationThrownException() && lastChildWithException.getLastChild().hasInvocationThrownException() && exceptionElementCount < DeepTraceConfigurations.fMaxExceptionsCollected) {
                        HighPerformanceIntelligenceStackElement prevChildWithException = lastChildWithException;
                        lastChildWithException = (HighPerformanceIntelligenceStackElement)lastChildWithException.getLastChild();
                        if (prevChildWithException.getInvocationThrownException() == lastChildWithException.getInvocationThrownException()) continue;
                        ++exceptionElementCount;
                    }
                    if (lastChildWithException.getInvocationId() == id) {
                        lastChildWithException = null;
                    }
                    root = HighPerformanceIntelligentErrorFeature.fetchErrorSnapshot(data, t, error, currentIIElement, errorMessage, lastChildWithException);
                }
            }
            ErrorFeature.processErrorTrigger(data);
        }
        if (root == null) {
            return VirtualStackFeatureHelper.getTransactionSnapshotFromStack(data, t, error, errorMessage);
        }
        return root;
    }

    private static void processErrorTrigger(IStackElement stackElement) {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.setErrorSnapshotTriggered(true);
        HighPerformanceIntelligentErrorFeature.triggerAutoTracingForError(stackElement);
    }

    public static String fetchErrorMessage(InvocationData data) {
        Throwable error = data.getInvocationThrownException();
        if (error != null) {
            return String.valueOf(error.getClass().getName()) + ": " + error.getMessage();
        }
        return null;
    }

    public static boolean shouldPassThisErrorForSnapshot(String errorMessage, IAgent agent) {
        boolean isDebugEnabled = agent.IAgent_getModuleFeedback().isDebugEnabled();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        if (!throttleInitialized) {
            ErrorFeature.initializeThrottle(agent, feedback);
        }
        sThrottleCount = (Integer)throttleValue.getValue();
        sThrottle.setThrottle(sThrottleCount);
        if (ErrorReportingService.fIsSnapshotEnabled && !ErrorReportingService.shouldIgnore(errorMessage)) {
            if (sThrottle.request()) {
                return true;
            }
            if (isDebugEnabled) {
                feedback.debug(kModule, "Throttled an error snapshot");
            }
        }
        return false;
    }

    public static void constructAndSendErrorSnapshotToServer(InvocationData data, String errorMessage, IAgent agent) {
        Throwable error = data.getInvocationThrownException();
        ErrorFeature.constructAndSendErrorSnapshotToServer(data, error, errorMessage, agent);
    }

    public static void constructAndSendErrorSnapshotToServer(IStackElement data, Throwable error, String errorMessage, IAgent agent) {
        if (ErrorFeature.shouldPassThisErrorForSnapshot(errorMessage, agent)) {
            boolean isDebugEnabled = agent.IAgent_getModuleFeedback().isDebugEnabled();
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            TransactionComponentData tcdata = null;
            if (data != null) {
                tcdata = ErrorFeature.fetchErrorSnapshot(error, data, errorMessage);
                if (tcdata != null) {
                    agent.IAgent_queueEvent(tcdata);
                } else if (isDebugEnabled) {
                    feedback.debug(kModule, "constructAndSendErrorSnapshotToServer failed since the error snapshot was null");
                }
            }
        }
    }

    public static void constructAndSendErrorSnapshotToServerWithOtherStackElementOnTop(InvocationData data, String errorMessage, IAgent agent, IStackElement topElement) {
        if (ErrorFeature.shouldPassThisErrorForSnapshot(errorMessage, agent)) {
            boolean isDebugEnabled = agent.IAgent_getModuleFeedback().isDebugEnabled();
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            TransactionComponentData tcdata = null;
            if (data != null) {
                if (fIntelligentInstrumentationEnabled) {
                    tcdata = ErrorFeature.fetchErrorSnapshot(data.getInvocationThrownException(), topElement, errorMessage);
                }
                if (tcdata == null) {
                    tcdata = VirtualStackFeatureHelper.getTransactionSnapshotFromStack(topElement, Thread.currentThread(), data.getInvocationThrownException(), errorMessage);
                }
                if (tcdata != null) {
                    agent.IAgent_queueEvent(tcdata);
                } else if (isDebugEnabled) {
                    feedback.debug(kModule, "constructAndSendErrorSnapshotToServer failed since the error snapshot was null");
                }
            }
        }
    }

    public static void decorateTransactionsWithError(InvocationData data, String errMsg) {
        Throwable error = data.getInvocationThrownException();
        if (WilyTransactionStructure.getInstance().shouldTraceTransactionInstances(data)) {
            if (error != null) {
                data.put("Exception", InvocationData.limitSize(error.getMessage()));
            }
            String err = InvocationData.limitSize(errMsg);
            data.put("Error Message", err);
            TransactionCollectStatus dataTcs = data.getTransactionCollectionStatus();
            if (dataTcs != null) {
                dataTcs.getErrorsSeenInThisTxn().add(err);
            } else {
                IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
                feedback.warn(kModule, "decorateTransactionsWithError fails with null tcs. need to configure a tracer that creates tcs");
            }
        }
    }

    public static void decorateTransactionsWithErrorOnOtherStackElement(InvocationData data, String errMsg, IStackElement topElement) {
        Throwable error = data.getInvocationThrownException();
        if (WilyTransactionStructure.getInstance().shouldTraceTransactionInstances(data)) {
            if (error != null) {
                topElement.put("Exception", InvocationData.limitSize(error.getMessage()));
            }
            String err = InvocationData.limitSize(errMsg);
            topElement.put("Error Message", err);
            TransactionCollectStatus topTcs = topElement.getTransactionCollectionStatus();
            if (topTcs != null) {
                topTcs.getErrorsSeenInThisTxn().add(err);
            } else {
                IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
                feedback.warn(kModule, "decorateTransactionsWithErrorOnOtherStackElement fails with null tcs. need to configure a tracer that creates tcs");
            }
        }
    }

    public static void incrementErrorMetric(IStackElement stackData) {
        if (stackData != null) {
            ErrorFeature.incrementSelfErrorMetric(stackData);
            ErrorFeature.incrementUpstreamErrorMetric(stackData);
        }
    }

    public static boolean incrementSelfErrorMetric(IStackElement stackData) {
        boolean incrementedSelfMetric = false;
        int i = 0;
        while (i < stackData.getStartCursorsCount()) {
            IRepository sds;
            IErrorSubscriber errSub;
            ITransactionElement te = stackData.getStartCursorAt(i);
            if (te != null && (errSub = te.getErrorSubscriber()) != null && (sds = errSub.getLocalErrorRepository()) != null) {
                int hashcode = stackData.hashCode();
                sds.update(BlamePointTracer.getIncreaser(), 0L, stackData.getWallClockFinishTime(), hashcode);
                incrementedSelfMetric = true;
            }
            ++i;
        }
        return incrementedSelfMetric;
    }

    public static void incrementUpstreamErrorMetric(IStackElement stackData) {
        Iterator itr;
        IStackElement cursorData = stackData.getParent();
        int stackRecursionCounter = 0;
        while (cursorData != null) {
            if (cursorData instanceof WrappedInvocationData) {
                cursorData = cursorData.getParent();
                continue;
            }
            Iterator it = cursorData.getStartCursorsIterator();
            while (it != null && it.hasNext()) {
                IRepository sds;
                IErrorSubscriber errSub;
                ITransactionElement te = (ITransactionElement)it.next();
                if (te == null || (errSub = te.getErrorSubscriber()) == null || !errSub.subscribeToDownstreamErrors() || (sds = errSub.getLocalErrorRepository()) == null) continue;
                int hashcode = stackData.hashCode();
                sds.update(BlamePointTracer.getIncreaser(), 0L, MasterClock.currentTimeMillis(), hashcode);
            }
            if (stackRecursionCounter++ > StackRecursionHelper.kMaxRecursive) {
                throw new TransactionTransitionException("Exceeded depth of stack, most likely because the stack is corrupted.");
            }
            cursorData = cursorData.getParent();
        }
        if (stackData instanceof InvocationData && (itr = ((InvocationData)stackData).getAppMapSocketCursorsForMetricUpdate()) != null) {
            while (itr.hasNext()) {
                SocketTransactionElement socketCursor = (SocketTransactionElement)itr.next();
                socketCursor.getErrorRepository().update(BlamePointTracer.getIncreaser(), 0L, MasterClock.currentTimeMillis(), stackData.hashCode());
            }
        }
    }

    public static void incrementErrorMetric(WilyTransactionElement frontendNode, IStackElement stackData) {
        IRepository sds = frontendNode.getErrorsRepository();
        int hashcode = stackData.hashCode();
        sds.update(BlamePointTracer.getIncreaser(), 0L, stackData.getWallClockFinishTime(), hashcode);
    }

    private static void initializeThrottle(IAgent agent, IModuleFeedbackChannel feedback) {
        sThrottle = new Throttle(agent.IAgent_getCommonHeartbeat(), agent.IAgent_getModuleFeedback(), 10);
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        cm = agent.IAgent_getConfigurationManager();
        throttleValue = new PositiveIntegerConfigurationProperty(kThrottleKey, new Integer(10), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer);
        cm.add(throttleValue);
        throttleInitialized = true;
    }

    public static void createAndUpdateErrorRepository(String metricName, DataAccumulatorFactory dataAccumulatorFactory, IStackElement stackData, IAgent agent) {
        AgentMetric errorsPerIntervalMetric = RepositoryFactory.unSafeGetMetricOfType(agent, metricName, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
        AAgentMetricArray errorsPerIntervalMetricArray = AAgentMetricArray.getInstance(errorsPerIntervalMetric);
        IRepository newErrRep = new SharedDataStructure2(CountMetricGathererWrapper.getFactory(true));
        WilyTransactionStructure.getInstance();
        IRepository prevErrRep = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(errorsPerIntervalMetricArray, newErrRep);
        if (prevErrRep != null) {
            newErrRep = prevErrRep;
        }
        newErrRep.update(BlamePointTracer.getIncreaser(), 0L, stackData.getWallClockStartTime(), stackData.getWallClockFinishTime());
    }

    public static boolean evalErrorQualificationForCurrTxn(IAgent agent, Throwable error, String errMsg) {
        HashSet errorCache = VirtualStack.getTransactionCache().getErrorsSeenInThisTxn();
        if (!bIsMaxUniqueErrCountInitialized) {
            ErrorFeature.initializeErrorCount(agent);
        }
        if (ErrorReportingService.shouldIgnore(errMsg)) {
            return false;
        }
        if (error != null && errMsg != null) {
            if (errorCache.contains(error) || errorCache.contains(errMsg)) {
                return false;
            }
            errorCache.add(error);
            errorCache.add(errMsg);
            return true;
        }
        if (errMsg != null) {
            if (errorCache.contains(errMsg)) {
                return false;
            }
            return errorCache.add(errMsg);
        }
        return true;
    }

    private static void initializeErrorCount(IAgent agent) {
        ConfigurationManager localCm = agent.IAgent_getConfigurationManager();
        sMaxUniqueErrCountInTxnProperty = new PositiveIntegerConfigurationProperty(kThrottleKey, new Integer(10), "Hot_Property_Configuration_Property", null, true, true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        localCm.add(sMaxUniqueErrCountInTxnProperty);
        sMaxErrorCacheSize = (Integer)sMaxUniqueErrCountInTxnProperty.getValue();
        bIsMaxUniqueErrCountInitialized = true;
    }

    private void decorateTransactionsWithErrorOnOtherStackElement(String errMsg, IStackElement topElement) {
        if (WilyTransactionStructure.getInstance().shouldTraceTransactionInstances(topElement) && topElement != null) {
            String err = InvocationData.limitSize(errMsg);
            topElement.put("Error Message", err);
            TransactionCollectStatus topTcs = topElement.getTransactionCollectionStatus();
            if (topTcs != null) {
                topTcs.getErrorsSeenInThisTxn().add(err);
            } else {
                IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
                feedback.warn(kModule, "decorateTransactionsWithErrorOnOtherStackElement fails with null tcs. need to configure a tracer that creates tcs");
            }
        }
    }

    private void constructAndSendErrorSnapshotToServerWithOtherStackElementOnTop(String errorMessage, IAgent agent, IStackElement topElement) {
        if (ErrorFeature.shouldPassThisErrorForSnapshot(errorMessage, agent)) {
            boolean isDebugEnabled = agent.IAgent_getModuleFeedback().isDebugEnabled();
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            TransactionComponentData tcdata = null;
            tcdata = VirtualStackFeatureHelper.getTransactionSnapshotFromStack(topElement, Thread.currentThread(), null, errorMessage);
            if (tcdata != null) {
                agent.IAgent_queueEvent(tcdata);
            } else if (isDebugEnabled) {
                feedback.debug(kModule, "constructAndSendErrorSnapshotToServer failed since the error snapshot was null");
            }
        }
    }

    @Override
    public boolean flagErrorInManagedApplication(String errorMessage) {
        boolean result = false;
        if (ErrorFeature.evalErrorQualificationForCurrTxn(sAgent, null, errorMessage)) {
            IStackElement topElement = VirtualStack.peek();
            if (topElement != null) {
                this.decorateTransactionsWithErrorOnOtherStackElement(errorMessage, topElement);
                this.constructAndSendErrorSnapshotToServerWithOtherStackElementOnTop(errorMessage, sAgent, topElement);
                ErrorFeature.incrementUpstreamErrorMetric(topElement);
            }
            result = true;
        }
        return result;
    }

    public static int getMaxErrorCacheSize(IAgent agent) {
        if (!bIsMaxUniqueErrCountInitialized) {
            ErrorFeature.initializeErrorCount(agent);
        }
        return sMaxErrorCacheSize;
    }

    public static void startErrorFeature(IAgent agent) {
        sAgent = agent;
        ErrorSnapshotFeatureFactory.setAgent(agent);
        CommonFeatureHelper.registerFeature(new ErrorFeature());
    }

    @Override
    public String getFeatureKey() {
        return "ErrorFeature";
    }
}

