/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.introscope.agent.probe.net.ManagedSocketInputStream;
import com.wily.introscope.agent.probe.net.ManagedSocketOutputStream;
import com.wily.introscope.agent.probe.net.SocketMonitor;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;

public class ManagedSocket
extends Socket {
    private SocketMonitor fMonitor;

    ManagedSocket(SocketMonitor monitor) {
        this.fMonitor = monitor;
    }

    ManagedSocket(SocketMonitor monitor, SocketImpl impl) throws SocketException {
        super(impl);
        this.fMonitor = monitor;
    }

    public ManagedSocket() {
    }

    public ManagedSocket(SocketImpl impl) throws SocketException {
        super(impl);
    }

    public ManagedSocket(String host, int port) throws UnknownHostException, IOException {
        super(host, port);
        try {
            this.com_wily_initialize(host, port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedSocket(InetAddress address, int port) throws IOException {
        super(address, port);
        try {
            this.com_wily_initialize(address, port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        super(host, port, localAddr, localPort);
        try {
            this.com_wily_initialize(host, port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        super(address, port, localAddr, localPort);
        try {
            this.com_wily_initialize(address, port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedSocket(String host, int port, boolean stream) throws IOException {
        super(host, port, stream);
        try {
            this.com_wily_initialize(host, port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedSocket(InetAddress host, int port, boolean stream) throws IOException {
        super(host, port, stream);
        try {
            this.com_wily_initialize(host, port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedSocket(Proxy proxy) throws IOException {
        super(proxy);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        super.connect(endpoint);
        try {
            this.com_wily_initialize(this.getInetAddress(), this.getPort());
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(endpoint, timeout);
        try {
            this.com_wily_initialize(this.getInetAddress(), this.getPort());
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    private final void com_wily_initialize(InetAddress addr, int port) {
        try {
            this.com_wily_initialize(ManagedSocket.com_wily_safeGetNameFromInetAddress(addr), port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception initializing ManagedSocket InetAddress = " + addr + "; Port = " + port, t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean isSocketTraced(String addr, int port) {
        boolean traced = TracedSockets.isTraced(addr, port);
        if (!traced) {
            traced = TracedSockets.add(addr, port);
        }
        return traced;
    }

    static final String com_wily_safeGetNameFromInetAddress(InetAddress addr) {
        String host;
        block13: {
            host = null;
            if (addr != null) break block13;
            return "Unknown Host";
        }
        try {
            String ipAddress;
            InetAddress localhost;
            IAgent agent = null;
            IDnsService dnsService = null;
            try {
                agent = AgentShim.getAgent();
                dnsService = agent.IAgent_getDnsService();
                if (dnsService != null) {
                    host = dnsService.getDnsHostNameByIPAddr(addr);
                }
            }
            catch (Exception exception) {}
            if (host != null && host.length() > 0 && (host.equals("0.0.0.0") || host.equals("0.0.0.0.0.0")) && (localhost = InetAddress.getLocalHost()) != null && dnsService != null) {
                host = dnsService.getDnsHostNameByIPAddr(localhost);
            }
            if ((host == null || host.length() == 0) && (ipAddress = addr.getHostAddress()) != null) {
                host = ipAddress;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleDebug("ManagedSocket com_wily_safeGetNameFromInetAddress", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        if (host == null || host.length() == 0) {
            host = "Unknown Host";
        }
        return host;
    }

    private final void com_wily_initialize(String host, int port) {
        try {
            SocketMonitor monitor;
            if (this.fMonitor == null && this.isSocketTraced(host, port) && (monitor = SocketMonitor.getClientSocketMonitor(host, port)) != null) {
                monitor.eventOpen();
                this.fMonitor = monitor;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception initializing ManagedSocket host = " + host + "; Port = " + port, t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            SocketMonitor monitor = this.fMonitor;
            if (monitor != null) {
                monitor.eventClose();
                this.fMonitor = null;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception tracking a socket close", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = super.getInputStream();
        try {
            SocketMonitor monitor = this.fMonitor;
            if (in != null && monitor != null) {
                return new ManagedSocketInputStream(in, monitor);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception creating socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream out = super.getOutputStream();
        try {
            SocketMonitor monitor = this.fMonitor;
            if (out != null && monitor != null) {
                return new ManagedSocketOutputStream(out, monitor);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception creating socket output stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return out;
    }
}

