/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class BTThreadLocalAdministrator {
    private static IAgent fAgent;
    private static final Module kModule;
    public static final String kSustainabilityBaseMetricName = "Agent Stats|Sustainability|Browser Agent Business Transaction";
    public static final char kBrowserAgentCommaChar = ',';
    private String jarManifestAttributeName = null;
    private String jarManifestAttributeValue = null;
    private static final String SNIPPET_FILE_EXT_NAME = "basnippet";
    private static final String APP_ID_KEY_PATTERN = "[a-zA-Z0-9]+";
    private static volatile boolean autoInjectionEnabled;
    private static boolean sustainabilityMetricsOn;
    private static int throttleResponseLimit;
    private static volatile boolean headFilterPresenceCheckEnabled;
    private static volatile boolean tailFilterPresenceCheckEnabled;
    private static long snippetMaxSearchingLength;
    private static volatile int maxSearchCounter;
    private static volatile HashSet maxSearchReachedUrls;
    private static int searchingMethodHierarchyMaxDepth;
    private static boolean encodingEnabled;
    private static int autoskipInstrumentClassDepth;
    private static boolean responseCookieEnabled;
    private static int responseCookieExpirationTime;
    private static String responseCookieIncludeURLsRegex;
    private static Pattern responseCookieIncludeURLsRegexPattern;
    private static final String appGroupPrefix = "introscope.agent.browseragent.autoInjection";
    private static volatile String appGroupKeys;
    private static final String snippetLocationSuffix = "snippetLocation";
    private static final String includeURLsRegexSuffix = "includeURLsRegex";
    private static final String propSeparator = ".";
    private static List snippetLocationList;
    private static List snippetCodeList;
    private static List includeURLsRegexList;
    private static List compiledPatternList;
    private static IConfigurationListener configListener;
    private static String excludeResponseContentPatterns;
    private static String[] excludeResponseContentPatternsList;
    public static boolean reInitialize;
    private ThreadLocal stackData = new ThreadLocal(){

        public Object initialValue() {
            return new HashMap();
        }
    };

    static {
        kModule = new Module("BrowserAgent");
        autoInjectionEnabled = false;
        sustainabilityMetricsOn = true;
        throttleResponseLimit = 1000;
        headFilterPresenceCheckEnabled = true;
        tailFilterPresenceCheckEnabled = true;
        snippetMaxSearchingLength = 32768L;
        maxSearchCounter = 0;
        maxSearchReachedUrls = new HashSet();
        searchingMethodHierarchyMaxDepth = 3;
        encodingEnabled = false;
        autoskipInstrumentClassDepth = 1;
        responseCookieEnabled = false;
        responseCookieExpirationTime = 3;
        responseCookieIncludeURLsRegex = null;
        responseCookieIncludeURLsRegexPattern = null;
        appGroupKeys = null;
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
        excludeResponseContentPatterns = null;
        excludeResponseContentPatternsList = null;
        reInitialize = true;
    }

    public static boolean isReInitialize() {
        return reInitialize;
    }

    public static void setReInitialize(boolean value) {
        reInitialize = value;
    }

    private BTThreadLocalAdministrator() {
        try {
            fAgent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return;
        }
        boolean isUsingOldConfig = fAgent.IAgent_getComponentTracer().isAgentOldMode();
        if (!isUsingOldConfig) {
            this.initializeBAProperties();
        }
    }

    public static BTThreadLocalAdministrator getInstance() {
        return BTThreadLocalAdministratorInstance.kInstance;
    }

    public Object get(String key) {
        HashMap dataInstance = (HashMap)this.stackData.get();
        return dataInstance.get(key);
    }

    public void insert(String key, Object value) {
        if (key != null && value != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.put(key, value);
        }
    }

    public void remove(String key) {
        if (key != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.remove(key);
        }
    }

    public void flush() {
        HashMap dataInstance = (HashMap)this.stackData.get();
        dataInstance.clear();
    }

    public String getJarManifestAttributeName() {
        return this.jarManifestAttributeName;
    }

    public String getJarManifestAttributeValue() {
        return this.jarManifestAttributeValue;
    }

    public boolean isSustainabilityMetricEnabled() {
        return sustainabilityMetricsOn;
    }

    public String[] getExcludeResponseContentPatterns() {
        if (excludeResponseContentPatternsList != null && excludeResponseContentPatternsList.length > 0) {
            return excludeResponseContentPatternsList;
        }
        if (excludeResponseContentPatterns == null) {
            return null;
        }
        excludeResponseContentPatternsList = excludeResponseContentPatterns.split(String.valueOf(','));
        return excludeResponseContentPatternsList;
    }

    public int getThrottleLimit() {
        return throttleResponseLimit;
    }

    public int getSearchingMethodHierarchyMaxDepth() {
        return searchingMethodHierarchyMaxDepth;
    }

    public long getMaxResponseContentLengthForSearching() {
        return snippetMaxSearchingLength;
    }

    public boolean shouldCheckForHeadFilterPresence() {
        return headFilterPresenceCheckEnabled;
    }

    public void setHeadFilterPresenceCheckEnabled(boolean status) {
        headFilterPresenceCheckEnabled = status;
    }

    public boolean shouldCheckForTailFilterPresence() {
        return tailFilterPresenceCheckEnabled;
    }

    public void setTailFilterPresenceCheckEnabled(boolean status) {
        tailFilterPresenceCheckEnabled = status;
    }

    public void increaseMaxSearchCountAndRecordUrl(String url) {
        ++maxSearchCounter;
        maxSearchReachedUrls.add(url);
    }

    public void resetMaxSearchCountAndUrl() {
        maxSearchCounter = 0;
        maxSearchReachedUrls.clear();
    }

    public int getMaxSearchCount() {
        return maxSearchCounter;
    }

    public String getMaxSearchUrls() {
        return maxSearchReachedUrls.toString();
    }

    public boolean isEncodingSupport() {
        return encodingEnabled;
    }

    public int getAutoskipInstrumentClassDepth() {
        return autoskipInstrumentClassDepth;
    }

    private static void logErrorMessages(String message) {
        fAgent.IAgent_getModuleFeedback().error(kModule, message);
    }

    private static void logInfoMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isInfoEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().info(kModule, message);
        }
    }

    private static void logWarnMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isWarningEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().warn(kModule, message);
        }
    }

    private static void logDebugMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().debug(kModule, message);
        }
    }

    private static void logTraceMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().trace(kModule, message);
        }
    }

    private void initializeBAProperties() {
        this.jarManifestAttributeName = fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.browseragent.jarManifestAttributeName", "com-wily-Extension-Name");
        this.jarManifestAttributeValue = fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.browseragent.jarManifestAttributeValue", "Introscope Browser Agent Extension");
        excludeResponseContentPatterns = fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.browseragent.autoInjection.excludeResponseContentPatterns", null);
        fAgent.IAgent_getConfigurationManager().add(new AuotInjectionEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new AutoInjectionSnippetThrottleResponseLimitProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new HeadFilterPresenceCheckProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new TailFilterPresenceCheckProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new MaxResponseContentLengthForSearchingProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new SearchingMethodHierarchyMaxDepthProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new EncodingSupportEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new AutoskipInstrumentclassDepthProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new ResponseCookieEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new ResponseCookieExpirationTimeProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new ResponseCookieIncludeURLsRegexProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new SustainabilityMetricsProperty(fAgent), true);
    }

    public void stopReportSustainabilityMetrics() {
        try {
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookieEnabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookie.includeURLsRegex");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookie.expirationTime");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.responseCount");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingReached.count");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.unsupportedBrowsers.count");
        }
        catch (BadlyFormedNameException e) {
            BTThreadLocalAdministrator.logTraceMessages("BadlyFormedNameException:" + e.getMessage());
        }
        catch (MetricNotFoundException e) {
            BTThreadLocalAdministrator.logTraceMessages("MetricNotFoundException:" + e.getMessage());
        }
    }

    public void startReportingSustainabilityMetrics() {
        if (autoInjectionEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        if (responseCookieEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookieEnabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookieEnabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookie.includeURLsRegex").IStringEveryEventDataAccumulator_addString(responseCookieIncludeURLsRegex == null ? "" : responseCookieIncludeURLsRegex);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").ILongCounterDataAccumulator_setValue(snippetMaxSearchingLength);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit").IIntegerCounterDataAccumulator_setValue(throttleResponseLimit);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookie.expirationTime").IIntegerCounterDataAccumulator_setValue(responseCookieExpirationTime);
        if (encodingEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(0);
        }
    }

    private Pattern getRegexPattern(String regex) {
        Pattern pattern = null;
        if (regex != null) {
            try {
                pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                BTThreadLocalAdministrator.logWarnMessages("Regex pattern: " + regex + " is illegal.");
            }
        }
        BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("getRegexPattern(String regex)::pattern: ").append(pattern).toString());
        return pattern;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static synchronized String getSnippetCode(String filePath) {
        String snippetCode = null;
        try {
            if (filePath != null && filePath.length() > 0) {
                File file = new File(filePath);
                if (file != null && file.length() > 0L) {
                    String line;
                    if (!file.canRead()) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this file is not readable.");
                        return null;
                    }
                    String ext = BTThreadLocalAdministrator.getExtension(file);
                    if (ext == null || !ext.equalsIgnoreCase(SNIPPET_FILE_EXT_NAME)) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this file does not have correct extension.");
                        return null;
                    }
                    BufferedReader input = new BufferedReader(new FileReader(file));
                    StringBuffer buf = new StringBuffer();
                    while ((line = input.readLine()) != null) {
                        buf.append(line);
                        buf.append('\n');
                    }
                    snippetCode = buf.toString().trim();
                    if (snippetCode.length() < 1) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", the file is empty.");
                        return null;
                    }
                    return snippetCode;
                }
                BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this file is empty or not readable.");
                return null;
            }
            BTThreadLocalAdministrator.logErrorMessages("The file path is empty.");
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this file is not found.");
            return null;
        }
        catch (IOException iOException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this file could not be initialized.");
            return null;
        }
        catch (SecurityException securityException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", security denied access.");
            return null;
        }
        catch (Exception exception) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this file could not be initialized.");
            return null;
        }
    }

    private static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    private void removeSnippetProperties() {
        if (configListener != null) {
            fAgent.removeConfigurationListener(configListener);
            configListener = null;
        }
        appGroupKeys = null;
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
    }

    private void initializeSnippetProperties() {
        appGroupKeys = fAgent.IAgent_getIndexedProperties().getTrimmedProperty("introscope.agent.browseragent.autoInjection.appID");
        if (appGroupKeys != null && appGroupKeys.length() == 0) {
            appGroupKeys = null;
        }
        if (sustainabilityMetricsOn) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
        }
        if (appGroupKeys == null) {
            BTThreadLocalAdministrator.logWarnMessages("introscope.agent.browseragent.autoInjection.appID is not provided");
            return;
        }
        this.initializeLists();
        if (configListener == null) {
            configListener = new IConfigurationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void onChange(IndexedProperties props) {
                    if (!autoInjectionEnabled) return;
                    String changedAppIDs = props.getTrimmedProperty("introscope.agent.browseragent.autoInjection.appID");
                    if (changedAppIDs != null && changedAppIDs.length() == 0) {
                        changedAppIDs = null;
                    }
                    if (changedAppIDs == null && appGroupKeys != null) {
                        Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                        synchronized (BTThreadLocalAdministrator.class) {
                            appGroupKeys = changedAppIDs;
                            BTThreadLocalAdministrator.resetLists();
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            if (sustainabilityMetricsOn) {
                                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
                            }
                            BTThreadLocalAdministrator.logWarnMessages("introscope.agent.browseragent.autoInjection.appID is not provided or invalid");
                            return;
                        }
                    }
                    if (changedAppIDs != null && appGroupKeys == null) {
                        Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                        synchronized (BTThreadLocalAdministrator.class) {
                            appGroupKeys = changedAppIDs;
                            BTThreadLocalAdministrator.resetLists();
                            BTThreadLocalAdministrator.this.initializeLists();
                            // ** MonitorExit[var3_4] (shouldn't be in output)
                            if (sustainabilityMetricsOn) {
                                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
                            }
                            BTThreadLocalAdministrator.logInfoMessages("Value of the property introscope.agent.browseragent.autoInjection.appID has changed");
                            return;
                        }
                    }
                    if (changedAppIDs == null || appGroupKeys == null) return;
                    if (!changedAppIDs.equals(appGroupKeys)) {
                        Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                        synchronized (BTThreadLocalAdministrator.class) {
                            appGroupKeys = changedAppIDs;
                            BTThreadLocalAdministrator.resetLists();
                            BTThreadLocalAdministrator.this.initializeLists();
                            // ** MonitorExit[var3_5] (shouldn't be in output)
                            if (sustainabilityMetricsOn) {
                                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
                            }
                            BTThreadLocalAdministrator.logInfoMessages("Value of the property introscope.agent.browseragent.autoInjection.appID has changed");
                            return;
                        }
                    }
                    Class<BTThreadLocalAdministrator> clazz = BTThreadLocalAdministrator.class;
                    synchronized (BTThreadLocalAdministrator.class) {
                        BTThreadLocalAdministrator.reEvaluateLists(changedAppIDs, props);
                        // ** MonitorExit[var3_6] (shouldn't be in output)
                        return;
                    }
                }
            };
            fAgent.addConfigurationListener(configListener);
        }
    }

    private void initializeLists() {
        String groupKeys = appGroupKeys;
        if (groupKeys != null && groupKeys.length() > 0) {
            String[] strtok = groupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                String key = strtok[i].trim();
                String prefixWithKey = "introscope.agent.browseragent.autoInjection." + key;
                String appGroupSnippetLocationProp = String.valueOf(prefixWithKey) + propSeparator + snippetLocationSuffix;
                String appGroupIncludeURLsRegexProp = String.valueOf(prefixWithKey) + propSeparator + includeURLsRegexSuffix;
                String appGroupSnippetLocation = null;
                String appGroupIncludeURLsRegex = null;
                if (BTThreadLocalAdministrator.onlyContainsLetterAndNumber(key)) {
                    appGroupSnippetLocation = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(appGroupSnippetLocationProp);
                    appGroupIncludeURLsRegex = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(appGroupIncludeURLsRegexProp);
                }
                if (appGroupSnippetLocation != null && appGroupSnippetLocation.length() == 0) {
                    appGroupSnippetLocation = null;
                }
                if (appGroupIncludeURLsRegex != null && appGroupIncludeURLsRegex.length() == 0) {
                    appGroupIncludeURLsRegex = null;
                }
                includeURLsRegexList.add(i, appGroupIncludeURLsRegex);
                snippetLocationList.add(i, appGroupSnippetLocation);
                if (appGroupIncludeURLsRegex == null) {
                    BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupIncludeURLsRegexProp + " is not provided or invalid");
                    compiledPatternList.add(i, null);
                } else {
                    try {
                        Pattern compiledPattern = Pattern.compile(appGroupIncludeURLsRegex);
                        compiledPatternList.add(i, compiledPattern);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        BTThreadLocalAdministrator.logErrorMessages("PatternSyntaxException is thrown for " + appGroupIncludeURLsRegexProp + ", check your syntax. Pattern will be ignored");
                        compiledPatternList.add(i, null);
                    }
                }
                if (appGroupSnippetLocation == null) {
                    BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                    snippetCodeList.add(i, null);
                } else {
                    String snippetCode = BTThreadLocalAdministrator.getSnippetCode(appGroupSnippetLocation);
                    if (snippetCode == null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                        snippetCodeList.add(i, null);
                    } else {
                        snippetCodeList.add(i, snippetCode);
                    }
                }
                ++i;
            }
        }
    }

    private static boolean onlyContainsLetterAndNumber(String key) {
        Pattern p = Pattern.compile(APP_ID_KEY_PATTERN);
        if (p.matcher(key).matches()) {
            return true;
        }
        BTThreadLocalAdministrator.logWarnMessages(String.valueOf(key) + " is invalid for " + "introscope.agent.browseragent.autoInjection.appID" + ", the value only allows numbers and letters");
        return false;
    }

    private static void resetLists() {
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
    }

    private static void reEvaluateLists(String groupKeys, IndexedProperties props) {
        ArrayList<String> localSnippetLocationList = new ArrayList<String>();
        ArrayList<String> localSnippetCodeList = new ArrayList<String>();
        ArrayList<String> localIncludeURLsRegexList = new ArrayList<String>();
        ArrayList<Pattern> localCompiledPatternList = new ArrayList<Pattern>();
        List[] listArray = new List[]{localSnippetLocationList, localSnippetCodeList, localIncludeURLsRegexList, localCompiledPatternList};
        boolean changedSnippetLocation = false;
        boolean changedIncludeURLsRegex = false;
        if (groupKeys != null && groupKeys.length() > 0) {
            String[] strtok = groupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                String key = strtok[i].trim();
                String prefixWithKey = "introscope.agent.browseragent.autoInjection." + key;
                String appGroupSnippetLocationProp = String.valueOf(prefixWithKey) + propSeparator + snippetLocationSuffix;
                String appGroupIncludeURLsRegexProp = String.valueOf(prefixWithKey) + propSeparator + includeURLsRegexSuffix;
                String appGroupSnippetLocation = null;
                String appGroupIncludeURLsRegex = null;
                if (BTThreadLocalAdministrator.onlyContainsLetterAndNumber(key)) {
                    appGroupSnippetLocation = props.getTrimmedProperty(appGroupSnippetLocationProp);
                    appGroupIncludeURLsRegex = props.getTrimmedProperty(appGroupIncludeURLsRegexProp);
                }
                if (appGroupIncludeURLsRegex != null && appGroupIncludeURLsRegex.length() == 0) {
                    appGroupIncludeURLsRegex = null;
                }
                if (appGroupIncludeURLsRegex == null) {
                    if (includeURLsRegexList.get(i) != null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value of the property " + appGroupIncludeURLsRegexProp + " is not provided or invalid");
                        changedIncludeURLsRegex = true;
                    }
                    localCompiledPatternList.add(i, null);
                } else if (!appGroupIncludeURLsRegex.equals((String)includeURLsRegexList.get(i))) {
                    BTThreadLocalAdministrator.logTraceMessages("Value of the property " + appGroupIncludeURLsRegexProp + " has changed");
                    changedIncludeURLsRegex = true;
                    try {
                        Pattern compiledPattern = Pattern.compile(appGroupIncludeURLsRegex);
                        localCompiledPatternList.add(i, compiledPattern);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        BTThreadLocalAdministrator.logErrorMessages("PatternSyntaxException is thrown for " + appGroupIncludeURLsRegexProp + ", check your syntax. Pattern will be ignored");
                        localCompiledPatternList.add(i, null);
                    }
                } else {
                    localCompiledPatternList.add(i, (Pattern)compiledPatternList.get(i));
                }
                if (appGroupSnippetLocation != null && appGroupSnippetLocation.length() == 0) {
                    appGroupSnippetLocation = null;
                }
                if (appGroupSnippetLocation == null) {
                    if (snippetLocationList.get(i) != null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                        changedSnippetLocation = true;
                    }
                    localSnippetCodeList.add(i, null);
                } else if (!appGroupSnippetLocation.equals((String)snippetLocationList.get(i))) {
                    BTThreadLocalAdministrator.logTraceMessages("Value of the property " + appGroupSnippetLocationProp + " has changed");
                    changedSnippetLocation = true;
                    String snippetCode = BTThreadLocalAdministrator.getSnippetCode(appGroupSnippetLocation);
                    if (snippetCode == null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                        localSnippetCodeList.add(i, null);
                    } else {
                        localSnippetCodeList.add(i, snippetCode);
                    }
                } else {
                    localSnippetCodeList.add(i, (String)snippetCodeList.get(i));
                }
                localSnippetLocationList.add(i, appGroupSnippetLocation);
                localIncludeURLsRegexList.add(i, appGroupIncludeURLsRegex);
                ++i;
            }
            if (changedIncludeURLsRegex) {
                includeURLsRegexList = localIncludeURLsRegexList;
                compiledPatternList = localCompiledPatternList;
            }
            if (changedSnippetLocation) {
                snippetLocationList = localSnippetLocationList;
                snippetCodeList = localSnippetCodeList;
            }
        }
    }

    public boolean isAutoInjectionEnabled() {
        return autoInjectionEnabled;
    }

    public Boolean isResponseCookieEnabled() {
        return responseCookieEnabled;
    }

    public List getSnippetCodeList() {
        return snippetCodeList;
    }

    public List getCompiledPatternList() {
        return compiledPatternList;
    }

    public Pattern getResponseCookieIncludeURLsRegexPattern() {
        return responseCookieIncludeURLsRegexPattern;
    }

    public static int getResponseCookieExpirationTime() {
        return responseCookieExpirationTime;
    }

    /* synthetic */ BTThreadLocalAdministrator(BTThreadLocalAdministrator bTThreadLocalAdministrator) {
        this();
    }

    final class AuotInjectionEnabledProperty
    extends BooleanConfigurationProperty {
        private AuotInjectionEnabledProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjectionEnabled", new Boolean(false), "Enables/Disables Auto Snippet Injection for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            reInitialize = true;
            autoInjectionEnabled = (Boolean)newValue;
            if (autoInjectionEnabled) {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(1);
                }
                BTThreadLocalAdministrator.this.initializeSnippetProperties();
                BTThreadLocalAdministrator.logDebugMessages("Auto Snippet Injection is enabled");
            } else {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(0);
                }
                BTThreadLocalAdministrator.this.removeSnippetProperties();
                BTThreadLocalAdministrator.logDebugMessages("Auto Snippet Injection is disabled");
            }
        }
    }

    final class AutoInjectionSnippetThrottleResponseLimitProperty
    extends PositiveIntegerConfigurationProperty {
        private AutoInjectionSnippetThrottleResponseLimitProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjection.throttleResponseLimit", new Integer(1000), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            throttleResponseLimit = (Integer)newValue;
            reInitialize = true;
            if (throttleResponseLimit >= 0) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.throttleResponseLimit").append(" is set to ").append(throttleResponseLimit).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.throttleResponseLimit").append(" cannot be set to a negative value ").append(throttleResponseLimit).append(", this property will be set to the default value ").append(1000).toString());
                throttleResponseLimit = 1000;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit").IIntegerCounterDataAccumulator_setValue(throttleResponseLimit);
            }
        }
    }

    final class AutoskipInstrumentclassDepthProperty
    extends PositiveIntegerConfigurationProperty {
        private AutoskipInstrumentclassDepthProperty(IAgent agent) {
            super("introscope.agent.browseragent.instrumentclass.autoskip.depth", new Integer(1), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            autoskipInstrumentClassDepth = (Integer)newValue;
            BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.instrumentclass.autoskip.depth").append(" is set to ").append(autoskipInstrumentClassDepth).toString());
        }
    }

    private static final class BTThreadLocalAdministratorInstance {
        public static final BTThreadLocalAdministrator kInstance = new BTThreadLocalAdministrator(null);

        private BTThreadLocalAdministratorInstance() {
        }
    }

    final class EncodingSupportEnabledProperty
    extends BooleanConfigurationProperty {
        private EncodingSupportEnabledProperty(IAgent agent) {
            super("introscope.agent.browseragent.contentencoding.enabled", new Boolean(false), "Enables/Disables encoding support property for browser agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            encodingEnabled = (Boolean)newValue;
            if (encodingEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Content encoding support is enabled");
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(1);
                }
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Content encoding support is disabled");
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(0);
                }
            }
        }
    }

    final class HeadFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private HeadFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.browseragent.checkHeadFilterPresence.enabled", new Boolean(true), "Enables/Disables head filter presence check for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            headFilterPresenceCheckEnabled = (Boolean)newValue;
            if (headFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Head filter presence check is enabled");
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Head filter presence check is disabled");
            }
        }
    }

    final class MaxResponseContentLengthForSearchingProperty
    extends PositiveLongConfigurationProperty {
        private MaxResponseContentLengthForSearchingProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength", new Long(32768L), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            snippetMaxSearchingLength = (Long)newValue;
            if (snippetMaxSearchingLength >= 0L) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").append(" is set to ").append(snippetMaxSearchingLength).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").append(" cannot be set to a negative value ").append(snippetMaxSearchingLength).append(", this property will be set to the default value ").append(32768L).toString());
                snippetMaxSearchingLength = 32768L;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").ILongCounterDataAccumulator_setValue(snippetMaxSearchingLength);
            }
        }
    }

    final class ResponseCookieEnabledProperty
    extends BooleanConfigurationProperty {
        private ResponseCookieEnabledProperty(IAgent agent) {
            super("introscope.agent.browseragent.responseCookieEnabled", new Boolean(false), "Enables/Disables Response Cookie for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            reInitialize = true;
            responseCookieEnabled = (Boolean)newValue;
            if (responseCookieEnabled) {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookieEnabled").IIntegerCounterDataAccumulator_setValue(1);
                }
                BTThreadLocalAdministrator.logDebugMessages("Response Cookie is enabled");
            } else {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookieEnabled").IIntegerCounterDataAccumulator_setValue(0);
                }
                BTThreadLocalAdministrator.logDebugMessages("Response Cookie is disabled");
            }
        }
    }

    final class ResponseCookieExpirationTimeProperty
    extends PositiveIntegerConfigurationProperty {
        private ResponseCookieExpirationTimeProperty(IAgent agent) {
            super("introscope.agent.browseragent.responseCookie.expirationTime", new Integer(3), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            responseCookieExpirationTime = (Integer)newValue;
            if (responseCookieExpirationTime >= 0) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.responseCookie.expirationTime").append(" is set to ").append(responseCookieExpirationTime).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.responseCookie.expirationTime").append(" cannot be set to a negative value ").append(responseCookieExpirationTime).append(", this property will be set to the default value ").append(3).toString());
                responseCookieExpirationTime = 3;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookie.expirationTime").IIntegerCounterDataAccumulator_setValue(responseCookieExpirationTime);
            }
        }
    }

    final class ResponseCookieIncludeURLsRegexProperty
    extends ConfigurationProperty {
        private ResponseCookieIncludeURLsRegexProperty(IAgent agent) {
            super("introscope.agent.browseragent.responseCookie.includeURLsRegex", "", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            responseCookieIncludeURLsRegex = (String)newValue;
            if (responseCookieIncludeURLsRegex.trim().length() > 0) {
                responseCookieIncludeURLsRegexPattern = BTThreadLocalAdministrator.this.getRegexPattern(responseCookieIncludeURLsRegex);
                if (responseCookieIncludeURLsRegexPattern != null) {
                    BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.responseCookie.includeURLsRegex").append(" is set to ").append(responseCookieIncludeURLsRegex).toString());
                } else {
                    BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.responseCookie.includeURLsRegex").append(" not in the correct format. Please follow the user documentation.").toString());
                    responseCookieIncludeURLsRegexPattern = null;
                }
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.responseCookie.includeURLsRegex").append("  cannot be set to an empty string ").append(", this property will be set to the empty value ").toString());
                responseCookieIncludeURLsRegex = null;
                responseCookieIncludeURLsRegexPattern = null;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.responseCookie.includeURLsRegex").IStringEveryEventDataAccumulator_addString(responseCookieIncludeURLsRegex == null ? "" : responseCookieIncludeURLsRegex);
            }
        }
    }

    final class SearchingMethodHierarchyMaxDepthProperty
    extends PositiveIntegerConfigurationProperty {
        private SearchingMethodHierarchyMaxDepthProperty(IAgent agent) {
            super("introscope.agent.browseragent.searchingmethodhierarchy.max.depth", new Integer(3), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            searchingMethodHierarchyMaxDepth = (Integer)newValue;
            if (searchingMethodHierarchyMaxDepth >= 0) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.searchingmethodhierarchy.max.depth").append(" is set to ").append(searchingMethodHierarchyMaxDepth).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.searchingmethodhierarchy.max.depth").append(" cannot be set to a negative value ").append(searchingMethodHierarchyMaxDepth).append(", this property will be set to the default value ").append(3).toString());
                searchingMethodHierarchyMaxDepth = 3;
            }
        }
    }

    final class SustainabilityMetricsProperty
    extends BooleanConfigurationProperty {
        private SustainabilityMetricsProperty(IAgent agent) {
            super("introscope.agent.browseragent.sustainabilityMetrics.enabled", new Boolean(true), "Enables/Disables Sustainability Metrics for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sustainabilityMetricsOn = (Boolean)newValue;
            reInitialize = true;
            if (sustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.startReportingSustainabilityMetrics();
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.sustainabilityMetrics.enabled").IIntegerCounterDataAccumulator_setValue(1);
                BTThreadLocalAdministrator.logDebugMessages("Sustainability Metrics is enabled");
            } else {
                BTThreadLocalAdministrator.this.stopReportSustainabilityMetrics();
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.sustainabilityMetrics.enabled").IIntegerCounterDataAccumulator_setValue(0);
                BTThreadLocalAdministrator.logDebugMessages("Sustainability Metrics is disabled");
            }
        }
    }

    final class TailFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private TailFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.browseragent.checkTailFilterPresence.enabled", new Boolean(true), "Enables/Disables tail filter presence check for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            tailFilterPresenceCheckEnabled = (Boolean)newValue;
            if (tailFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Tail filter presence check is enabled");
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Tail filter Presence check is disabled");
            }
        }
    }
}

