/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.transactiontrace.ASamplingFilter;
import com.wily.introscope.agent.transactiontrace.ITransactionEnvironment;
import com.wily.introscope.agent.transactiontrace.SamplingHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FirstNPerIntervalSamplingFilter
extends ASamplingFilter {
    private ITransactionEnvironment fTransactionEnv;
    private static ThreadLocal sFilterPassIndicator = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public FirstNPerIntervalSamplingFilter(IntervalHeartbeat hb, IndexedProperties indexedProperties, ITransactionEnvironment transactionEnv, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.fTransactionEnv = transactionEnv;
        SamplingHelper.initIfNeccessary();
    }

    public void updateSamplingInteval(long samplingInterval) {
        SamplingHelper.updateSamplingDuration(samplingInterval);
    }

    public void updateSamplesPerInterval(int samplesPerInterval) {
        SamplingHelper.updateSamplesPerInterval(samplesPerInterval);
    }

    public boolean isSamplingSetInAgentProperties() {
        return SamplingHelper.isSamplingSetInAgentProperties();
    }

    public int ITransactionTraceFilter_getFilterType() {
        return -1;
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return null;
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        return null;
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        return null;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        boolean result = (Boolean)sFilterPassIndicator.get();
        sFilterPassIndicator.set(Boolean.FALSE);
        return result;
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
    }

    public boolean isHeadFilter() {
        return true;
    }

    public boolean shouldCollect(Map parameters) {
        boolean result;
        boolean bl = result = this.fTransactionEnv.isURLTracingContext() && SamplingHelper.samplingCountdownNotExpired();
        if (result) {
            this.setPassedFilter();
        }
        return result;
    }

    private void setPassedFilter() {
        sFilterPassIndicator.set(Boolean.TRUE);
    }

    public Set getFilterTypes() {
        return Collections.EMPTY_SET;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

