/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer;

import com.wily.introscope.agent.AgentAdapter;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiAgentPlugin;
import com.wily.introscope.agent.activation.IOSGiPlugin;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.transformer.AssemblyFileTransformer;
import com.wily.introscope.agent.transformer.AssemblyFileTransformerShouldNotRunException;
import com.wily.introscope.agent.transformer.ClassFileTransformer;
import com.wily.introscope.agent.transformer.ClassFileTransformerShouldNotRunException;
import com.wily.introscope.agent.transformer.IInstrumentationAcceptor;
import com.wily.introscope.agent.transformer.IMethodTransformer;
import com.wily.introscope.agent.transformer.OnInstrumentationAcceptedCallback;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.extension.IPluginLoaderCallback;
import com.wily.introscope.extension.PlatformCheckUtil;
import com.wily.introscope.extension.PluginLoader;
import com.wily.util.adt.IStringDictionaryReader;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TransformerAdministrator {
    private static final String kTransformerPluginType = "transformer";
    private static final String kAssemblyTransformerPluginType = "assemblytransformer";
    private static final int kCurrentTransformerPluginVersion = 2;
    private static final String kTransformerOrderKey = "Order";
    private static final int kDefaultTransformerOrder = 0;
    private static final Class[] kTransformerConstructorParameterTypes = new Class[]{IAgent.class};
    private static volatile boolean sTransformerRequired = true;
    private final IAgent fAgent;
    private List fTransformers;
    private List fMethodTransformers;
    private boolean fHasWarnedAboutNoConfiguredTransformers;
    private List fAssemblyTransformers;

    public static void setTransformerRequired(boolean required) {
        sTransformerRequired = required;
    }

    public TransformerAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fTransformers = Collections.EMPTY_LIST;
        this.fMethodTransformers = Collections.EMPTY_LIST;
        this.fHasWarnedAboutNoConfiguredTransformers = false;
        this.fAssemblyTransformers = Collections.EMPTY_LIST;
        this.loadTransformerPlugins(agent);
        this.loadOSGiPlugins(agent);
        this.loadAssemblyTransformerPlugins(agent);
    }

    private final IAgent getAgent() {
        return this.fAgent;
    }

    private final IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private final IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    private final void loadTransformerPlugins(final IAgent agent) {
        ExtensionAdministrator extensionAdministrator = agent.IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kTransformerPluginType);
        int i = 0;
        while (i < plugins.length) {
            this.loadTransformerPlugin(agent, plugins[i]);
            ++i;
        }
        extensionAdministrator.setGlobalPluginCallbackByType(kTransformerPluginType, new IPlugin.IPluginCallback(){

            public void onUnload(IPlugin p) {
            }

            public void onLoad(IPlugin p) {
                TransformerAdministrator.this.loadTransformerPlugin(agent, p);
            }
        });
    }

    private void loadOSGiPlugins(final IAgent agent) {
        if (!PlatformCheckUtil.getInstance().isOsgiEnvironment()) {
            return;
        }
        PluginLoader.loadPlugins("com.wily.introscope.agent.transformer", new IPluginLoaderCallback(){

            public void onExtensionFound(Object configurationElement, Object extension) {
                IOSGiPlugin plugin = (IOSGiPlugin)extension;
                if (plugin != null && plugin instanceof IOSGiAgentPlugin) {
                    try {
                        plugin = ((IOSGiAgentPlugin)plugin).getInstance(agent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        plugin = null;
                    }
                }
                if (plugin != null && plugin instanceof ClassFileTransformer) {
                    TransformerAdministrator.this.registerTransformer(plugin.getName(), 100, (ClassFileTransformer)((Object)plugin));
                }
            }
        });
    }

    private final void loadAssemblyTransformerPlugins(IAgent agent) {
        ExtensionAdministrator extensionAdministrator = agent.IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] additionalplugins = extensionAdministrator.getAgentPluginsByType(kAssemblyTransformerPluginType);
        int i = 0;
        while (i < additionalplugins.length) {
            this.loadAssemblyTransformerPlugin(agent, additionalplugins[i]);
            ++i;
        }
    }

    private final void loadAssemblyTransformerPlugin(IAgent agent, IPlugin plugin) {
        AssemblyFileTransformer transformer = this.createAssemblyTransformer(agent, plugin);
        if (transformer != null) {
            int order = this.getOrderParameter(plugin);
            if (transformer instanceof AssemblyFileTransformer) {
                this.registerAssemblyTransformer(plugin.IPlugin_getName(), order, transformer);
            }
            agent.IAgent_getModuleFeedback().verbose(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transformer_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
        }
    }

    private final AssemblyFileTransformer createAssemblyTransformer(IAgent agent, IPlugin plugin) {
        Class transformerClass = ExtensionUtilities.loadEntryPointClass(agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer(), plugin, 2, AssemblyFileTransformer.class);
        if (transformerClass != null) {
            try {
                IStringLocalizer localizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(agent.IAgent_getStringLocalizer());
                IAgent proxyAgent = AgentAdapter.createAdapter(agent, localizer);
                Constructor constructor = transformerClass.getConstructor(kTransformerConstructorParameterTypes);
                return (AssemblyFileTransformer)constructor.newInstance(proxyAgent);
            }
            catch (InvocationTargetException ite) {
                Throwable target = ite.getTargetException();
                if (target instanceof AssemblyFileTransformerShouldNotRunException) {
                    agent.IAgent_getModuleFeedback().debug(target);
                } else {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", transformerClass.getName()));
                    agent.IAgent_getModuleFeedback().verbose(target);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", transformerClass.getName()));
            }
            catch (SecurityException securityException) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", transformerClass.getName()));
            }
            catch (Throwable t) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", transformerClass.getName()));
                agent.IAgent_getModuleFeedback().verbose(t);
            }
        }
        return null;
    }

    public final synchronized void registerAssemblyTransformer(String name, int order, AssemblyFileTransformer transformer) {
        ArrayList<TransformerEntry> transformers = new ArrayList<TransformerEntry>();
        transformers.addAll(this.fAssemblyTransformers);
        transformers.add(new TransformerEntry(name, order, transformer));
        Collections.sort(transformers);
        this.fAssemblyTransformers = transformers;
    }

    private final synchronized List getAssemblyTransformers() {
        return this.fAssemblyTransformers;
    }

    public void transformAssembly(int assemblyID, String assemblyPath) {
        List transformers = this.getAssemblyTransformers();
        if (!transformers.isEmpty()) {
            int i = 0;
            while (i < transformers.size()) {
                TransformerEntry entry = (TransformerEntry)transformers.get(i);
                this.doTransformAssembly(entry.getName(), (AssemblyFileTransformer)entry.getTransformer(), assemblyID, assemblyPath);
                ++i;
            }
        }
    }

    private void doTransformAssembly(String transformerName, AssemblyFileTransformer transformer, int assemblyID, String assemblyPath) {
        try {
            transformer.transform(assemblyID, assemblyPath);
        }
        catch (Exception e) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Method_Transformer_Transform_Error_Message", transformerName, String.valueOf(assemblyID), assemblyPath));
            this.getModuleFeedback().verbose(e);
        }
    }

    private final void loadTransformerPlugin(IAgent agent, final IPlugin plugin) {
        final ClassFileTransformer transformer = this.createTransformer(agent, plugin);
        if (transformer != null) {
            final int order = this.getOrderParameter(plugin);
            this.registerTransformer(plugin.IPlugin_getName(), order, transformer);
            if (transformer instanceof IMethodTransformer) {
                this.registerMethodTransformer(plugin.IPlugin_getName(), order, (IMethodTransformer)((Object)transformer));
            }
            if (transformer instanceof IInstrumentationAcceptor) {
                ((IInstrumentationAcceptor)((Object)transformer)).setAgentClassLoader(this.getClass().getClassLoader());
            }
            agent.IAgent_getModuleFeedback().verbose(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transformer_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
            if (plugin != null) {
                plugin.IPlugin_setCallback(new IPlugin.IPluginCallback(){

                    public void onUnload(IPlugin p) {
                        TransformerAdministrator.this.unregisterTransformer(plugin.IPlugin_getName(), order, transformer);
                        if (transformer instanceof IMethodTransformer) {
                            TransformerAdministrator.this.unregisterMethodTransformer(plugin.IPlugin_getName(), order, (IMethodTransformer)((Object)transformer));
                        }
                    }

                    public void onLoad(IPlugin p) {
                    }
                });
            }
        }
    }

    private final ClassFileTransformer createTransformer(IAgent agent, IPlugin plugin) {
        Class transformerClass = ExtensionUtilities.loadEntryPointClass(agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer(), plugin, 2, ClassFileTransformer.class);
        if (transformerClass != null) {
            try {
                IStringLocalizer localizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(agent.IAgent_getStringLocalizer());
                IAgent proxyAgent = AgentAdapter.createAdapter(agent, localizer);
                Constructor constructor = transformerClass.getConstructor(kTransformerConstructorParameterTypes);
                return (ClassFileTransformer)constructor.newInstance(proxyAgent);
            }
            catch (InvocationTargetException ite) {
                Throwable target = ite.getTargetException();
                if (target instanceof ClassFileTransformerShouldNotRunException) {
                    agent.IAgent_getModuleFeedback().debug(target);
                } else {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", transformerClass.getName()));
                    agent.IAgent_getModuleFeedback().verbose(target);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", transformerClass.getName()));
            }
            catch (SecurityException securityException) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", transformerClass.getName()));
            }
            catch (Throwable t) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", transformerClass.getName()));
                agent.IAgent_getModuleFeedback().verbose(t);
            }
        }
        return null;
    }

    private final int getOrderParameter(IPlugin plugin) {
        IStringDictionaryReader attributesReader = plugin.IPlugin_getAttributes();
        String orderString = attributesReader.getValue(kTransformerOrderKey);
        if (orderString != null) {
            try {
                return Integer.parseInt(orderString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final synchronized void registerTransformer(String name, int order, ClassFileTransformer transformer) {
        ArrayList<TransformerEntry> transformers = new ArrayList<TransformerEntry>();
        transformers.addAll(this.fTransformers);
        transformers.add(new TransformerEntry(name, order, transformer));
        Collections.sort(transformers);
        this.fTransformers = transformers;
    }

    public final synchronized void registerMethodTransformer(String name, int order, IMethodTransformer transformer) {
        ArrayList<TransformerEntry> transformers = new ArrayList<TransformerEntry>();
        transformers.addAll(this.fMethodTransformers);
        transformers.add(new TransformerEntry(name, order, transformer));
        Collections.sort(transformers);
        this.fMethodTransformers = transformers;
    }

    private final synchronized List getTransformers() {
        return this.fTransformers;
    }

    private final synchronized List getMethodTransformers() {
        return this.fMethodTransformers;
    }

    private synchronized void warnAboutNoConfiguredTransformers() {
        if (!this.fHasWarnedAboutNoConfiguredTransformers) {
            this.fHasWarnedAboutNoConfiguredTransformers = true;
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Transformer_No_Transformers_Configured_Message"));
        }
    }

    public final byte[] transformClass(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classBytes) {
        byte[] current = classBytes;
        List transformers = this.getTransformers();
        if (!transformers.isEmpty()) {
            int i = 0;
            while (i < transformers.size()) {
                TransformerEntry entry = (TransformerEntry)transformers.get(i);
                current = this.doTransformClass(entry.getName(), entry.getClassTransformer(), classLoaderIsAvailable, loader, className, classBeingRedefined, protectionDomain, current);
                ++i;
            }
        } else {
            this.warnAboutNoConfiguredTransformers();
        }
        return current == classBytes ? null : current;
    }

    private byte[] doTransformClass(String transformerName, ClassFileTransformer transformer, boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classBytes) {
        byte[] results = null;
        try {
            results = transformer.transform(classLoaderIsAvailable, loader, className, classBeingRedefined, protectionDomain, classBytes);
        }
        catch (Exception e) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transformer_Transform_Error_Message", transformerName, className));
            this.getModuleFeedback().verbose(e);
        }
        return results == null ? classBytes : results;
    }

    public byte[] transformMethod(IModeledClass modeledClass, IModeledMethod modeledMethod, byte[] methodBytes, Object contextCallback) {
        byte[] current = methodBytes;
        List transformers = this.getMethodTransformers();
        if (!transformers.isEmpty()) {
            int i = 0;
            while (i < transformers.size()) {
                TransformerEntry entry = (TransformerEntry)transformers.get(i);
                current = this.doTransformMethod(entry.getName(), entry.getMethodTransformer(), modeledClass, modeledMethod, current, contextCallback);
                ++i;
            }
        } else {
            this.warnAboutNoConfiguredTransformers();
        }
        return current == methodBytes ? null : current;
    }

    private byte[] doTransformMethod(String transformerName, IMethodTransformer transformer, IModeledClass modeledClass, IModeledMethod modeledMethod, byte[] methodBytes, Object contextCallback) {
        byte[] results = null;
        try {
            results = transformer.transform(modeledClass, modeledMethod, methodBytes, contextCallback);
        }
        catch (Exception e) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Method_Transformer_Transform_Error_Message", transformerName, modeledClass.getClassName().getContainerAndPackageAndNameString(), modeledMethod.getMethodName().getNameString()));
            this.getModuleFeedback().verbose(e);
        }
        return results == null ? methodBytes : results;
    }

    public void setInstrumentation(Object instrumentation, OnInstrumentationAcceptedCallback callback) {
        List transformers = this.getTransformers();
        if (!transformers.isEmpty()) {
            int i = 0;
            while (i < transformers.size()) {
                TransformerEntry entry = (TransformerEntry)transformers.get(i);
                ClassFileTransformer transformer = entry.getClassTransformer();
                if (transformer instanceof IInstrumentationAcceptor) {
                    ((IInstrumentationAcceptor)((Object)transformer)).setInstrumentation(instrumentation, callback);
                }
                ++i;
            }
        } else {
            this.warnAboutNoConfiguredTransformers();
        }
    }

    public IDynamicInstrumentationTransformer getDynamicInstrumentationTransformer() {
        IDynamicInstrumentationTransformer dynamicTransformer = null;
        List transformers = this.getTransformers();
        if (!transformers.isEmpty()) {
            int i = 0;
            while (i < transformers.size()) {
                TransformerEntry entry = (TransformerEntry)transformers.get(i);
                ClassFileTransformer transformer = entry.getClassTransformer();
                if (transformer instanceof IDynamicInstrumentationTransformer) {
                    dynamicTransformer = (IDynamicInstrumentationTransformer)((Object)transformer);
                    break;
                }
                ++i;
            }
        } else if (sTransformerRequired) {
            this.warnAboutNoConfiguredTransformers();
        }
        if (dynamicTransformer == null && sTransformerRequired) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Transformer_No_Dynamic_Instrumentation_Message"));
        }
        return dynamicTransformer;
    }

    public void unregisterTransformer(String name, int order, ClassFileTransformer transformer) {
        ArrayList<TransformerEntry> transformers = new ArrayList<TransformerEntry>();
        for (TransformerEntry o : this.fTransformers) {
            if (o.getClassTransformer() == transformer) continue;
            transformers.add(o);
        }
        Collections.sort(transformers);
        this.fTransformers = transformers;
    }

    public void unregisterMethodTransformer(String name, int order, IMethodTransformer transformer) {
        ArrayList<TransformerEntry> transformers = new ArrayList<TransformerEntry>();
        for (TransformerEntry o : this.fMethodTransformers) {
            if (o.getClassTransformer() == transformer) continue;
            transformers.add(o);
        }
        Collections.sort(transformers);
        this.fMethodTransformers = transformers;
    }

    private static final class TransformerEntry
    implements Comparable {
        private final String fName;
        private final int fOrder;
        private final Object fTransformer;

        public TransformerEntry(String name, int order, Object transformer) {
            this.fName = name;
            this.fOrder = order;
            this.fTransformer = transformer;
        }

        public String getName() {
            return this.fName;
        }

        public ClassFileTransformer getClassTransformer() {
            return (ClassFileTransformer)this.getTransformer();
        }

        public IMethodTransformer getMethodTransformer() {
            return (IMethodTransformer)this.getTransformer();
        }

        public Object getTransformer() {
            return this.fTransformer;
        }

        public int compareTo(Object o) {
            TransformerEntry entry = (TransformerEntry)o;
            return this.fOrder - entry.fOrder;
        }
    }
}

